// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.GetTimeSeriesDataPointResponse
import aws.sdk.kotlin.services.datazone.model.TimeSeriesDataPointFormOutput
import aws.sdk.kotlin.services.datazone.model.TimeSeriesEntityType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetTimeSeriesDataPointOperationDeserializer: HttpDeserializer.NonStreaming<GetTimeSeriesDataPointResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTimeSeriesDataPointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTimeSeriesDataPointError(context, call, payload)
        }
        val builder = GetTimeSeriesDataPointResponse.Builder()

        if (payload != null) {
            deserializeGetTimeSeriesDataPointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTimeSeriesDataPointError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTimeSeriesDataPointOperationBody(builder: GetTimeSeriesDataPointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val ENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entityId"))
    val ENTITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("entityType"))
    val FORM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("form"))
    val FORMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("formName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOMAINID_DESCRIPTOR)
        field(ENTITYID_DESCRIPTOR)
        field(ENTITYTYPE_DESCRIPTOR)
        field(FORM_DESCRIPTOR)
        field(FORMNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                ENTITYID_DESCRIPTOR.index -> builder.entityId = deserializeString()
                ENTITYTYPE_DESCRIPTOR.index -> builder.entityType = deserializeString().let { TimeSeriesEntityType.fromValue(it) }
                FORM_DESCRIPTOR.index -> builder.form = deserializeTimeSeriesDataPointFormOutputDocument(deserializer)
                FORMNAME_DESCRIPTOR.index -> builder.formName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
