// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.DeleteSubscriptionGrantResponse
import aws.sdk.kotlin.services.datazone.model.GrantedEntity
import aws.sdk.kotlin.services.datazone.model.SubscribedAsset
import aws.sdk.kotlin.services.datazone.model.SubscriptionGrantOverallStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DeleteSubscriptionGrantOperationDeserializer: HttpDeserializer.NonStreaming<DeleteSubscriptionGrantResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteSubscriptionGrantResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteSubscriptionGrantError(context, call, payload)
        }
        val builder = DeleteSubscriptionGrantResponse.Builder()

        if (payload != null) {
            deserializeDeleteSubscriptionGrantOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteSubscriptionGrantError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteSubscriptionGrantOperationBody(builder: DeleteSubscriptionGrantResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assets"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdBy"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val GRANTEDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("grantedEntity"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val SUBSCRIPTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("subscriptionId"))
    val SUBSCRIPTIONTARGETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("subscriptionTargetId"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val UPDATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("updatedBy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETS_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(GRANTEDENTITY_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUBSCRIPTIONID_DESCRIPTOR)
        field(SUBSCRIPTIONTARGETID_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
        field(UPDATEDBY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSETS_DESCRIPTOR.index -> builder.assets =
                    deserializer.deserializeList(ASSETS_DESCRIPTOR) {
                        val col0 = mutableListOf<SubscribedAsset>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSubscribedAssetDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                GRANTEDENTITY_DESCRIPTOR.index -> builder.grantedEntity = deserializeGrantedEntityDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SubscriptionGrantOverallStatus.fromValue(it) }
                SUBSCRIPTIONID_DESCRIPTOR.index -> builder.subscriptionId = deserializeString()
                SUBSCRIPTIONTARGETID_DESCRIPTOR.index -> builder.subscriptionTargetId = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                UPDATEDBY_DESCRIPTOR.index -> builder.updatedBy = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
