// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.CreateGlossaryTermResponse
import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.GlossaryTermStatus
import aws.sdk.kotlin.services.datazone.model.TermRelations
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateGlossaryTermOperationDeserializer: HttpDeserializer.NonStreaming<CreateGlossaryTermResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateGlossaryTermResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateGlossaryTermError(context, call, payload)
        }
        val builder = CreateGlossaryTermResponse.Builder()

        if (payload != null) {
            deserializeCreateGlossaryTermOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateGlossaryTermError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateGlossaryTermOperationBody(builder: CreateGlossaryTermResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val GLOSSARYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("glossaryId"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LONGDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("longDescription"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val SHORTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("shortDescription"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TERMRELATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("termRelations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOMAINID_DESCRIPTOR)
        field(GLOSSARYID_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LONGDESCRIPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SHORTDESCRIPTION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TERMRELATIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                GLOSSARYID_DESCRIPTOR.index -> builder.glossaryId = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LONGDESCRIPTION_DESCRIPTOR.index -> builder.longDescription = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SHORTDESCRIPTION_DESCRIPTOR.index -> builder.shortDescription = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { GlossaryTermStatus.fromValue(it) }
                TERMRELATIONS_DESCRIPTOR.index -> builder.termRelations = deserializeTermRelationsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
