// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.CreateAssetRequest
import aws.sdk.kotlin.services.datazone.model.FormInput
import aws.sdk.kotlin.services.datazone.model.PredictionConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateAssetOperationSerializer: HttpSerializer.NonStreaming<CreateAssetRequest> {
    override fun serialize(context: ExecutionContext, input: CreateAssetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainIdentifier) { "domainIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode(input.domainIdentifier))
                add(PercentEncoding.Path.encode("assets"))
            }
        }

        val payload = serializeCreateAssetOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateAssetOperationBody(context: ExecutionContext, input: CreateAssetRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val EXTERNALIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("externalIdentifier"))
    val FORMSINPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("formsInput"))
    val GLOSSARYTERMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("glossaryTerms"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OWNINGPROJECTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("owningProjectIdentifier"))
    val PREDICTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("predictionConfiguration"))
    val TYPEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("typeIdentifier"))
    val TYPEREVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("typeRevision"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXTERNALIDENTIFIER_DESCRIPTOR)
        field(FORMSINPUT_DESCRIPTOR)
        field(GLOSSARYTERMS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OWNINGPROJECTIDENTIFIER_DESCRIPTOR)
        field(PREDICTIONCONFIGURATION_DESCRIPTOR)
        field(TYPEIDENTIFIER_DESCRIPTOR)
        field(TYPEREVISION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.externalIdentifier?.let { field(EXTERNALIDENTIFIER_DESCRIPTOR, it) }
        if (input.formsInput != null) {
            listField(FORMSINPUT_DESCRIPTOR) {
                for (el0 in input.formsInput) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeFormInputDocument))
                }
            }
        }
        if (input.glossaryTerms != null) {
            listField(GLOSSARYTERMS_DESCRIPTOR) {
                for (el0 in input.glossaryTerms) {
                    serializeString(el0)
                }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.owningProjectIdentifier?.let { field(OWNINGPROJECTIDENTIFIER_DESCRIPTOR, it) }
        input.predictionConfiguration?.let { field(PREDICTIONCONFIGURATION_DESCRIPTOR, it, ::serializePredictionConfigurationDocument) }
        input.typeIdentifier?.let { field(TYPEIDENTIFIER_DESCRIPTOR, it) }
        input.typeRevision?.let { field(TYPEREVISION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
