// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.AcceptChoice
import aws.sdk.kotlin.services.datazone.model.AcceptPredictionsRequest
import aws.sdk.kotlin.services.datazone.model.AcceptRule
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class AcceptPredictionsOperationSerializer: HttpSerializer.NonStreaming<AcceptPredictionsRequest> {
    override fun serialize(context: ExecutionContext, input: AcceptPredictionsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.domainIdentifier) { "domainIdentifier is bound to the URI and must not be null" }
            requireNotNull(input.identifier) { "identifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode(input.domainIdentifier))
                add(PercentEncoding.Path.encode("assets"))
                add(PercentEncoding.SmithyLabel.encode(input.identifier))
                add(PercentEncoding.Path.encode("accept-predictions"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.revision != null) add("revision", input.revision)
            }
        }

        val payload = serializeAcceptPredictionsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeAcceptPredictionsOperationBody(context: ExecutionContext, input: AcceptPredictionsRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCEPTCHOICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("acceptChoices"))
    val ACCEPTRULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("acceptRule"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCEPTCHOICES_DESCRIPTOR)
        field(ACCEPTRULE_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.acceptChoices != null) {
            listField(ACCEPTCHOICES_DESCRIPTOR) {
                for (el0 in input.acceptChoices) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAcceptChoiceDocument))
                }
            }
        }
        input.acceptRule?.let { field(ACCEPTRULE_DESCRIPTOR, it, ::serializeAcceptRuleDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
    }
    return serializer.toByteArray()
}
