// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class UpdateSubscriptionGrantStatusResponse private constructor(builder: Builder) {
    /**
     * The details of the asset for which the subscription grant is created.
     */
    public val assets: List<SubscribedAsset>? = builder.assets
    /**
     * The timestamp of when the subscription grant status was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The Amazon DataZone domain user who created the subscription grant status.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The identifier of the Amazon DataZone domain in which a subscription grant status is to be updated.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The granted entity to be updated as part of the `UpdateSubscriptionGrantStatus` action.
     */
    public val grantedEntity: aws.sdk.kotlin.services.datazone.model.GrantedEntity? = builder.grantedEntity
    /**
     * The identifier of the subscription grant.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The status to be updated as part of the `UpdateSubscriptionGrantStatus` action.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.SubscriptionGrantOverallStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The identifier of the subscription.
     */
    public val subscriptionId: kotlin.String? = builder.subscriptionId
    /**
     * The identifier of the subscription target whose subscription grant status is to be updated.
     */
    public val subscriptionTargetId: kotlin.String = requireNotNull(builder.subscriptionTargetId) { "A non-null value must be provided for subscriptionTargetId" }
    /**
     * The timestamp of when the subscription grant status is to be updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * The Amazon DataZone user who updated the subscription grant status.
     */
    public val updatedBy: kotlin.String? = builder.updatedBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.UpdateSubscriptionGrantStatusResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSubscriptionGrantStatusResponse(")
        append("assets=$assets,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("domainId=$domainId,")
        append("grantedEntity=$grantedEntity,")
        append("id=$id,")
        append("status=$status,")
        append("subscriptionId=$subscriptionId,")
        append("subscriptionTargetId=$subscriptionTargetId,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assets?.hashCode() ?: 0
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (grantedEntity?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (subscriptionId?.hashCode() ?: 0)
        result = 31 * result + (subscriptionTargetId.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (updatedBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateSubscriptionGrantStatusResponse

        if (assets != other.assets) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (domainId != other.domainId) return false
        if (grantedEntity != other.grantedEntity) return false
        if (id != other.id) return false
        if (status != other.status) return false
        if (subscriptionId != other.subscriptionId) return false
        if (subscriptionTargetId != other.subscriptionTargetId) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.UpdateSubscriptionGrantStatusResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The details of the asset for which the subscription grant is created.
         */
        public var assets: List<SubscribedAsset>? = null
        /**
         * The timestamp of when the subscription grant status was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone domain user who created the subscription grant status.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain in which a subscription grant status is to be updated.
         */
        public var domainId: kotlin.String? = null
        /**
         * The granted entity to be updated as part of the `UpdateSubscriptionGrantStatus` action.
         */
        public var grantedEntity: aws.sdk.kotlin.services.datazone.model.GrantedEntity? = null
        /**
         * The identifier of the subscription grant.
         */
        public var id: kotlin.String? = null
        /**
         * The status to be updated as part of the `UpdateSubscriptionGrantStatus` action.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.SubscriptionGrantOverallStatus? = null
        /**
         * The identifier of the subscription.
         */
        public var subscriptionId: kotlin.String? = null
        /**
         * The identifier of the subscription target whose subscription grant status is to be updated.
         */
        public var subscriptionTargetId: kotlin.String? = null
        /**
         * The timestamp of when the subscription grant status is to be updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who updated the subscription grant status.
         */
        public var updatedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.UpdateSubscriptionGrantStatusResponse) : this() {
            this.assets = x.assets
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.domainId = x.domainId
            this.grantedEntity = x.grantedEntity
            this.id = x.id
            this.status = x.status
            this.subscriptionId = x.subscriptionId
            this.subscriptionTargetId = x.subscriptionTargetId
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.UpdateSubscriptionGrantStatusResponse = UpdateSubscriptionGrantStatusResponse(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (createdBy == null) createdBy = ""
            if (domainId == null) domainId = ""
            if (id == null) id = ""
            if (status == null) status = SubscriptionGrantOverallStatus.SdkUnknown("no value provided")
            if (subscriptionTargetId == null) subscriptionTargetId = ""
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
