// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class UpdateProjectResponse private constructor(builder: Builder) {
    /**
     * The timestamp of when the project was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon DataZone user who created the project.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The description of the project that is to be updated.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon DataZone domain in which a project is updated.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * Specifies the error message that is returned if the operation cannot be successfully completed.
     */
    public val failureReasons: List<ProjectDeletionError>? = builder.failureReasons
    /**
     * The glossary terms of the project that are to be updated.
     */
    public val glossaryTerms: List<String>? = builder.glossaryTerms
    /**
     * The identifier of the project that is to be updated.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The timestamp of when the project was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The name of the project that is to be updated.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the project.
     */
    public val projectStatus: aws.sdk.kotlin.services.datazone.model.ProjectStatus? = builder.projectStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.UpdateProjectResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateProjectResponse(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=*** Sensitive Data Redacted ***,")
        append("domainId=$domainId,")
        append("failureReasons=$failureReasons,")
        append("glossaryTerms=$glossaryTerms,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("name=*** Sensitive Data Redacted ***,")
        append("projectStatus=$projectStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (failureReasons?.hashCode() ?: 0)
        result = 31 * result + (glossaryTerms?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (projectStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateProjectResponse

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (domainId != other.domainId) return false
        if (failureReasons != other.failureReasons) return false
        if (glossaryTerms != other.glossaryTerms) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (name != other.name) return false
        if (projectStatus != other.projectStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.UpdateProjectResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the project was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who created the project.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The description of the project that is to be updated.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain in which a project is updated.
         */
        public var domainId: kotlin.String? = null
        /**
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         */
        public var failureReasons: List<ProjectDeletionError>? = null
        /**
         * The glossary terms of the project that are to be updated.
         */
        public var glossaryTerms: List<String>? = null
        /**
         * The identifier of the project that is to be updated.
         */
        public var id: kotlin.String? = null
        /**
         * The timestamp of when the project was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the project that is to be updated.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the project.
         */
        public var projectStatus: aws.sdk.kotlin.services.datazone.model.ProjectStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.UpdateProjectResponse) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.domainId = x.domainId
            this.failureReasons = x.failureReasons
            this.glossaryTerms = x.glossaryTerms
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.name = x.name
            this.projectStatus = x.projectStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.UpdateProjectResponse = UpdateProjectResponse(this)

        internal fun correctErrors(): Builder {
            if (createdBy == null) createdBy = ""
            if (domainId == null) domainId = ""
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
