// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration details of the Amazon Redshift data source.
 */
public class RedshiftRunConfigurationOutput private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account included in the configuration details of the Amazon Redshift data source.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The data access role included in the configuration details of the Amazon Redshift data source.
     */
    public val dataAccessRole: kotlin.String? = builder.dataAccessRole
    /**
     * The details of the credentials required to access an Amazon Redshift cluster.
     */
    public val redshiftCredentialConfiguration: aws.sdk.kotlin.services.datazone.model.RedshiftCredentialConfiguration? = builder.redshiftCredentialConfiguration
    /**
     * The details of the Amazon Redshift storage as part of the configuration of an Amazon Redshift data source run.
     */
    public val redshiftStorage: aws.sdk.kotlin.services.datazone.model.RedshiftStorage? = builder.redshiftStorage
    /**
     * The Amazon Web Services region included in the configuration details of the Amazon Redshift data source.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The relational filger configurations included in the configuration details of the Amazon Redshift data source.
     */
    public val relationalFilterConfigurations: List<RelationalFilterConfiguration> = requireNotNull(builder.relationalFilterConfigurations) { "A non-null value must be provided for relationalFilterConfigurations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.RedshiftRunConfigurationOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftRunConfigurationOutput(")
        append("accountId=$accountId,")
        append("dataAccessRole=$dataAccessRole,")
        append("redshiftCredentialConfiguration=$redshiftCredentialConfiguration,")
        append("redshiftStorage=$redshiftStorage,")
        append("region=$region,")
        append("relationalFilterConfigurations=$relationalFilterConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (dataAccessRole?.hashCode() ?: 0)
        result = 31 * result + (redshiftCredentialConfiguration?.hashCode() ?: 0)
        result = 31 * result + (redshiftStorage?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (relationalFilterConfigurations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftRunConfigurationOutput

        if (accountId != other.accountId) return false
        if (dataAccessRole != other.dataAccessRole) return false
        if (redshiftCredentialConfiguration != other.redshiftCredentialConfiguration) return false
        if (redshiftStorage != other.redshiftStorage) return false
        if (region != other.region) return false
        if (relationalFilterConfigurations != other.relationalFilterConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.RedshiftRunConfigurationOutput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account included in the configuration details of the Amazon Redshift data source.
         */
        public var accountId: kotlin.String? = null
        /**
         * The data access role included in the configuration details of the Amazon Redshift data source.
         */
        public var dataAccessRole: kotlin.String? = null
        /**
         * The details of the credentials required to access an Amazon Redshift cluster.
         */
        public var redshiftCredentialConfiguration: aws.sdk.kotlin.services.datazone.model.RedshiftCredentialConfiguration? = null
        /**
         * The details of the Amazon Redshift storage as part of the configuration of an Amazon Redshift data source run.
         */
        public var redshiftStorage: aws.sdk.kotlin.services.datazone.model.RedshiftStorage? = null
        /**
         * The Amazon Web Services region included in the configuration details of the Amazon Redshift data source.
         */
        public var region: kotlin.String? = null
        /**
         * The relational filger configurations included in the configuration details of the Amazon Redshift data source.
         */
        public var relationalFilterConfigurations: List<RelationalFilterConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.RedshiftRunConfigurationOutput) : this() {
            this.accountId = x.accountId
            this.dataAccessRole = x.dataAccessRole
            this.redshiftCredentialConfiguration = x.redshiftCredentialConfiguration
            this.redshiftStorage = x.redshiftStorage
            this.region = x.region
            this.relationalFilterConfigurations = x.relationalFilterConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.RedshiftRunConfigurationOutput = RedshiftRunConfigurationOutput(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.RedshiftCredentialConfiguration] inside the given [block]
         */
        public fun redshiftCredentialConfiguration(block: aws.sdk.kotlin.services.datazone.model.RedshiftCredentialConfiguration.Builder.() -> kotlin.Unit) {
            this.redshiftCredentialConfiguration = aws.sdk.kotlin.services.datazone.model.RedshiftCredentialConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (relationalFilterConfigurations == null) relationalFilterConfigurations = emptyList()
            return this
        }
    }
}
