// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListSubscriptionsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the project for the subscription's approver.
     */
    public val approverProjectId: kotlin.String? = builder.approverProjectId
    /**
     * The identifier of the Amazon DataZone domain.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The maximum number of subscriptions to return in a single call to `ListSubscriptions`. When the number of subscriptions to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListSubscriptions` to list the next set of Subscriptions.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When the number of subscriptions is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of subscriptions, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListSubscriptions` to list the next set of subscriptions.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The identifier of the owning project.
     */
    public val owningProjectId: kotlin.String? = builder.owningProjectId
    /**
     * Specifies the way in which the results of this action are to be sorted.
     */
    public val sortBy: aws.sdk.kotlin.services.datazone.model.SortKey? = builder.sortBy
    /**
     * Specifies the sort order for the results of this action.
     */
    public val sortOrder: aws.sdk.kotlin.services.datazone.model.SortOrder? = builder.sortOrder
    /**
     * The status of the subscriptions that you want to list.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.SubscriptionStatus? = builder.status
    /**
     * The identifier of the subscribed listing for the subscriptions that you want to list.
     */
    public val subscribedListingId: kotlin.String? = builder.subscribedListingId
    /**
     * The identifier of the subscription request for the subscriptions that you want to list.
     */
    public val subscriptionRequestIdentifier: kotlin.String? = builder.subscriptionRequestIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.ListSubscriptionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSubscriptionsRequest(")
        append("approverProjectId=$approverProjectId,")
        append("domainIdentifier=$domainIdentifier,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("owningProjectId=$owningProjectId,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder,")
        append("status=$status,")
        append("subscribedListingId=$subscribedListingId,")
        append("subscriptionRequestIdentifier=$subscriptionRequestIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = approverProjectId?.hashCode() ?: 0
        result = 31 * result + (domainIdentifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (owningProjectId?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subscribedListingId?.hashCode() ?: 0)
        result = 31 * result + (subscriptionRequestIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSubscriptionsRequest

        if (approverProjectId != other.approverProjectId) return false
        if (domainIdentifier != other.domainIdentifier) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (owningProjectId != other.owningProjectId) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false
        if (status != other.status) return false
        if (subscribedListingId != other.subscribedListingId) return false
        if (subscriptionRequestIdentifier != other.subscriptionRequestIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.ListSubscriptionsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the project for the subscription's approver.
         */
        public var approverProjectId: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The maximum number of subscriptions to return in a single call to `ListSubscriptions`. When the number of subscriptions to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListSubscriptions` to list the next set of Subscriptions.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When the number of subscriptions is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of subscriptions, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListSubscriptions` to list the next set of subscriptions.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The identifier of the owning project.
         */
        public var owningProjectId: kotlin.String? = null
        /**
         * Specifies the way in which the results of this action are to be sorted.
         */
        public var sortBy: aws.sdk.kotlin.services.datazone.model.SortKey? = null
        /**
         * Specifies the sort order for the results of this action.
         */
        public var sortOrder: aws.sdk.kotlin.services.datazone.model.SortOrder? = null
        /**
         * The status of the subscriptions that you want to list.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.SubscriptionStatus? = null
        /**
         * The identifier of the subscribed listing for the subscriptions that you want to list.
         */
        public var subscribedListingId: kotlin.String? = null
        /**
         * The identifier of the subscription request for the subscriptions that you want to list.
         */
        public var subscriptionRequestIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.ListSubscriptionsRequest) : this() {
            this.approverProjectId = x.approverProjectId
            this.domainIdentifier = x.domainIdentifier
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.owningProjectId = x.owningProjectId
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
            this.status = x.status
            this.subscribedListingId = x.subscribedListingId
            this.subscriptionRequestIdentifier = x.subscriptionRequestIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.ListSubscriptionsRequest = ListSubscriptionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
