// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListSubscriptionGrantsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon DataZone domain.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The identifier of the Amazon DataZone environment.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * The maximum number of subscription grants to return in a single call to `ListSubscriptionGrants`. When the number of subscription grants to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListSubscriptionGrants` to list the next set of subscription grants.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When the number of subscription grants is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of subscription grants, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListSubscriptionGrants` to list the next set of subscription grants.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Specifies the way of sorting the results of this action.
     */
    public val sortBy: aws.sdk.kotlin.services.datazone.model.SortKey? = builder.sortBy
    /**
     * Specifies the sort order of this action.
     */
    public val sortOrder: aws.sdk.kotlin.services.datazone.model.SortOrder? = builder.sortOrder
    /**
     * The identifier of the subscribed listing.
     */
    public val subscribedListingId: kotlin.String? = builder.subscribedListingId
    /**
     * The identifier of the subscription.
     */
    public val subscriptionId: kotlin.String? = builder.subscriptionId
    /**
     * The identifier of the subscription target.
     */
    public val subscriptionTargetId: kotlin.String? = builder.subscriptionTargetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.ListSubscriptionGrantsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSubscriptionGrantsRequest(")
        append("domainIdentifier=$domainIdentifier,")
        append("environmentId=$environmentId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder,")
        append("subscribedListingId=$subscribedListingId,")
        append("subscriptionId=$subscriptionId,")
        append("subscriptionTargetId=$subscriptionTargetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainIdentifier?.hashCode() ?: 0
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        result = 31 * result + (subscribedListingId?.hashCode() ?: 0)
        result = 31 * result + (subscriptionId?.hashCode() ?: 0)
        result = 31 * result + (subscriptionTargetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSubscriptionGrantsRequest

        if (domainIdentifier != other.domainIdentifier) return false
        if (environmentId != other.environmentId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false
        if (subscribedListingId != other.subscribedListingId) return false
        if (subscriptionId != other.subscriptionId) return false
        if (subscriptionTargetId != other.subscriptionTargetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.ListSubscriptionGrantsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon DataZone domain.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone environment.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The maximum number of subscription grants to return in a single call to `ListSubscriptionGrants`. When the number of subscription grants to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListSubscriptionGrants` to list the next set of subscription grants.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When the number of subscription grants is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of subscription grants, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListSubscriptionGrants` to list the next set of subscription grants.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Specifies the way of sorting the results of this action.
         */
        public var sortBy: aws.sdk.kotlin.services.datazone.model.SortKey? = null
        /**
         * Specifies the sort order of this action.
         */
        public var sortOrder: aws.sdk.kotlin.services.datazone.model.SortOrder? = null
        /**
         * The identifier of the subscribed listing.
         */
        public var subscribedListingId: kotlin.String? = null
        /**
         * The identifier of the subscription.
         */
        public var subscriptionId: kotlin.String? = null
        /**
         * The identifier of the subscription target.
         */
        public var subscriptionTargetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.ListSubscriptionGrantsRequest) : this() {
            this.domainIdentifier = x.domainIdentifier
            this.environmentId = x.environmentId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
            this.subscribedListingId = x.subscribedListingId
            this.subscriptionId = x.subscriptionId
            this.subscriptionTargetId = x.subscriptionTargetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.ListSubscriptionGrantsRequest = ListSubscriptionGrantsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
