// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListProjectMembershipsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon DataZone domain in which you want to list project memberships.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The maximum number of memberships to return in a single call to `ListProjectMemberships`. When the number of memberships to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListProjectMemberships` to list the next set of memberships.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When the number of memberships is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of memberships, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListProjectMemberships` to list the next set of memberships.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The identifier of the project whose memberships you want to list.
     */
    public val projectIdentifier: kotlin.String? = builder.projectIdentifier
    /**
     * The method by which you want to sort the project memberships.
     */
    public val sortBy: aws.sdk.kotlin.services.datazone.model.SortFieldProject? = builder.sortBy
    /**
     * The sort order of the project memberships.
     */
    public val sortOrder: aws.sdk.kotlin.services.datazone.model.SortOrder? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.ListProjectMembershipsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListProjectMembershipsRequest(")
        append("domainIdentifier=$domainIdentifier,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("projectIdentifier=$projectIdentifier,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainIdentifier?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (projectIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListProjectMembershipsRequest

        if (domainIdentifier != other.domainIdentifier) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (projectIdentifier != other.projectIdentifier) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.ListProjectMembershipsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon DataZone domain in which you want to list project memberships.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The maximum number of memberships to return in a single call to `ListProjectMemberships`. When the number of memberships to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListProjectMemberships` to list the next set of memberships.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When the number of memberships is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of memberships, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListProjectMemberships` to list the next set of memberships.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The identifier of the project whose memberships you want to list.
         */
        public var projectIdentifier: kotlin.String? = null
        /**
         * The method by which you want to sort the project memberships.
         */
        public var sortBy: aws.sdk.kotlin.services.datazone.model.SortFieldProject? = null
        /**
         * The sort order of the project memberships.
         */
        public var sortOrder: aws.sdk.kotlin.services.datazone.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.ListProjectMembershipsRequest) : this() {
            this.domainIdentifier = x.domainIdentifier
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.projectIdentifier = x.projectIdentifier
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.ListProjectMembershipsRequest = ListProjectMembershipsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
