// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListEnvironmentProfilesRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Web Services account where you want to list environment profiles.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The Amazon Web Services region where you want to list environment profiles.
     */
    public val awsAccountRegion: kotlin.String? = builder.awsAccountRegion
    /**
     * The identifier of the Amazon DataZone domain.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The identifier of the blueprint that was used to create the environment profiles that you want to list.
     */
    public val environmentBlueprintIdentifier: kotlin.String? = builder.environmentBlueprintIdentifier
    /**
     * The maximum number of environment profiles to return in a single call to `ListEnvironmentProfiles`. When the number of environment profiles to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListEnvironmentProfiles` to list the next set of environment profiles.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     *
     */
    public val name: kotlin.String? = builder.name
    /**
     * When the number of environment profiles is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of environment profiles, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListEnvironmentProfiles` to list the next set of environment profiles.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The identifier of the Amazon DataZone project.
     */
    public val projectIdentifier: kotlin.String? = builder.projectIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.ListEnvironmentProfilesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListEnvironmentProfilesRequest(")
        append("awsAccountId=$awsAccountId,")
        append("awsAccountRegion=$awsAccountRegion,")
        append("domainIdentifier=$domainIdentifier,")
        append("environmentBlueprintIdentifier=$environmentBlueprintIdentifier,")
        append("maxResults=$maxResults,")
        append("name=*** Sensitive Data Redacted ***,")
        append("nextToken=$nextToken,")
        append("projectIdentifier=$projectIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (awsAccountRegion?.hashCode() ?: 0)
        result = 31 * result + (domainIdentifier?.hashCode() ?: 0)
        result = 31 * result + (environmentBlueprintIdentifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (projectIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListEnvironmentProfilesRequest

        if (awsAccountId != other.awsAccountId) return false
        if (awsAccountRegion != other.awsAccountRegion) return false
        if (domainIdentifier != other.domainIdentifier) return false
        if (environmentBlueprintIdentifier != other.environmentBlueprintIdentifier) return false
        if (maxResults != other.maxResults) return false
        if (name != other.name) return false
        if (nextToken != other.nextToken) return false
        if (projectIdentifier != other.projectIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.ListEnvironmentProfilesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon Web Services account where you want to list environment profiles.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The Amazon Web Services region where you want to list environment profiles.
         */
        public var awsAccountRegion: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The identifier of the blueprint that was used to create the environment profiles that you want to list.
         */
        public var environmentBlueprintIdentifier: kotlin.String? = null
        /**
         * The maximum number of environment profiles to return in a single call to `ListEnvironmentProfiles`. When the number of environment profiles to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListEnvironmentProfiles` to list the next set of environment profiles.
         */
        public var maxResults: kotlin.Int? = null
        /**
         *
         */
        public var name: kotlin.String? = null
        /**
         * When the number of environment profiles is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of environment profiles, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListEnvironmentProfiles` to list the next set of environment profiles.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone project.
         */
        public var projectIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.ListEnvironmentProfilesRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.awsAccountRegion = x.awsAccountRegion
            this.domainIdentifier = x.domainIdentifier
            this.environmentBlueprintIdentifier = x.environmentBlueprintIdentifier
            this.maxResults = x.maxResults
            this.name = x.name
            this.nextToken = x.nextToken
            this.projectIdentifier = x.projectIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.ListEnvironmentProfilesRequest = ListEnvironmentProfilesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
