// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListDataSourcesRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon DataZone domain in which to list the data sources.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The identifier of the environment in which to list the data sources.
     */
    public val environmentIdentifier: kotlin.String? = builder.environmentIdentifier
    /**
     * The maximum number of data sources to return in a single call to `ListDataSources`. When the number of data sources to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListDataSources` to list the next set of data sources.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The name of the data source.
     */
    public val name: kotlin.String? = builder.name
    /**
     * When the number of data sources is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of data sources, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListDataSources` to list the next set of data sources.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The identifier of the project in which to list data sources.
     */
    public val projectIdentifier: kotlin.String? = builder.projectIdentifier
    /**
     * The status of the data source.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.DataSourceStatus? = builder.status
    /**
     * The type of the data source.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.ListDataSourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDataSourcesRequest(")
        append("domainIdentifier=$domainIdentifier,")
        append("environmentIdentifier=$environmentIdentifier,")
        append("maxResults=$maxResults,")
        append("name=*** Sensitive Data Redacted ***,")
        append("nextToken=$nextToken,")
        append("projectIdentifier=$projectIdentifier,")
        append("status=$status,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainIdentifier?.hashCode() ?: 0
        result = 31 * result + (environmentIdentifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (projectIdentifier?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDataSourcesRequest

        if (domainIdentifier != other.domainIdentifier) return false
        if (environmentIdentifier != other.environmentIdentifier) return false
        if (maxResults != other.maxResults) return false
        if (name != other.name) return false
        if (nextToken != other.nextToken) return false
        if (projectIdentifier != other.projectIdentifier) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.ListDataSourcesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the Amazon DataZone domain in which to list the data sources.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The identifier of the environment in which to list the data sources.
         */
        public var environmentIdentifier: kotlin.String? = null
        /**
         * The maximum number of data sources to return in a single call to `ListDataSources`. When the number of data sources to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListDataSources` to list the next set of data sources.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The name of the data source.
         */
        public var name: kotlin.String? = null
        /**
         * When the number of data sources is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of data sources, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListDataSources` to list the next set of data sources.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The identifier of the project in which to list data sources.
         */
        public var projectIdentifier: kotlin.String? = null
        /**
         * The status of the data source.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.DataSourceStatus? = null
        /**
         * The type of the data source.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.ListDataSourcesRequest) : this() {
            this.domainIdentifier = x.domainIdentifier
            this.environmentIdentifier = x.environmentIdentifier
            this.maxResults = x.maxResults
            this.name = x.name
            this.nextToken = x.nextToken
            this.projectIdentifier = x.projectIdentifier
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.ListDataSourcesRequest = ListDataSourcesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
