// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a business glossary term.
 */
public class GlossaryTermItem private constructor(builder: Builder) {
    /**
     * The timestamp of when a business glossary term was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon DataZone user who created the business glossary.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The identifier of the Amazon DataZone domain in which the business glossary exists.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The identifier of the business glossary to which the term belongs.
     */
    public val glossaryId: kotlin.String = requireNotNull(builder.glossaryId) { "A non-null value must be provided for glossaryId" }
    /**
     * The identifier of the business glossary term.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The long description of the business glossary term.
     */
    public val longDescription: kotlin.String? = builder.longDescription
    /**
     * The name of the business glossary term.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The short description of the business glossary term.
     */
    public val shortDescription: kotlin.String? = builder.shortDescription
    /**
     * The status of the business glossary term.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.GlossaryTermStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The relations of the business glossary term.
     */
    public val termRelations: aws.sdk.kotlin.services.datazone.model.TermRelations? = builder.termRelations
    /**
     * The timestamp of when a business glossary term was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The Amazon DataZone user who updated the business glossary term.
     */
    public val updatedBy: kotlin.String? = builder.updatedBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.GlossaryTermItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlossaryTermItem(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("domainId=$domainId,")
        append("glossaryId=$glossaryId,")
        append("id=$id,")
        append("longDescription=*** Sensitive Data Redacted ***,")
        append("name=*** Sensitive Data Redacted ***,")
        append("shortDescription=*** Sensitive Data Redacted ***,")
        append("status=$status,")
        append("termRelations=$termRelations,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (glossaryId.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (longDescription?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (shortDescription?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (termRelations?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (updatedBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlossaryTermItem

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (domainId != other.domainId) return false
        if (glossaryId != other.glossaryId) return false
        if (id != other.id) return false
        if (longDescription != other.longDescription) return false
        if (name != other.name) return false
        if (shortDescription != other.shortDescription) return false
        if (status != other.status) return false
        if (termRelations != other.termRelations) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.GlossaryTermItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when a business glossary term was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who created the business glossary.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain in which the business glossary exists.
         */
        public var domainId: kotlin.String? = null
        /**
         * The identifier of the business glossary to which the term belongs.
         */
        public var glossaryId: kotlin.String? = null
        /**
         * The identifier of the business glossary term.
         */
        public var id: kotlin.String? = null
        /**
         * The long description of the business glossary term.
         */
        public var longDescription: kotlin.String? = null
        /**
         * The name of the business glossary term.
         */
        public var name: kotlin.String? = null
        /**
         * The short description of the business glossary term.
         */
        public var shortDescription: kotlin.String? = null
        /**
         * The status of the business glossary term.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.GlossaryTermStatus? = null
        /**
         * The relations of the business glossary term.
         */
        public var termRelations: aws.sdk.kotlin.services.datazone.model.TermRelations? = null
        /**
         * The timestamp of when a business glossary term was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who updated the business glossary term.
         */
        public var updatedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.GlossaryTermItem) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.domainId = x.domainId
            this.glossaryId = x.glossaryId
            this.id = x.id
            this.longDescription = x.longDescription
            this.name = x.name
            this.shortDescription = x.shortDescription
            this.status = x.status
            this.termRelations = x.termRelations
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.GlossaryTermItem = GlossaryTermItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.TermRelations] inside the given [block]
         */
        public fun termRelations(block: aws.sdk.kotlin.services.datazone.model.TermRelations.Builder.() -> kotlin.Unit) {
            this.termRelations = aws.sdk.kotlin.services.datazone.model.TermRelations.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (domainId == null) domainId = ""
            if (glossaryId == null) glossaryId = ""
            if (id == null) id = ""
            if (name == null) name = ""
            if (status == null) status = GlossaryTermStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
