// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a business glossary.
 */
public class GlossaryItem private constructor(builder: Builder) {
    /**
     * The timestamp of when the glossary was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon DataZone user who created the glossary.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The business glossary description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon DataZone domain in which the business glossary exists.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The identifier of the glossary.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The name of the glossary.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The identifier of the project that owns the business glosary.
     */
    public val owningProjectId: kotlin.String = requireNotNull(builder.owningProjectId) { "A non-null value must be provided for owningProjectId" }
    /**
     * The business glossary status.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.GlossaryStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The timestamp of when the business glossary was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The Amazon DataZone user who updated the business glossary.
     */
    public val updatedBy: kotlin.String? = builder.updatedBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.GlossaryItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlossaryItem(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=*** Sensitive Data Redacted ***,")
        append("domainId=$domainId,")
        append("id=$id,")
        append("name=*** Sensitive Data Redacted ***,")
        append("owningProjectId=$owningProjectId,")
        append("status=$status,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (owningProjectId.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (updatedBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlossaryItem

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (domainId != other.domainId) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (owningProjectId != other.owningProjectId) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.GlossaryItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the glossary was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who created the glossary.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The business glossary description.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain in which the business glossary exists.
         */
        public var domainId: kotlin.String? = null
        /**
         * The identifier of the glossary.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the glossary.
         */
        public var name: kotlin.String? = null
        /**
         * The identifier of the project that owns the business glosary.
         */
        public var owningProjectId: kotlin.String? = null
        /**
         * The business glossary status.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.GlossaryStatus? = null
        /**
         * The timestamp of when the business glossary was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who updated the business glossary.
         */
        public var updatedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.GlossaryItem) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.domainId = x.domainId
            this.id = x.id
            this.name = x.name
            this.owningProjectId = x.owningProjectId
            this.status = x.status
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.GlossaryItem = GlossaryItem(this)

        internal fun correctErrors(): Builder {
            if (domainId == null) domainId = ""
            if (id == null) id = ""
            if (name == null) name = ""
            if (owningProjectId == null) owningProjectId = ""
            if (status == null) status = GlossaryStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
