// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetSubscriptionResponse private constructor(builder: Builder) {
    /**
     * The timestamp of when the subscription was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The Amazon DataZone user who created the subscription.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The ID of the Amazon DataZone domain in which the subscription exists.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The ID of the subscription.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The retain permissions of the subscription.
     */
    public val retainPermissions: kotlin.Boolean? = builder.retainPermissions
    /**
     * The status of the subscription.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.SubscriptionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The details of the published asset for which the subscription grant is created.
     */
    public val subscribedListing: aws.sdk.kotlin.services.datazone.model.SubscribedListing? = builder.subscribedListing
    /**
     * The principal that owns the subscription.
     */
    public val subscribedPrincipal: aws.sdk.kotlin.services.datazone.model.SubscribedPrincipal? = builder.subscribedPrincipal
    /**
     * The ID of the subscription request.
     */
    public val subscriptionRequestId: kotlin.String? = builder.subscriptionRequestId
    /**
     * The timestamp of when the subscription was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * The Amazon DataZone user who updated the subscription.
     */
    public val updatedBy: kotlin.String? = builder.updatedBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.GetSubscriptionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSubscriptionResponse(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("domainId=$domainId,")
        append("id=$id,")
        append("retainPermissions=$retainPermissions,")
        append("status=$status,")
        append("subscribedListing=$subscribedListing,")
        append("subscribedPrincipal=$subscribedPrincipal,")
        append("subscriptionRequestId=$subscriptionRequestId,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (retainPermissions?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (subscribedListing?.hashCode() ?: 0)
        result = 31 * result + (subscribedPrincipal?.hashCode() ?: 0)
        result = 31 * result + (subscriptionRequestId?.hashCode() ?: 0)
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (updatedBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSubscriptionResponse

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (domainId != other.domainId) return false
        if (id != other.id) return false
        if (retainPermissions != other.retainPermissions) return false
        if (status != other.status) return false
        if (subscribedListing != other.subscribedListing) return false
        if (subscribedPrincipal != other.subscribedPrincipal) return false
        if (subscriptionRequestId != other.subscriptionRequestId) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.GetSubscriptionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the subscription was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who created the subscription.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone domain in which the subscription exists.
         */
        public var domainId: kotlin.String? = null
        /**
         * The ID of the subscription.
         */
        public var id: kotlin.String? = null
        /**
         * The retain permissions of the subscription.
         */
        public var retainPermissions: kotlin.Boolean? = null
        /**
         * The status of the subscription.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.SubscriptionStatus? = null
        /**
         * The details of the published asset for which the subscription grant is created.
         */
        public var subscribedListing: aws.sdk.kotlin.services.datazone.model.SubscribedListing? = null
        /**
         * The principal that owns the subscription.
         */
        public var subscribedPrincipal: aws.sdk.kotlin.services.datazone.model.SubscribedPrincipal? = null
        /**
         * The ID of the subscription request.
         */
        public var subscriptionRequestId: kotlin.String? = null
        /**
         * The timestamp of when the subscription was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who updated the subscription.
         */
        public var updatedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.GetSubscriptionResponse) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.domainId = x.domainId
            this.id = x.id
            this.retainPermissions = x.retainPermissions
            this.status = x.status
            this.subscribedListing = x.subscribedListing
            this.subscribedPrincipal = x.subscribedPrincipal
            this.subscriptionRequestId = x.subscriptionRequestId
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.GetSubscriptionResponse = GetSubscriptionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.SubscribedListing] inside the given [block]
         */
        public fun subscribedListing(block: aws.sdk.kotlin.services.datazone.model.SubscribedListing.Builder.() -> kotlin.Unit) {
            this.subscribedListing = aws.sdk.kotlin.services.datazone.model.SubscribedListing.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (createdBy == null) createdBy = ""
            if (domainId == null) domainId = ""
            if (id == null) id = ""
            if (status == null) status = SubscriptionStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
