// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of a Amazon DataZone domain.
 */
public class DomainSummary private constructor(builder: Builder) {
    /**
     * The ARN of the Amazon DataZone domain.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * A timestamp of when a Amazon DataZone domain was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * A description of an Amazon DataZone domain.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the Amazon DataZone domain.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * A timestamp of when a Amazon DataZone domain was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The identifier of the Amazon Web Services account that manages the domain.
     */
    public val managedAccountId: kotlin.String = requireNotNull(builder.managedAccountId) { "A non-null value must be provided for managedAccountId" }
    /**
     * A name of an Amazon DataZone domain.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The data portal URL for the Amazon DataZone domain.
     */
    public val portalUrl: kotlin.String? = builder.portalUrl
    /**
     * The status of the Amazon DataZone domain.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.DomainStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.DomainSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("description=*** Sensitive Data Redacted ***,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("managedAccountId=$managedAccountId,")
        append("name=*** Sensitive Data Redacted ***,")
        append("portalUrl=$portalUrl,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (managedAccountId.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (portalUrl?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (managedAccountId != other.managedAccountId) return false
        if (name != other.name) return false
        if (portalUrl != other.portalUrl) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.DomainSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the Amazon DataZone domain.
         */
        public var arn: kotlin.String? = null
        /**
         * A timestamp of when a Amazon DataZone domain was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of an Amazon DataZone domain.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone domain.
         */
        public var id: kotlin.String? = null
        /**
         * A timestamp of when a Amazon DataZone domain was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the Amazon Web Services account that manages the domain.
         */
        public var managedAccountId: kotlin.String? = null
        /**
         * A name of an Amazon DataZone domain.
         */
        public var name: kotlin.String? = null
        /**
         * The data portal URL for the Amazon DataZone domain.
         */
        public var portalUrl: kotlin.String? = null
        /**
         * The status of the Amazon DataZone domain.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.DomainStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.DomainSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.description = x.description
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.managedAccountId = x.managedAccountId
            this.name = x.name
            this.portalUrl = x.portalUrl
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.DomainSummary = DomainSummary(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (managedAccountId == null) managedAccountId = ""
            if (name == null) name = ""
            if (status == null) status = DomainStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
