// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateSubscriptionTargetResponse private constructor(builder: Builder) {
    /**
     * The asset types that can be included in the subscription target.
     */
    public val applicableAssetTypes: List<String> = requireNotNull(builder.applicableAssetTypes) { "A non-null value must be provided for applicableAssetTypes" }
    /**
     * The authorised principals of the subscription target.
     */
    public val authorizedPrincipals: List<String> = requireNotNull(builder.authorizedPrincipals) { "A non-null value must be provided for authorizedPrincipals" }
    /**
     * The timestamp of when the subscription target was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The Amazon DataZone user who created the subscription target.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The ID of the Amazon DataZone domain in which the subscription target was created.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The ID of the environment in which the subscription target was created.
     */
    public val environmentId: kotlin.String = requireNotNull(builder.environmentId) { "A non-null value must be provided for environmentId" }
    /**
     * The ID of the subscription target.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The manage access role with which the subscription target was created.
     */
    public val manageAccessRole: kotlin.String = requireNotNull(builder.manageAccessRole) { "A non-null value must be provided for manageAccessRole" }
    /**
     * The name of the subscription target.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * ???
     */
    public val projectId: kotlin.String = requireNotNull(builder.projectId) { "A non-null value must be provided for projectId" }
    /**
     * The provider of the subscription target.
     */
    public val provider: kotlin.String = requireNotNull(builder.provider) { "A non-null value must be provided for provider" }
    /**
     * The configuration of the subscription target.
     */
    public val subscriptionTargetConfig: List<SubscriptionTargetForm> = requireNotNull(builder.subscriptionTargetConfig) { "A non-null value must be provided for subscriptionTargetConfig" }
    /**
     * The type of the subscription target.
     */
    public val type: kotlin.String = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The timestamp of when the subscription target was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The Amazon DataZone user who updated the subscription target.
     */
    public val updatedBy: kotlin.String? = builder.updatedBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.CreateSubscriptionTargetResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSubscriptionTargetResponse(")
        append("applicableAssetTypes=$applicableAssetTypes,")
        append("authorizedPrincipals=$authorizedPrincipals,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("domainId=$domainId,")
        append("environmentId=$environmentId,")
        append("id=$id,")
        append("manageAccessRole=$manageAccessRole,")
        append("name=*** Sensitive Data Redacted ***,")
        append("projectId=$projectId,")
        append("provider=$provider,")
        append("subscriptionTargetConfig=$subscriptionTargetConfig,")
        append("type=$type,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicableAssetTypes.hashCode()
        result = 31 * result + (authorizedPrincipals.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (environmentId.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (manageAccessRole.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (projectId.hashCode())
        result = 31 * result + (provider.hashCode())
        result = 31 * result + (subscriptionTargetConfig.hashCode())
        result = 31 * result + (type.hashCode())
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (updatedBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSubscriptionTargetResponse

        if (applicableAssetTypes != other.applicableAssetTypes) return false
        if (authorizedPrincipals != other.authorizedPrincipals) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (domainId != other.domainId) return false
        if (environmentId != other.environmentId) return false
        if (id != other.id) return false
        if (manageAccessRole != other.manageAccessRole) return false
        if (name != other.name) return false
        if (projectId != other.projectId) return false
        if (provider != other.provider) return false
        if (subscriptionTargetConfig != other.subscriptionTargetConfig) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.CreateSubscriptionTargetResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The asset types that can be included in the subscription target.
         */
        public var applicableAssetTypes: List<String>? = null
        /**
         * The authorised principals of the subscription target.
         */
        public var authorizedPrincipals: List<String>? = null
        /**
         * The timestamp of when the subscription target was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who created the subscription target.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone domain in which the subscription target was created.
         */
        public var domainId: kotlin.String? = null
        /**
         * The ID of the environment in which the subscription target was created.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The ID of the subscription target.
         */
        public var id: kotlin.String? = null
        /**
         * The manage access role with which the subscription target was created.
         */
        public var manageAccessRole: kotlin.String? = null
        /**
         * The name of the subscription target.
         */
        public var name: kotlin.String? = null
        /**
         * ???
         */
        public var projectId: kotlin.String? = null
        /**
         * The provider of the subscription target.
         */
        public var provider: kotlin.String? = null
        /**
         * The configuration of the subscription target.
         */
        public var subscriptionTargetConfig: List<SubscriptionTargetForm>? = null
        /**
         * The type of the subscription target.
         */
        public var type: kotlin.String? = null
        /**
         * The timestamp of when the subscription target was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who updated the subscription target.
         */
        public var updatedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.CreateSubscriptionTargetResponse) : this() {
            this.applicableAssetTypes = x.applicableAssetTypes
            this.authorizedPrincipals = x.authorizedPrincipals
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.domainId = x.domainId
            this.environmentId = x.environmentId
            this.id = x.id
            this.manageAccessRole = x.manageAccessRole
            this.name = x.name
            this.projectId = x.projectId
            this.provider = x.provider
            this.subscriptionTargetConfig = x.subscriptionTargetConfig
            this.type = x.type
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.CreateSubscriptionTargetResponse = CreateSubscriptionTargetResponse(this)

        internal fun correctErrors(): Builder {
            if (applicableAssetTypes == null) applicableAssetTypes = emptyList()
            if (authorizedPrincipals == null) authorizedPrincipals = emptyList()
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (createdBy == null) createdBy = ""
            if (domainId == null) domainId = ""
            if (environmentId == null) environmentId = ""
            if (id == null) id = ""
            if (manageAccessRole == null) manageAccessRole = ""
            if (name == null) name = ""
            if (projectId == null) projectId = ""
            if (provider == null) provider = ""
            if (subscriptionTargetConfig == null) subscriptionTargetConfig = emptyList()
            if (type == null) type = ""
            return this
        }
    }
}
