// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateGlossaryTermResponse private constructor(builder: Builder) {
    /**
     * The ID of the Amazon DataZone domain in which this business glossary term is created.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The ID of the business glossary in which this term is created.
     */
    public val glossaryId: kotlin.String = requireNotNull(builder.glossaryId) { "A non-null value must be provided for glossaryId" }
    /**
     * The ID of this business glossary term.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The long description of this business glossary term.
     */
    public val longDescription: kotlin.String? = builder.longDescription
    /**
     * The name of this business glossary term.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The short description of this business glossary term.
     */
    public val shortDescription: kotlin.String? = builder.shortDescription
    /**
     * The status of this business glossary term.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.GlossaryTermStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The term relations of this business glossary term.
     */
    public val termRelations: aws.sdk.kotlin.services.datazone.model.TermRelations? = builder.termRelations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.CreateGlossaryTermResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGlossaryTermResponse(")
        append("domainId=$domainId,")
        append("glossaryId=$glossaryId,")
        append("id=$id,")
        append("longDescription=*** Sensitive Data Redacted ***,")
        append("name=*** Sensitive Data Redacted ***,")
        append("shortDescription=*** Sensitive Data Redacted ***,")
        append("status=$status,")
        append("termRelations=$termRelations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainId.hashCode()
        result = 31 * result + (glossaryId.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (longDescription?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (shortDescription?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (termRelations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGlossaryTermResponse

        if (domainId != other.domainId) return false
        if (glossaryId != other.glossaryId) return false
        if (id != other.id) return false
        if (longDescription != other.longDescription) return false
        if (name != other.name) return false
        if (shortDescription != other.shortDescription) return false
        if (status != other.status) return false
        if (termRelations != other.termRelations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.CreateGlossaryTermResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon DataZone domain in which this business glossary term is created.
         */
        public var domainId: kotlin.String? = null
        /**
         * The ID of the business glossary in which this term is created.
         */
        public var glossaryId: kotlin.String? = null
        /**
         * The ID of this business glossary term.
         */
        public var id: kotlin.String? = null
        /**
         * The long description of this business glossary term.
         */
        public var longDescription: kotlin.String? = null
        /**
         * The name of this business glossary term.
         */
        public var name: kotlin.String? = null
        /**
         * The short description of this business glossary term.
         */
        public var shortDescription: kotlin.String? = null
        /**
         * The status of this business glossary term.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.GlossaryTermStatus? = null
        /**
         * The term relations of this business glossary term.
         */
        public var termRelations: aws.sdk.kotlin.services.datazone.model.TermRelations? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.CreateGlossaryTermResponse) : this() {
            this.domainId = x.domainId
            this.glossaryId = x.glossaryId
            this.id = x.id
            this.longDescription = x.longDescription
            this.name = x.name
            this.shortDescription = x.shortDescription
            this.status = x.status
            this.termRelations = x.termRelations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.CreateGlossaryTermResponse = CreateGlossaryTermResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.TermRelations] inside the given [block]
         */
        public fun termRelations(block: aws.sdk.kotlin.services.datazone.model.TermRelations.Builder.() -> kotlin.Unit) {
            this.termRelations = aws.sdk.kotlin.services.datazone.model.TermRelations.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (domainId == null) domainId = ""
            if (glossaryId == null) glossaryId = ""
            if (id == null) id = ""
            if (name == null) name = ""
            if (status == null) status = GlossaryTermStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
