// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateAssetTypeResponse private constructor(builder: Builder) {
    /**
     * The timestamp of when the asset type is to be created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon DataZone user who creates this custom asset type.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The description of the custom asset type.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the Amazon DataZone domain in which the asset type was created.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The metadata forms that are attached to the asset type.
     */
    public val formsOutput: Map<String, FormEntryOutput> = requireNotNull(builder.formsOutput) { "A non-null value must be provided for formsOutput" }
    /**
     * The name of the asset type.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The ID of the Amazon DataZone domain where the asset type was originally created.
     */
    public val originDomainId: kotlin.String? = builder.originDomainId
    /**
     * The ID of the Amazon DataZone project where the asset type was originally created.
     */
    public val originProjectId: kotlin.String? = builder.originProjectId
    /**
     * The ID of the Amazon DataZone project that currently owns this asset type.
     */
    public val owningProjectId: kotlin.String? = builder.owningProjectId
    /**
     * The revision of the custom asset type.
     */
    public val revision: kotlin.String = requireNotNull(builder.revision) { "A non-null value must be provided for revision" }
    /**
     * The timestamp of when the custom type was created.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The Amazon DataZone user that created the custom asset type.
     */
    public val updatedBy: kotlin.String? = builder.updatedBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.CreateAssetTypeResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAssetTypeResponse(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=*** Sensitive Data Redacted ***,")
        append("domainId=$domainId,")
        append("formsOutput=$formsOutput,")
        append("name=$name,")
        append("originDomainId=$originDomainId,")
        append("originProjectId=$originProjectId,")
        append("owningProjectId=$owningProjectId,")
        append("revision=$revision,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (formsOutput.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (originDomainId?.hashCode() ?: 0)
        result = 31 * result + (originProjectId?.hashCode() ?: 0)
        result = 31 * result + (owningProjectId?.hashCode() ?: 0)
        result = 31 * result + (revision.hashCode())
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (updatedBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAssetTypeResponse

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (domainId != other.domainId) return false
        if (formsOutput != other.formsOutput) return false
        if (name != other.name) return false
        if (originDomainId != other.originDomainId) return false
        if (originProjectId != other.originProjectId) return false
        if (owningProjectId != other.owningProjectId) return false
        if (revision != other.revision) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.CreateAssetTypeResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the asset type is to be created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who creates this custom asset type.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The description of the custom asset type.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone domain in which the asset type was created.
         */
        public var domainId: kotlin.String? = null
        /**
         * The metadata forms that are attached to the asset type.
         */
        public var formsOutput: Map<String, FormEntryOutput>? = null
        /**
         * The name of the asset type.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone domain where the asset type was originally created.
         */
        public var originDomainId: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone project where the asset type was originally created.
         */
        public var originProjectId: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone project that currently owns this asset type.
         */
        public var owningProjectId: kotlin.String? = null
        /**
         * The revision of the custom asset type.
         */
        public var revision: kotlin.String? = null
        /**
         * The timestamp of when the custom type was created.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user that created the custom asset type.
         */
        public var updatedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.CreateAssetTypeResponse) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.domainId = x.domainId
            this.formsOutput = x.formsOutput
            this.name = x.name
            this.originDomainId = x.originDomainId
            this.originProjectId = x.originProjectId
            this.owningProjectId = x.owningProjectId
            this.revision = x.revision
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.CreateAssetTypeResponse = CreateAssetTypeResponse(this)

        internal fun correctErrors(): Builder {
            if (domainId == null) domainId = ""
            if (formsOutput == null) formsOutput = emptyMap()
            if (name == null) name = ""
            if (revision == null) revision = ""
            return this
        }
    }
}
