// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.datazone.auth.DataZoneAuthSchemeProvider
import aws.sdk.kotlin.services.datazone.auth.DefaultDataZoneAuthSchemeProvider
import aws.sdk.kotlin.services.datazone.endpoints.DataZoneEndpointParameters
import aws.sdk.kotlin.services.datazone.endpoints.DataZoneEndpointProvider
import aws.sdk.kotlin.services.datazone.endpoints.DefaultDataZoneEndpointProvider
import aws.sdk.kotlin.services.datazone.model.AcceptPredictionsRequest
import aws.sdk.kotlin.services.datazone.model.AcceptPredictionsResponse
import aws.sdk.kotlin.services.datazone.model.AcceptSubscriptionRequestRequest
import aws.sdk.kotlin.services.datazone.model.AcceptSubscriptionRequestResponse
import aws.sdk.kotlin.services.datazone.model.CancelMetadataGenerationRunRequest
import aws.sdk.kotlin.services.datazone.model.CancelMetadataGenerationRunResponse
import aws.sdk.kotlin.services.datazone.model.CancelSubscriptionRequest
import aws.sdk.kotlin.services.datazone.model.CancelSubscriptionResponse
import aws.sdk.kotlin.services.datazone.model.CreateAssetRequest
import aws.sdk.kotlin.services.datazone.model.CreateAssetResponse
import aws.sdk.kotlin.services.datazone.model.CreateAssetRevisionRequest
import aws.sdk.kotlin.services.datazone.model.CreateAssetRevisionResponse
import aws.sdk.kotlin.services.datazone.model.CreateAssetTypeRequest
import aws.sdk.kotlin.services.datazone.model.CreateAssetTypeResponse
import aws.sdk.kotlin.services.datazone.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.datazone.model.CreateDataSourceResponse
import aws.sdk.kotlin.services.datazone.model.CreateDomainRequest
import aws.sdk.kotlin.services.datazone.model.CreateDomainResponse
import aws.sdk.kotlin.services.datazone.model.CreateEnvironmentProfileRequest
import aws.sdk.kotlin.services.datazone.model.CreateEnvironmentProfileResponse
import aws.sdk.kotlin.services.datazone.model.CreateEnvironmentRequest
import aws.sdk.kotlin.services.datazone.model.CreateEnvironmentResponse
import aws.sdk.kotlin.services.datazone.model.CreateFormTypeRequest
import aws.sdk.kotlin.services.datazone.model.CreateFormTypeResponse
import aws.sdk.kotlin.services.datazone.model.CreateGlossaryRequest
import aws.sdk.kotlin.services.datazone.model.CreateGlossaryResponse
import aws.sdk.kotlin.services.datazone.model.CreateGlossaryTermRequest
import aws.sdk.kotlin.services.datazone.model.CreateGlossaryTermResponse
import aws.sdk.kotlin.services.datazone.model.CreateGroupProfileRequest
import aws.sdk.kotlin.services.datazone.model.CreateGroupProfileResponse
import aws.sdk.kotlin.services.datazone.model.CreateListingChangeSetRequest
import aws.sdk.kotlin.services.datazone.model.CreateListingChangeSetResponse
import aws.sdk.kotlin.services.datazone.model.CreateProjectMembershipRequest
import aws.sdk.kotlin.services.datazone.model.CreateProjectMembershipResponse
import aws.sdk.kotlin.services.datazone.model.CreateProjectRequest
import aws.sdk.kotlin.services.datazone.model.CreateProjectResponse
import aws.sdk.kotlin.services.datazone.model.CreateSubscriptionGrantRequest
import aws.sdk.kotlin.services.datazone.model.CreateSubscriptionGrantResponse
import aws.sdk.kotlin.services.datazone.model.CreateSubscriptionRequestRequest
import aws.sdk.kotlin.services.datazone.model.CreateSubscriptionRequestResponse
import aws.sdk.kotlin.services.datazone.model.CreateSubscriptionTargetRequest
import aws.sdk.kotlin.services.datazone.model.CreateSubscriptionTargetResponse
import aws.sdk.kotlin.services.datazone.model.CreateUserProfileRequest
import aws.sdk.kotlin.services.datazone.model.CreateUserProfileResponse
import aws.sdk.kotlin.services.datazone.model.DeleteAssetRequest
import aws.sdk.kotlin.services.datazone.model.DeleteAssetResponse
import aws.sdk.kotlin.services.datazone.model.DeleteAssetTypeRequest
import aws.sdk.kotlin.services.datazone.model.DeleteAssetTypeResponse
import aws.sdk.kotlin.services.datazone.model.DeleteDataSourceRequest
import aws.sdk.kotlin.services.datazone.model.DeleteDataSourceResponse
import aws.sdk.kotlin.services.datazone.model.DeleteDomainRequest
import aws.sdk.kotlin.services.datazone.model.DeleteDomainResponse
import aws.sdk.kotlin.services.datazone.model.DeleteEnvironmentBlueprintConfigurationRequest
import aws.sdk.kotlin.services.datazone.model.DeleteEnvironmentBlueprintConfigurationResponse
import aws.sdk.kotlin.services.datazone.model.DeleteEnvironmentProfileRequest
import aws.sdk.kotlin.services.datazone.model.DeleteEnvironmentProfileResponse
import aws.sdk.kotlin.services.datazone.model.DeleteEnvironmentRequest
import aws.sdk.kotlin.services.datazone.model.DeleteEnvironmentResponse
import aws.sdk.kotlin.services.datazone.model.DeleteFormTypeRequest
import aws.sdk.kotlin.services.datazone.model.DeleteFormTypeResponse
import aws.sdk.kotlin.services.datazone.model.DeleteGlossaryRequest
import aws.sdk.kotlin.services.datazone.model.DeleteGlossaryResponse
import aws.sdk.kotlin.services.datazone.model.DeleteGlossaryTermRequest
import aws.sdk.kotlin.services.datazone.model.DeleteGlossaryTermResponse
import aws.sdk.kotlin.services.datazone.model.DeleteListingRequest
import aws.sdk.kotlin.services.datazone.model.DeleteListingResponse
import aws.sdk.kotlin.services.datazone.model.DeleteProjectMembershipRequest
import aws.sdk.kotlin.services.datazone.model.DeleteProjectMembershipResponse
import aws.sdk.kotlin.services.datazone.model.DeleteProjectRequest
import aws.sdk.kotlin.services.datazone.model.DeleteProjectResponse
import aws.sdk.kotlin.services.datazone.model.DeleteSubscriptionGrantRequest
import aws.sdk.kotlin.services.datazone.model.DeleteSubscriptionGrantResponse
import aws.sdk.kotlin.services.datazone.model.DeleteSubscriptionRequestRequest
import aws.sdk.kotlin.services.datazone.model.DeleteSubscriptionRequestResponse
import aws.sdk.kotlin.services.datazone.model.DeleteSubscriptionTargetRequest
import aws.sdk.kotlin.services.datazone.model.DeleteSubscriptionTargetResponse
import aws.sdk.kotlin.services.datazone.model.DeleteTimeSeriesDataPointsRequest
import aws.sdk.kotlin.services.datazone.model.DeleteTimeSeriesDataPointsResponse
import aws.sdk.kotlin.services.datazone.model.GetAssetRequest
import aws.sdk.kotlin.services.datazone.model.GetAssetResponse
import aws.sdk.kotlin.services.datazone.model.GetAssetTypeRequest
import aws.sdk.kotlin.services.datazone.model.GetAssetTypeResponse
import aws.sdk.kotlin.services.datazone.model.GetDataSourceRequest
import aws.sdk.kotlin.services.datazone.model.GetDataSourceResponse
import aws.sdk.kotlin.services.datazone.model.GetDataSourceRunRequest
import aws.sdk.kotlin.services.datazone.model.GetDataSourceRunResponse
import aws.sdk.kotlin.services.datazone.model.GetDomainRequest
import aws.sdk.kotlin.services.datazone.model.GetDomainResponse
import aws.sdk.kotlin.services.datazone.model.GetEnvironmentBlueprintConfigurationRequest
import aws.sdk.kotlin.services.datazone.model.GetEnvironmentBlueprintConfigurationResponse
import aws.sdk.kotlin.services.datazone.model.GetEnvironmentBlueprintRequest
import aws.sdk.kotlin.services.datazone.model.GetEnvironmentBlueprintResponse
import aws.sdk.kotlin.services.datazone.model.GetEnvironmentProfileRequest
import aws.sdk.kotlin.services.datazone.model.GetEnvironmentProfileResponse
import aws.sdk.kotlin.services.datazone.model.GetEnvironmentRequest
import aws.sdk.kotlin.services.datazone.model.GetEnvironmentResponse
import aws.sdk.kotlin.services.datazone.model.GetFormTypeRequest
import aws.sdk.kotlin.services.datazone.model.GetFormTypeResponse
import aws.sdk.kotlin.services.datazone.model.GetGlossaryRequest
import aws.sdk.kotlin.services.datazone.model.GetGlossaryResponse
import aws.sdk.kotlin.services.datazone.model.GetGlossaryTermRequest
import aws.sdk.kotlin.services.datazone.model.GetGlossaryTermResponse
import aws.sdk.kotlin.services.datazone.model.GetGroupProfileRequest
import aws.sdk.kotlin.services.datazone.model.GetGroupProfileResponse
import aws.sdk.kotlin.services.datazone.model.GetIamPortalLoginUrlRequest
import aws.sdk.kotlin.services.datazone.model.GetIamPortalLoginUrlResponse
import aws.sdk.kotlin.services.datazone.model.GetListingRequest
import aws.sdk.kotlin.services.datazone.model.GetListingResponse
import aws.sdk.kotlin.services.datazone.model.GetMetadataGenerationRunRequest
import aws.sdk.kotlin.services.datazone.model.GetMetadataGenerationRunResponse
import aws.sdk.kotlin.services.datazone.model.GetProjectRequest
import aws.sdk.kotlin.services.datazone.model.GetProjectResponse
import aws.sdk.kotlin.services.datazone.model.GetSubscriptionGrantRequest
import aws.sdk.kotlin.services.datazone.model.GetSubscriptionGrantResponse
import aws.sdk.kotlin.services.datazone.model.GetSubscriptionRequest
import aws.sdk.kotlin.services.datazone.model.GetSubscriptionRequestDetailsRequest
import aws.sdk.kotlin.services.datazone.model.GetSubscriptionRequestDetailsResponse
import aws.sdk.kotlin.services.datazone.model.GetSubscriptionResponse
import aws.sdk.kotlin.services.datazone.model.GetSubscriptionTargetRequest
import aws.sdk.kotlin.services.datazone.model.GetSubscriptionTargetResponse
import aws.sdk.kotlin.services.datazone.model.GetTimeSeriesDataPointRequest
import aws.sdk.kotlin.services.datazone.model.GetTimeSeriesDataPointResponse
import aws.sdk.kotlin.services.datazone.model.GetUserProfileRequest
import aws.sdk.kotlin.services.datazone.model.GetUserProfileResponse
import aws.sdk.kotlin.services.datazone.model.ListAssetRevisionsRequest
import aws.sdk.kotlin.services.datazone.model.ListAssetRevisionsResponse
import aws.sdk.kotlin.services.datazone.model.ListDataSourceRunActivitiesRequest
import aws.sdk.kotlin.services.datazone.model.ListDataSourceRunActivitiesResponse
import aws.sdk.kotlin.services.datazone.model.ListDataSourceRunsRequest
import aws.sdk.kotlin.services.datazone.model.ListDataSourceRunsResponse
import aws.sdk.kotlin.services.datazone.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.datazone.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.datazone.model.ListDomainsRequest
import aws.sdk.kotlin.services.datazone.model.ListDomainsResponse
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentBlueprintsRequest
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentBlueprintsResponse
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentProfilesRequest
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentProfilesResponse
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.datazone.model.ListMetadataGenerationRunsRequest
import aws.sdk.kotlin.services.datazone.model.ListMetadataGenerationRunsResponse
import aws.sdk.kotlin.services.datazone.model.ListNotificationsRequest
import aws.sdk.kotlin.services.datazone.model.ListNotificationsResponse
import aws.sdk.kotlin.services.datazone.model.ListProjectMembershipsRequest
import aws.sdk.kotlin.services.datazone.model.ListProjectMembershipsResponse
import aws.sdk.kotlin.services.datazone.model.ListProjectsRequest
import aws.sdk.kotlin.services.datazone.model.ListProjectsResponse
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionGrantsRequest
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionGrantsResponse
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionRequestsRequest
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionRequestsResponse
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionTargetsRequest
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionTargetsResponse
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionsRequest
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionsResponse
import aws.sdk.kotlin.services.datazone.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.datazone.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.datazone.model.ListTimeSeriesDataPointsRequest
import aws.sdk.kotlin.services.datazone.model.ListTimeSeriesDataPointsResponse
import aws.sdk.kotlin.services.datazone.model.PostTimeSeriesDataPointsRequest
import aws.sdk.kotlin.services.datazone.model.PostTimeSeriesDataPointsResponse
import aws.sdk.kotlin.services.datazone.model.PutEnvironmentBlueprintConfigurationRequest
import aws.sdk.kotlin.services.datazone.model.PutEnvironmentBlueprintConfigurationResponse
import aws.sdk.kotlin.services.datazone.model.RejectPredictionsRequest
import aws.sdk.kotlin.services.datazone.model.RejectPredictionsResponse
import aws.sdk.kotlin.services.datazone.model.RejectSubscriptionRequestRequest
import aws.sdk.kotlin.services.datazone.model.RejectSubscriptionRequestResponse
import aws.sdk.kotlin.services.datazone.model.RevokeSubscriptionRequest
import aws.sdk.kotlin.services.datazone.model.RevokeSubscriptionResponse
import aws.sdk.kotlin.services.datazone.model.SearchGroupProfilesRequest
import aws.sdk.kotlin.services.datazone.model.SearchGroupProfilesResponse
import aws.sdk.kotlin.services.datazone.model.SearchListingsRequest
import aws.sdk.kotlin.services.datazone.model.SearchListingsResponse
import aws.sdk.kotlin.services.datazone.model.SearchRequest
import aws.sdk.kotlin.services.datazone.model.SearchResponse
import aws.sdk.kotlin.services.datazone.model.SearchTypesRequest
import aws.sdk.kotlin.services.datazone.model.SearchTypesResponse
import aws.sdk.kotlin.services.datazone.model.SearchUserProfilesRequest
import aws.sdk.kotlin.services.datazone.model.SearchUserProfilesResponse
import aws.sdk.kotlin.services.datazone.model.StartDataSourceRunRequest
import aws.sdk.kotlin.services.datazone.model.StartDataSourceRunResponse
import aws.sdk.kotlin.services.datazone.model.StartMetadataGenerationRunRequest
import aws.sdk.kotlin.services.datazone.model.StartMetadataGenerationRunResponse
import aws.sdk.kotlin.services.datazone.model.TagResourceRequest
import aws.sdk.kotlin.services.datazone.model.TagResourceResponse
import aws.sdk.kotlin.services.datazone.model.UntagResourceRequest
import aws.sdk.kotlin.services.datazone.model.UntagResourceResponse
import aws.sdk.kotlin.services.datazone.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.datazone.model.UpdateDataSourceResponse
import aws.sdk.kotlin.services.datazone.model.UpdateDomainRequest
import aws.sdk.kotlin.services.datazone.model.UpdateDomainResponse
import aws.sdk.kotlin.services.datazone.model.UpdateEnvironmentProfileRequest
import aws.sdk.kotlin.services.datazone.model.UpdateEnvironmentProfileResponse
import aws.sdk.kotlin.services.datazone.model.UpdateEnvironmentRequest
import aws.sdk.kotlin.services.datazone.model.UpdateEnvironmentResponse
import aws.sdk.kotlin.services.datazone.model.UpdateGlossaryRequest
import aws.sdk.kotlin.services.datazone.model.UpdateGlossaryResponse
import aws.sdk.kotlin.services.datazone.model.UpdateGlossaryTermRequest
import aws.sdk.kotlin.services.datazone.model.UpdateGlossaryTermResponse
import aws.sdk.kotlin.services.datazone.model.UpdateGroupProfileRequest
import aws.sdk.kotlin.services.datazone.model.UpdateGroupProfileResponse
import aws.sdk.kotlin.services.datazone.model.UpdateProjectRequest
import aws.sdk.kotlin.services.datazone.model.UpdateProjectResponse
import aws.sdk.kotlin.services.datazone.model.UpdateSubscriptionGrantStatusRequest
import aws.sdk.kotlin.services.datazone.model.UpdateSubscriptionGrantStatusResponse
import aws.sdk.kotlin.services.datazone.model.UpdateSubscriptionRequestRequest
import aws.sdk.kotlin.services.datazone.model.UpdateSubscriptionRequestResponse
import aws.sdk.kotlin.services.datazone.model.UpdateSubscriptionTargetRequest
import aws.sdk.kotlin.services.datazone.model.UpdateSubscriptionTargetResponse
import aws.sdk.kotlin.services.datazone.model.UpdateUserProfileRequest
import aws.sdk.kotlin.services.datazone.model.UpdateUserProfileResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "DataZone"
public const val SdkVersion: String = "1.2.30"
public const val ServiceApiVersion: String = "2018-05-10"

/**
 * Amazon DataZone is a data management service that enables you to catalog, discover, govern, share, and analyze your data. With Amazon DataZone, you can share and access your data across accounts and supported regions. Amazon DataZone simplifies your experience across Amazon Web Services services, including, but not limited to, Amazon Redshift, Amazon Athena, Amazon Web Services Glue, and Amazon Web Services Lake Formation.
 */
public interface DataZoneClient : SdkClient {
    /**
     * DataZoneClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, DataZoneClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "DataZone",
                "DATAZONE",
                "datazone",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, DataZoneClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): DataZoneClient = DefaultDataZoneClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: DataZoneEndpointProvider = builder.endpointProvider ?: DefaultDataZoneEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: DataZoneAuthSchemeProvider = builder.authSchemeProvider ?: DefaultDataZoneAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "DataZone"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: DataZoneEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: DataZoneAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts automatically generated business-friendly metadata for your Amazon DataZone assets.
     */
    public suspend fun acceptPredictions(input: AcceptPredictionsRequest): AcceptPredictionsResponse

    /**
     * Accepts a subscription request to a specific asset.
     */
    public suspend fun acceptSubscriptionRequest(input: AcceptSubscriptionRequestRequest): AcceptSubscriptionRequestResponse

    /**
     * Cancels the metadata generation run.
     */
    public suspend fun cancelMetadataGenerationRun(input: CancelMetadataGenerationRunRequest): CancelMetadataGenerationRunResponse

    /**
     * Cancels the subscription to the specified asset.
     */
    public suspend fun cancelSubscription(input: CancelSubscriptionRequest): CancelSubscriptionResponse

    /**
     * Creates an asset in Amazon DataZone catalog.
     */
    public suspend fun createAsset(input: CreateAssetRequest): CreateAssetResponse

    /**
     * Creates a revision of the asset.
     */
    public suspend fun createAssetRevision(input: CreateAssetRevisionRequest): CreateAssetRevisionResponse

    /**
     * Creates a custom asset type.
     */
    public suspend fun createAssetType(input: CreateAssetTypeRequest): CreateAssetTypeResponse

    /**
     * Creates an Amazon DataZone data source.
     */
    public suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse

    /**
     * Creates an Amazon DataZone domain.
     */
    public suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Create an Amazon DataZone environment.
     */
    public suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse

    /**
     * Creates an Amazon DataZone environment profile.
     */
    public suspend fun createEnvironmentProfile(input: CreateEnvironmentProfileRequest): CreateEnvironmentProfileResponse

    /**
     * Creates a metadata form type.
     */
    public suspend fun createFormType(input: CreateFormTypeRequest): CreateFormTypeResponse

    /**
     * Creates an Amazon DataZone business glossary.
     */
    public suspend fun createGlossary(input: CreateGlossaryRequest): CreateGlossaryResponse

    /**
     * Creates a business glossary term.
     */
    public suspend fun createGlossaryTerm(input: CreateGlossaryTermRequest): CreateGlossaryTermResponse

    /**
     * Creates a group profile in Amazon DataZone.
     */
    public suspend fun createGroupProfile(input: CreateGroupProfileRequest): CreateGroupProfileResponse

    /**
     * Publishes a listing (a record of an asset at a given time) or removes a listing from the catalog.
     */
    public suspend fun createListingChangeSet(input: CreateListingChangeSetRequest): CreateListingChangeSetResponse

    /**
     * Creates an Amazon DataZone project.
     */
    public suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Creates a project membership in Amazon DataZone.
     */
    public suspend fun createProjectMembership(input: CreateProjectMembershipRequest): CreateProjectMembershipResponse

    /**
     * Creates a subsscription grant in Amazon DataZone.
     */
    public suspend fun createSubscriptionGrant(input: CreateSubscriptionGrantRequest): CreateSubscriptionGrantResponse

    /**
     * Creates a subscription request in Amazon DataZone.
     */
    public suspend fun createSubscriptionRequest(input: CreateSubscriptionRequestRequest): CreateSubscriptionRequestResponse

    /**
     * Creates a subscription target in Amazon DataZone.
     */
    public suspend fun createSubscriptionTarget(input: CreateSubscriptionTargetRequest): CreateSubscriptionTargetResponse

    /**
     * Creates a user profile in Amazon DataZone.
     */
    public suspend fun createUserProfile(input: CreateUserProfileRequest): CreateUserProfileResponse

    /**
     * Delets an asset in Amazon DataZone.
     */
    public suspend fun deleteAsset(input: DeleteAssetRequest): DeleteAssetResponse

    /**
     * Deletes an asset type in Amazon DataZone.
     */
    public suspend fun deleteAssetType(input: DeleteAssetTypeRequest): DeleteAssetTypeResponse

    /**
     * Deletes a data source in Amazon DataZone.
     */
    public suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Deletes a Amazon DataZone domain.
     */
    public suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Deletes an environment in Amazon DataZone.
     */
    public suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * Deletes the blueprint configuration in Amazon DataZone.
     */
    public suspend fun deleteEnvironmentBlueprintConfiguration(input: DeleteEnvironmentBlueprintConfigurationRequest): DeleteEnvironmentBlueprintConfigurationResponse

    /**
     * Deletes an environment profile in Amazon DataZone.
     */
    public suspend fun deleteEnvironmentProfile(input: DeleteEnvironmentProfileRequest): DeleteEnvironmentProfileResponse

    /**
     * Delets and metadata form type in Amazon DataZone.
     */
    public suspend fun deleteFormType(input: DeleteFormTypeRequest): DeleteFormTypeResponse

    /**
     * Deletes a business glossary in Amazon DataZone.
     */
    public suspend fun deleteGlossary(input: DeleteGlossaryRequest): DeleteGlossaryResponse

    /**
     * Deletes a business glossary term in Amazon DataZone.
     */
    public suspend fun deleteGlossaryTerm(input: DeleteGlossaryTermRequest): DeleteGlossaryTermResponse

    /**
     * Deletes a listing (a record of an asset at a given time).
     */
    public suspend fun deleteListing(input: DeleteListingRequest): DeleteListingResponse

    /**
     * Deletes a project in Amazon DataZone.
     */
    public suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Deletes project membership in Amazon DataZone.
     */
    public suspend fun deleteProjectMembership(input: DeleteProjectMembershipRequest): DeleteProjectMembershipResponse

    /**
     * Deletes and subscription grant in Amazon DataZone.
     */
    public suspend fun deleteSubscriptionGrant(input: DeleteSubscriptionGrantRequest): DeleteSubscriptionGrantResponse

    /**
     * Deletes a subscription request in Amazon DataZone.
     */
    public suspend fun deleteSubscriptionRequest(input: DeleteSubscriptionRequestRequest): DeleteSubscriptionRequestResponse

    /**
     * Deletes a subscription target in Amazon DataZone.
     */
    public suspend fun deleteSubscriptionTarget(input: DeleteSubscriptionTargetRequest): DeleteSubscriptionTargetResponse

    /**
     * Deletes the specified time series form for the specified asset.
     */
    public suspend fun deleteTimeSeriesDataPoints(input: DeleteTimeSeriesDataPointsRequest): DeleteTimeSeriesDataPointsResponse

    /**
     * Gets an Amazon DataZone asset.
     */
    public suspend fun getAsset(input: GetAssetRequest): GetAssetResponse

    /**
     * Gets an Amazon DataZone asset type.
     */
    public suspend fun getAssetType(input: GetAssetTypeRequest): GetAssetTypeResponse

    /**
     * Gets an Amazon DataZone data source.
     */
    public suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse

    /**
     * Gets an Amazon DataZone data source run.
     */
    public suspend fun getDataSourceRun(input: GetDataSourceRunRequest): GetDataSourceRunResponse

    /**
     * Gets an Amazon DataZone domain.
     */
    public suspend fun getDomain(input: GetDomainRequest): GetDomainResponse

    /**
     * Gets an Amazon DataZone environment.
     */
    public suspend fun getEnvironment(input: GetEnvironmentRequest): GetEnvironmentResponse

    /**
     * Gets an Amazon DataZone blueprint.
     */
    public suspend fun getEnvironmentBlueprint(input: GetEnvironmentBlueprintRequest): GetEnvironmentBlueprintResponse

    /**
     * Gets the blueprint configuration in Amazon DataZone.
     */
    public suspend fun getEnvironmentBlueprintConfiguration(input: GetEnvironmentBlueprintConfigurationRequest): GetEnvironmentBlueprintConfigurationResponse

    /**
     * Gets an evinronment profile in Amazon DataZone.
     */
    public suspend fun getEnvironmentProfile(input: GetEnvironmentProfileRequest): GetEnvironmentProfileResponse

    /**
     * Gets a metadata form type in Amazon DataZone.
     */
    public suspend fun getFormType(input: GetFormTypeRequest): GetFormTypeResponse

    /**
     * Gets a business glossary in Amazon DataZone.
     */
    public suspend fun getGlossary(input: GetGlossaryRequest): GetGlossaryResponse

    /**
     * Gets a business glossary term in Amazon DataZone.
     */
    public suspend fun getGlossaryTerm(input: GetGlossaryTermRequest): GetGlossaryTermResponse

    /**
     * Gets a group profile in Amazon DataZone.
     */
    public suspend fun getGroupProfile(input: GetGroupProfileRequest): GetGroupProfileResponse

    /**
     * Gets the data portal URL for the specified Amazon DataZone domain.
     */
    public suspend fun getIamPortalLoginUrl(input: GetIamPortalLoginUrlRequest): GetIamPortalLoginUrlResponse

    /**
     * Gets a listing (a record of an asset at a given time).
     */
    public suspend fun getListing(input: GetListingRequest): GetListingResponse

    /**
     * Gets a metadata generation run in Amazon DataZone.
     */
    public suspend fun getMetadataGenerationRun(input: GetMetadataGenerationRunRequest): GetMetadataGenerationRunResponse

    /**
     * Gets a project in Amazon DataZone.
     */
    public suspend fun getProject(input: GetProjectRequest): GetProjectResponse

    /**
     * Gets a subscription in Amazon DataZone.
     */
    public suspend fun getSubscription(input: GetSubscriptionRequest): GetSubscriptionResponse

    /**
     * Gets the subscription grant in Amazon DataZone.
     */
    public suspend fun getSubscriptionGrant(input: GetSubscriptionGrantRequest): GetSubscriptionGrantResponse

    /**
     * Gets the details of the specified subscription request.
     */
    public suspend fun getSubscriptionRequestDetails(input: GetSubscriptionRequestDetailsRequest): GetSubscriptionRequestDetailsResponse

    /**
     * Gets the subscription target in Amazon DataZone.
     */
    public suspend fun getSubscriptionTarget(input: GetSubscriptionTargetRequest): GetSubscriptionTargetResponse

    /**
     * Gets the existing data point for the asset.
     */
    public suspend fun getTimeSeriesDataPoint(input: GetTimeSeriesDataPointRequest): GetTimeSeriesDataPointResponse

    /**
     * Gets a user profile in Amazon DataZone.
     */
    public suspend fun getUserProfile(input: GetUserProfileRequest): GetUserProfileResponse

    /**
     * Lists the revisions for the asset.
     */
    public suspend fun listAssetRevisions(input: ListAssetRevisionsRequest): ListAssetRevisionsResponse

    /**
     * Lists data source run activities.
     */
    public suspend fun listDataSourceRunActivities(input: ListDataSourceRunActivitiesRequest): ListDataSourceRunActivitiesResponse

    /**
     * Lists data source runs in Amazon DataZone.
     */
    public suspend fun listDataSourceRuns(input: ListDataSourceRunsRequest): ListDataSourceRunsResponse

    /**
     * Lists data sources in Amazon DataZone.
     */
    public suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * Lists Amazon DataZone domains.
     */
    public suspend fun listDomains(input: ListDomainsRequest = ListDomainsRequest { }): ListDomainsResponse

    /**
     * Lists blueprint configurations for a Amazon DataZone environment.
     */
    public suspend fun listEnvironmentBlueprintConfigurations(input: ListEnvironmentBlueprintConfigurationsRequest): ListEnvironmentBlueprintConfigurationsResponse

    /**
     * Lists blueprints in an Amazon DataZone environment.
     */
    public suspend fun listEnvironmentBlueprints(input: ListEnvironmentBlueprintsRequest): ListEnvironmentBlueprintsResponse

    /**
     * Lists Amazon DataZone environment profiles.
     */
    public suspend fun listEnvironmentProfiles(input: ListEnvironmentProfilesRequest): ListEnvironmentProfilesResponse

    /**
     * Lists Amazon DataZone environments.
     */
    public suspend fun listEnvironments(input: ListEnvironmentsRequest): ListEnvironmentsResponse

    /**
     * Lists all metadata generation runs.
     */
    public suspend fun listMetadataGenerationRuns(input: ListMetadataGenerationRunsRequest): ListMetadataGenerationRunsResponse

    /**
     * Lists all Amazon DataZone notifications.
     */
    public suspend fun listNotifications(input: ListNotificationsRequest): ListNotificationsResponse

    /**
     * Lists all members of the specified project.
     */
    public suspend fun listProjectMemberships(input: ListProjectMembershipsRequest): ListProjectMembershipsResponse

    /**
     * Lists Amazon DataZone projects.
     */
    public suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse

    /**
     * Lists subscription grants.
     */
    public suspend fun listSubscriptionGrants(input: ListSubscriptionGrantsRequest): ListSubscriptionGrantsResponse

    /**
     * Lists Amazon DataZone subscription requests.
     */
    public suspend fun listSubscriptionRequests(input: ListSubscriptionRequestsRequest): ListSubscriptionRequestsResponse

    /**
     * Lists subscription targets in Amazon DataZone.
     */
    public suspend fun listSubscriptionTargets(input: ListSubscriptionTargetsRequest): ListSubscriptionTargetsResponse

    /**
     * Lists subscriptions in Amazon DataZone.
     */
    public suspend fun listSubscriptions(input: ListSubscriptionsRequest): ListSubscriptionsResponse

    /**
     * Lists tags for the specified resource in Amazon DataZone.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists time series data points.
     */
    public suspend fun listTimeSeriesDataPoints(input: ListTimeSeriesDataPointsRequest): ListTimeSeriesDataPointsResponse

    /**
     * Posts time series data points to Amazon DataZone for the specified asset.
     */
    public suspend fun postTimeSeriesDataPoints(input: PostTimeSeriesDataPointsRequest): PostTimeSeriesDataPointsResponse

    /**
     * Writes the configuration for the specified environment blueprint in Amazon DataZone.
     */
    public suspend fun putEnvironmentBlueprintConfiguration(input: PutEnvironmentBlueprintConfigurationRequest): PutEnvironmentBlueprintConfigurationResponse

    /**
     * Rejects automatically generated business-friendly metadata for your Amazon DataZone assets.
     */
    public suspend fun rejectPredictions(input: RejectPredictionsRequest): RejectPredictionsResponse

    /**
     * Rejects the specified subscription request.
     */
    public suspend fun rejectSubscriptionRequest(input: RejectSubscriptionRequestRequest): RejectSubscriptionRequestResponse

    /**
     * Revokes a specified subscription in Amazon DataZone.
     */
    public suspend fun revokeSubscription(input: RevokeSubscriptionRequest): RevokeSubscriptionResponse

    /**
     * Searches for assets in Amazon DataZone.
     */
    public suspend fun search(input: SearchRequest): SearchResponse

    /**
     * Searches group profiles in Amazon DataZone.
     */
    public suspend fun searchGroupProfiles(input: SearchGroupProfilesRequest): SearchGroupProfilesResponse

    /**
     * Searches listings (records of an asset at a given time) in Amazon DataZone.
     */
    public suspend fun searchListings(input: SearchListingsRequest): SearchListingsResponse

    /**
     * Searches for types in Amazon DataZone.
     */
    public suspend fun searchTypes(input: SearchTypesRequest): SearchTypesResponse

    /**
     * Searches user profiles in Amazon DataZone.
     */
    public suspend fun searchUserProfiles(input: SearchUserProfilesRequest): SearchUserProfilesResponse

    /**
     * Start the run of the specified data source in Amazon DataZone.
     */
    public suspend fun startDataSourceRun(input: StartDataSourceRunRequest): StartDataSourceRunResponse

    /**
     * Starts the metadata generation run.
     */
    public suspend fun startMetadataGenerationRun(input: StartMetadataGenerationRunRequest): StartMetadataGenerationRunResponse

    /**
     * Tags a resource in Amazon DataZone.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Untags a resource in Amazon DataZone.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified data source in Amazon DataZone.
     */
    public suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates a Amazon DataZone domain.
     */
    public suspend fun updateDomain(input: UpdateDomainRequest): UpdateDomainResponse

    /**
     * Updates the specified environment in Amazon DataZone.
     */
    public suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse

    /**
     * Updates the specified environment profile in Amazon DataZone.
     */
    public suspend fun updateEnvironmentProfile(input: UpdateEnvironmentProfileRequest): UpdateEnvironmentProfileResponse

    /**
     * Updates the business glossary in Amazon DataZone.
     */
    public suspend fun updateGlossary(input: UpdateGlossaryRequest): UpdateGlossaryResponse

    /**
     * Updates a business glossary term in Amazon DataZone.
     */
    public suspend fun updateGlossaryTerm(input: UpdateGlossaryTermRequest): UpdateGlossaryTermResponse

    /**
     * Updates the specified group profile in Amazon DataZone.
     */
    public suspend fun updateGroupProfile(input: UpdateGroupProfileRequest): UpdateGroupProfileResponse

    /**
     * Updates the specified project in Amazon DataZone.
     */
    public suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Updates the status of the specified subscription grant status in Amazon DataZone.
     */
    public suspend fun updateSubscriptionGrantStatus(input: UpdateSubscriptionGrantStatusRequest): UpdateSubscriptionGrantStatusResponse

    /**
     * Updates a specified subscription request in Amazon DataZone.
     */
    public suspend fun updateSubscriptionRequest(input: UpdateSubscriptionRequestRequest): UpdateSubscriptionRequestResponse

    /**
     * Updates the specified subscription target in Amazon DataZone.
     */
    public suspend fun updateSubscriptionTarget(input: UpdateSubscriptionTargetRequest): UpdateSubscriptionTargetResponse

    /**
     * Updates the specified user profile in Amazon DataZone.
     */
    public suspend fun updateUserProfile(input: UpdateUserProfileRequest): UpdateUserProfileResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun DataZoneClient.withConfig(block: DataZoneClient.Config.Builder.() -> Unit): DataZoneClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultDataZoneClient(newConfig)
}

/**
 * Accepts automatically generated business-friendly metadata for your Amazon DataZone assets.
 */
public suspend inline fun DataZoneClient.acceptPredictions(crossinline block: AcceptPredictionsRequest.Builder.() -> Unit): AcceptPredictionsResponse = acceptPredictions(AcceptPredictionsRequest.Builder().apply(block).build())

/**
 * Accepts a subscription request to a specific asset.
 */
public suspend inline fun DataZoneClient.acceptSubscriptionRequest(crossinline block: AcceptSubscriptionRequestRequest.Builder.() -> Unit): AcceptSubscriptionRequestResponse = acceptSubscriptionRequest(AcceptSubscriptionRequestRequest.Builder().apply(block).build())

/**
 * Cancels the metadata generation run.
 */
public suspend inline fun DataZoneClient.cancelMetadataGenerationRun(crossinline block: CancelMetadataGenerationRunRequest.Builder.() -> Unit): CancelMetadataGenerationRunResponse = cancelMetadataGenerationRun(CancelMetadataGenerationRunRequest.Builder().apply(block).build())

/**
 * Cancels the subscription to the specified asset.
 */
public suspend inline fun DataZoneClient.cancelSubscription(crossinline block: CancelSubscriptionRequest.Builder.() -> Unit): CancelSubscriptionResponse = cancelSubscription(CancelSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates an asset in Amazon DataZone catalog.
 */
public suspend inline fun DataZoneClient.createAsset(crossinline block: CreateAssetRequest.Builder.() -> Unit): CreateAssetResponse = createAsset(CreateAssetRequest.Builder().apply(block).build())

/**
 * Creates a revision of the asset.
 */
public suspend inline fun DataZoneClient.createAssetRevision(crossinline block: CreateAssetRevisionRequest.Builder.() -> Unit): CreateAssetRevisionResponse = createAssetRevision(CreateAssetRevisionRequest.Builder().apply(block).build())

/**
 * Creates a custom asset type.
 */
public suspend inline fun DataZoneClient.createAssetType(crossinline block: CreateAssetTypeRequest.Builder.() -> Unit): CreateAssetTypeResponse = createAssetType(CreateAssetTypeRequest.Builder().apply(block).build())

/**
 * Creates an Amazon DataZone data source.
 */
public suspend inline fun DataZoneClient.createDataSource(crossinline block: CreateDataSourceRequest.Builder.() -> Unit): CreateDataSourceResponse = createDataSource(CreateDataSourceRequest.Builder().apply(block).build())

/**
 * Creates an Amazon DataZone domain.
 */
public suspend inline fun DataZoneClient.createDomain(crossinline block: CreateDomainRequest.Builder.() -> Unit): CreateDomainResponse = createDomain(CreateDomainRequest.Builder().apply(block).build())

/**
 * Create an Amazon DataZone environment.
 */
public suspend inline fun DataZoneClient.createEnvironment(crossinline block: CreateEnvironmentRequest.Builder.() -> Unit): CreateEnvironmentResponse = createEnvironment(CreateEnvironmentRequest.Builder().apply(block).build())

/**
 * Creates an Amazon DataZone environment profile.
 */
public suspend inline fun DataZoneClient.createEnvironmentProfile(crossinline block: CreateEnvironmentProfileRequest.Builder.() -> Unit): CreateEnvironmentProfileResponse = createEnvironmentProfile(CreateEnvironmentProfileRequest.Builder().apply(block).build())

/**
 * Creates a metadata form type.
 */
public suspend inline fun DataZoneClient.createFormType(crossinline block: CreateFormTypeRequest.Builder.() -> Unit): CreateFormTypeResponse = createFormType(CreateFormTypeRequest.Builder().apply(block).build())

/**
 * Creates an Amazon DataZone business glossary.
 */
public suspend inline fun DataZoneClient.createGlossary(crossinline block: CreateGlossaryRequest.Builder.() -> Unit): CreateGlossaryResponse = createGlossary(CreateGlossaryRequest.Builder().apply(block).build())

/**
 * Creates a business glossary term.
 */
public suspend inline fun DataZoneClient.createGlossaryTerm(crossinline block: CreateGlossaryTermRequest.Builder.() -> Unit): CreateGlossaryTermResponse = createGlossaryTerm(CreateGlossaryTermRequest.Builder().apply(block).build())

/**
 * Creates a group profile in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.createGroupProfile(crossinline block: CreateGroupProfileRequest.Builder.() -> Unit): CreateGroupProfileResponse = createGroupProfile(CreateGroupProfileRequest.Builder().apply(block).build())

/**
 * Publishes a listing (a record of an asset at a given time) or removes a listing from the catalog.
 */
public suspend inline fun DataZoneClient.createListingChangeSet(crossinline block: CreateListingChangeSetRequest.Builder.() -> Unit): CreateListingChangeSetResponse = createListingChangeSet(CreateListingChangeSetRequest.Builder().apply(block).build())

/**
 * Creates an Amazon DataZone project.
 */
public suspend inline fun DataZoneClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit): CreateProjectResponse = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Creates a project membership in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.createProjectMembership(crossinline block: CreateProjectMembershipRequest.Builder.() -> Unit): CreateProjectMembershipResponse = createProjectMembership(CreateProjectMembershipRequest.Builder().apply(block).build())

/**
 * Creates a subsscription grant in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.createSubscriptionGrant(crossinline block: CreateSubscriptionGrantRequest.Builder.() -> Unit): CreateSubscriptionGrantResponse = createSubscriptionGrant(CreateSubscriptionGrantRequest.Builder().apply(block).build())

/**
 * Creates a subscription request in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.createSubscriptionRequest(crossinline block: CreateSubscriptionRequestRequest.Builder.() -> Unit): CreateSubscriptionRequestResponse = createSubscriptionRequest(CreateSubscriptionRequestRequest.Builder().apply(block).build())

/**
 * Creates a subscription target in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.createSubscriptionTarget(crossinline block: CreateSubscriptionTargetRequest.Builder.() -> Unit): CreateSubscriptionTargetResponse = createSubscriptionTarget(CreateSubscriptionTargetRequest.Builder().apply(block).build())

/**
 * Creates a user profile in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.createUserProfile(crossinline block: CreateUserProfileRequest.Builder.() -> Unit): CreateUserProfileResponse = createUserProfile(CreateUserProfileRequest.Builder().apply(block).build())

/**
 * Delets an asset in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteAsset(crossinline block: DeleteAssetRequest.Builder.() -> Unit): DeleteAssetResponse = deleteAsset(DeleteAssetRequest.Builder().apply(block).build())

/**
 * Deletes an asset type in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteAssetType(crossinline block: DeleteAssetTypeRequest.Builder.() -> Unit): DeleteAssetTypeResponse = deleteAssetType(DeleteAssetTypeRequest.Builder().apply(block).build())

/**
 * Deletes a data source in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteDataSource(crossinline block: DeleteDataSourceRequest.Builder.() -> Unit): DeleteDataSourceResponse = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

/**
 * Deletes a Amazon DataZone domain.
 */
public suspend inline fun DataZoneClient.deleteDomain(crossinline block: DeleteDomainRequest.Builder.() -> Unit): DeleteDomainResponse = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

/**
 * Deletes an environment in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteEnvironment(crossinline block: DeleteEnvironmentRequest.Builder.() -> Unit): DeleteEnvironmentResponse = deleteEnvironment(DeleteEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes the blueprint configuration in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteEnvironmentBlueprintConfiguration(crossinline block: DeleteEnvironmentBlueprintConfigurationRequest.Builder.() -> Unit): DeleteEnvironmentBlueprintConfigurationResponse = deleteEnvironmentBlueprintConfiguration(DeleteEnvironmentBlueprintConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes an environment profile in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteEnvironmentProfile(crossinline block: DeleteEnvironmentProfileRequest.Builder.() -> Unit): DeleteEnvironmentProfileResponse = deleteEnvironmentProfile(DeleteEnvironmentProfileRequest.Builder().apply(block).build())

/**
 * Delets and metadata form type in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteFormType(crossinline block: DeleteFormTypeRequest.Builder.() -> Unit): DeleteFormTypeResponse = deleteFormType(DeleteFormTypeRequest.Builder().apply(block).build())

/**
 * Deletes a business glossary in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteGlossary(crossinline block: DeleteGlossaryRequest.Builder.() -> Unit): DeleteGlossaryResponse = deleteGlossary(DeleteGlossaryRequest.Builder().apply(block).build())

/**
 * Deletes a business glossary term in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteGlossaryTerm(crossinline block: DeleteGlossaryTermRequest.Builder.() -> Unit): DeleteGlossaryTermResponse = deleteGlossaryTerm(DeleteGlossaryTermRequest.Builder().apply(block).build())

/**
 * Deletes a listing (a record of an asset at a given time).
 */
public suspend inline fun DataZoneClient.deleteListing(crossinline block: DeleteListingRequest.Builder.() -> Unit): DeleteListingResponse = deleteListing(DeleteListingRequest.Builder().apply(block).build())

/**
 * Deletes a project in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteProject(crossinline block: DeleteProjectRequest.Builder.() -> Unit): DeleteProjectResponse = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

/**
 * Deletes project membership in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteProjectMembership(crossinline block: DeleteProjectMembershipRequest.Builder.() -> Unit): DeleteProjectMembershipResponse = deleteProjectMembership(DeleteProjectMembershipRequest.Builder().apply(block).build())

/**
 * Deletes and subscription grant in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteSubscriptionGrant(crossinline block: DeleteSubscriptionGrantRequest.Builder.() -> Unit): DeleteSubscriptionGrantResponse = deleteSubscriptionGrant(DeleteSubscriptionGrantRequest.Builder().apply(block).build())

/**
 * Deletes a subscription request in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteSubscriptionRequest(crossinline block: DeleteSubscriptionRequestRequest.Builder.() -> Unit): DeleteSubscriptionRequestResponse = deleteSubscriptionRequest(DeleteSubscriptionRequestRequest.Builder().apply(block).build())

/**
 * Deletes a subscription target in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.deleteSubscriptionTarget(crossinline block: DeleteSubscriptionTargetRequest.Builder.() -> Unit): DeleteSubscriptionTargetResponse = deleteSubscriptionTarget(DeleteSubscriptionTargetRequest.Builder().apply(block).build())

/**
 * Deletes the specified time series form for the specified asset.
 */
public suspend inline fun DataZoneClient.deleteTimeSeriesDataPoints(crossinline block: DeleteTimeSeriesDataPointsRequest.Builder.() -> Unit): DeleteTimeSeriesDataPointsResponse = deleteTimeSeriesDataPoints(DeleteTimeSeriesDataPointsRequest.Builder().apply(block).build())

/**
 * Gets an Amazon DataZone asset.
 */
public suspend inline fun DataZoneClient.getAsset(crossinline block: GetAssetRequest.Builder.() -> Unit): GetAssetResponse = getAsset(GetAssetRequest.Builder().apply(block).build())

/**
 * Gets an Amazon DataZone asset type.
 */
public suspend inline fun DataZoneClient.getAssetType(crossinline block: GetAssetTypeRequest.Builder.() -> Unit): GetAssetTypeResponse = getAssetType(GetAssetTypeRequest.Builder().apply(block).build())

/**
 * Gets an Amazon DataZone data source.
 */
public suspend inline fun DataZoneClient.getDataSource(crossinline block: GetDataSourceRequest.Builder.() -> Unit): GetDataSourceResponse = getDataSource(GetDataSourceRequest.Builder().apply(block).build())

/**
 * Gets an Amazon DataZone data source run.
 */
public suspend inline fun DataZoneClient.getDataSourceRun(crossinline block: GetDataSourceRunRequest.Builder.() -> Unit): GetDataSourceRunResponse = getDataSourceRun(GetDataSourceRunRequest.Builder().apply(block).build())

/**
 * Gets an Amazon DataZone domain.
 */
public suspend inline fun DataZoneClient.getDomain(crossinline block: GetDomainRequest.Builder.() -> Unit): GetDomainResponse = getDomain(GetDomainRequest.Builder().apply(block).build())

/**
 * Gets an Amazon DataZone environment.
 */
public suspend inline fun DataZoneClient.getEnvironment(crossinline block: GetEnvironmentRequest.Builder.() -> Unit): GetEnvironmentResponse = getEnvironment(GetEnvironmentRequest.Builder().apply(block).build())

/**
 * Gets an Amazon DataZone blueprint.
 */
public suspend inline fun DataZoneClient.getEnvironmentBlueprint(crossinline block: GetEnvironmentBlueprintRequest.Builder.() -> Unit): GetEnvironmentBlueprintResponse = getEnvironmentBlueprint(GetEnvironmentBlueprintRequest.Builder().apply(block).build())

/**
 * Gets the blueprint configuration in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getEnvironmentBlueprintConfiguration(crossinline block: GetEnvironmentBlueprintConfigurationRequest.Builder.() -> Unit): GetEnvironmentBlueprintConfigurationResponse = getEnvironmentBlueprintConfiguration(GetEnvironmentBlueprintConfigurationRequest.Builder().apply(block).build())

/**
 * Gets an evinronment profile in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getEnvironmentProfile(crossinline block: GetEnvironmentProfileRequest.Builder.() -> Unit): GetEnvironmentProfileResponse = getEnvironmentProfile(GetEnvironmentProfileRequest.Builder().apply(block).build())

/**
 * Gets a metadata form type in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getFormType(crossinline block: GetFormTypeRequest.Builder.() -> Unit): GetFormTypeResponse = getFormType(GetFormTypeRequest.Builder().apply(block).build())

/**
 * Gets a business glossary in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getGlossary(crossinline block: GetGlossaryRequest.Builder.() -> Unit): GetGlossaryResponse = getGlossary(GetGlossaryRequest.Builder().apply(block).build())

/**
 * Gets a business glossary term in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getGlossaryTerm(crossinline block: GetGlossaryTermRequest.Builder.() -> Unit): GetGlossaryTermResponse = getGlossaryTerm(GetGlossaryTermRequest.Builder().apply(block).build())

/**
 * Gets a group profile in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getGroupProfile(crossinline block: GetGroupProfileRequest.Builder.() -> Unit): GetGroupProfileResponse = getGroupProfile(GetGroupProfileRequest.Builder().apply(block).build())

/**
 * Gets the data portal URL for the specified Amazon DataZone domain.
 */
public suspend inline fun DataZoneClient.getIamPortalLoginUrl(crossinline block: GetIamPortalLoginUrlRequest.Builder.() -> Unit): GetIamPortalLoginUrlResponse = getIamPortalLoginUrl(GetIamPortalLoginUrlRequest.Builder().apply(block).build())

/**
 * Gets a listing (a record of an asset at a given time).
 */
public suspend inline fun DataZoneClient.getListing(crossinline block: GetListingRequest.Builder.() -> Unit): GetListingResponse = getListing(GetListingRequest.Builder().apply(block).build())

/**
 * Gets a metadata generation run in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getMetadataGenerationRun(crossinline block: GetMetadataGenerationRunRequest.Builder.() -> Unit): GetMetadataGenerationRunResponse = getMetadataGenerationRun(GetMetadataGenerationRunRequest.Builder().apply(block).build())

/**
 * Gets a project in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getProject(crossinline block: GetProjectRequest.Builder.() -> Unit): GetProjectResponse = getProject(GetProjectRequest.Builder().apply(block).build())

/**
 * Gets a subscription in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getSubscription(crossinline block: GetSubscriptionRequest.Builder.() -> Unit): GetSubscriptionResponse = getSubscription(GetSubscriptionRequest.Builder().apply(block).build())

/**
 * Gets the subscription grant in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getSubscriptionGrant(crossinline block: GetSubscriptionGrantRequest.Builder.() -> Unit): GetSubscriptionGrantResponse = getSubscriptionGrant(GetSubscriptionGrantRequest.Builder().apply(block).build())

/**
 * Gets the details of the specified subscription request.
 */
public suspend inline fun DataZoneClient.getSubscriptionRequestDetails(crossinline block: GetSubscriptionRequestDetailsRequest.Builder.() -> Unit): GetSubscriptionRequestDetailsResponse = getSubscriptionRequestDetails(GetSubscriptionRequestDetailsRequest.Builder().apply(block).build())

/**
 * Gets the subscription target in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getSubscriptionTarget(crossinline block: GetSubscriptionTargetRequest.Builder.() -> Unit): GetSubscriptionTargetResponse = getSubscriptionTarget(GetSubscriptionTargetRequest.Builder().apply(block).build())

/**
 * Gets the existing data point for the asset.
 */
public suspend inline fun DataZoneClient.getTimeSeriesDataPoint(crossinline block: GetTimeSeriesDataPointRequest.Builder.() -> Unit): GetTimeSeriesDataPointResponse = getTimeSeriesDataPoint(GetTimeSeriesDataPointRequest.Builder().apply(block).build())

/**
 * Gets a user profile in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.getUserProfile(crossinline block: GetUserProfileRequest.Builder.() -> Unit): GetUserProfileResponse = getUserProfile(GetUserProfileRequest.Builder().apply(block).build())

/**
 * Lists the revisions for the asset.
 */
public suspend inline fun DataZoneClient.listAssetRevisions(crossinline block: ListAssetRevisionsRequest.Builder.() -> Unit): ListAssetRevisionsResponse = listAssetRevisions(ListAssetRevisionsRequest.Builder().apply(block).build())

/**
 * Lists data source run activities.
 */
public suspend inline fun DataZoneClient.listDataSourceRunActivities(crossinline block: ListDataSourceRunActivitiesRequest.Builder.() -> Unit): ListDataSourceRunActivitiesResponse = listDataSourceRunActivities(ListDataSourceRunActivitiesRequest.Builder().apply(block).build())

/**
 * Lists data source runs in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.listDataSourceRuns(crossinline block: ListDataSourceRunsRequest.Builder.() -> Unit): ListDataSourceRunsResponse = listDataSourceRuns(ListDataSourceRunsRequest.Builder().apply(block).build())

/**
 * Lists data sources in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.listDataSources(crossinline block: ListDataSourcesRequest.Builder.() -> Unit): ListDataSourcesResponse = listDataSources(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * Lists Amazon DataZone domains.
 */
public suspend inline fun DataZoneClient.listDomains(crossinline block: ListDomainsRequest.Builder.() -> Unit): ListDomainsResponse = listDomains(ListDomainsRequest.Builder().apply(block).build())

/**
 * Lists blueprint configurations for a Amazon DataZone environment.
 */
public suspend inline fun DataZoneClient.listEnvironmentBlueprintConfigurations(crossinline block: ListEnvironmentBlueprintConfigurationsRequest.Builder.() -> Unit): ListEnvironmentBlueprintConfigurationsResponse = listEnvironmentBlueprintConfigurations(ListEnvironmentBlueprintConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists blueprints in an Amazon DataZone environment.
 */
public suspend inline fun DataZoneClient.listEnvironmentBlueprints(crossinline block: ListEnvironmentBlueprintsRequest.Builder.() -> Unit): ListEnvironmentBlueprintsResponse = listEnvironmentBlueprints(ListEnvironmentBlueprintsRequest.Builder().apply(block).build())

/**
 * Lists Amazon DataZone environment profiles.
 */
public suspend inline fun DataZoneClient.listEnvironmentProfiles(crossinline block: ListEnvironmentProfilesRequest.Builder.() -> Unit): ListEnvironmentProfilesResponse = listEnvironmentProfiles(ListEnvironmentProfilesRequest.Builder().apply(block).build())

/**
 * Lists Amazon DataZone environments.
 */
public suspend inline fun DataZoneClient.listEnvironments(crossinline block: ListEnvironmentsRequest.Builder.() -> Unit): ListEnvironmentsResponse = listEnvironments(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * Lists all metadata generation runs.
 */
public suspend inline fun DataZoneClient.listMetadataGenerationRuns(crossinline block: ListMetadataGenerationRunsRequest.Builder.() -> Unit): ListMetadataGenerationRunsResponse = listMetadataGenerationRuns(ListMetadataGenerationRunsRequest.Builder().apply(block).build())

/**
 * Lists all Amazon DataZone notifications.
 */
public suspend inline fun DataZoneClient.listNotifications(crossinline block: ListNotificationsRequest.Builder.() -> Unit): ListNotificationsResponse = listNotifications(ListNotificationsRequest.Builder().apply(block).build())

/**
 * Lists all members of the specified project.
 */
public suspend inline fun DataZoneClient.listProjectMemberships(crossinline block: ListProjectMembershipsRequest.Builder.() -> Unit): ListProjectMembershipsResponse = listProjectMemberships(ListProjectMembershipsRequest.Builder().apply(block).build())

/**
 * Lists Amazon DataZone projects.
 */
public suspend inline fun DataZoneClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit): ListProjectsResponse = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Lists subscription grants.
 */
public suspend inline fun DataZoneClient.listSubscriptionGrants(crossinline block: ListSubscriptionGrantsRequest.Builder.() -> Unit): ListSubscriptionGrantsResponse = listSubscriptionGrants(ListSubscriptionGrantsRequest.Builder().apply(block).build())

/**
 * Lists Amazon DataZone subscription requests.
 */
public suspend inline fun DataZoneClient.listSubscriptionRequests(crossinline block: ListSubscriptionRequestsRequest.Builder.() -> Unit): ListSubscriptionRequestsResponse = listSubscriptionRequests(ListSubscriptionRequestsRequest.Builder().apply(block).build())

/**
 * Lists subscription targets in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.listSubscriptionTargets(crossinline block: ListSubscriptionTargetsRequest.Builder.() -> Unit): ListSubscriptionTargetsResponse = listSubscriptionTargets(ListSubscriptionTargetsRequest.Builder().apply(block).build())

/**
 * Lists subscriptions in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.listSubscriptions(crossinline block: ListSubscriptionsRequest.Builder.() -> Unit): ListSubscriptionsResponse = listSubscriptions(ListSubscriptionsRequest.Builder().apply(block).build())

/**
 * Lists tags for the specified resource in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists time series data points.
 */
public suspend inline fun DataZoneClient.listTimeSeriesDataPoints(crossinline block: ListTimeSeriesDataPointsRequest.Builder.() -> Unit): ListTimeSeriesDataPointsResponse = listTimeSeriesDataPoints(ListTimeSeriesDataPointsRequest.Builder().apply(block).build())

/**
 * Posts time series data points to Amazon DataZone for the specified asset.
 */
public suspend inline fun DataZoneClient.postTimeSeriesDataPoints(crossinline block: PostTimeSeriesDataPointsRequest.Builder.() -> Unit): PostTimeSeriesDataPointsResponse = postTimeSeriesDataPoints(PostTimeSeriesDataPointsRequest.Builder().apply(block).build())

/**
 * Writes the configuration for the specified environment blueprint in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.putEnvironmentBlueprintConfiguration(crossinline block: PutEnvironmentBlueprintConfigurationRequest.Builder.() -> Unit): PutEnvironmentBlueprintConfigurationResponse = putEnvironmentBlueprintConfiguration(PutEnvironmentBlueprintConfigurationRequest.Builder().apply(block).build())

/**
 * Rejects automatically generated business-friendly metadata for your Amazon DataZone assets.
 */
public suspend inline fun DataZoneClient.rejectPredictions(crossinline block: RejectPredictionsRequest.Builder.() -> Unit): RejectPredictionsResponse = rejectPredictions(RejectPredictionsRequest.Builder().apply(block).build())

/**
 * Rejects the specified subscription request.
 */
public suspend inline fun DataZoneClient.rejectSubscriptionRequest(crossinline block: RejectSubscriptionRequestRequest.Builder.() -> Unit): RejectSubscriptionRequestResponse = rejectSubscriptionRequest(RejectSubscriptionRequestRequest.Builder().apply(block).build())

/**
 * Revokes a specified subscription in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.revokeSubscription(crossinline block: RevokeSubscriptionRequest.Builder.() -> Unit): RevokeSubscriptionResponse = revokeSubscription(RevokeSubscriptionRequest.Builder().apply(block).build())

/**
 * Searches for assets in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.search(crossinline block: SearchRequest.Builder.() -> Unit): SearchResponse = search(SearchRequest.Builder().apply(block).build())

/**
 * Searches group profiles in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.searchGroupProfiles(crossinline block: SearchGroupProfilesRequest.Builder.() -> Unit): SearchGroupProfilesResponse = searchGroupProfiles(SearchGroupProfilesRequest.Builder().apply(block).build())

/**
 * Searches listings (records of an asset at a given time) in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.searchListings(crossinline block: SearchListingsRequest.Builder.() -> Unit): SearchListingsResponse = searchListings(SearchListingsRequest.Builder().apply(block).build())

/**
 * Searches for types in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.searchTypes(crossinline block: SearchTypesRequest.Builder.() -> Unit): SearchTypesResponse = searchTypes(SearchTypesRequest.Builder().apply(block).build())

/**
 * Searches user profiles in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.searchUserProfiles(crossinline block: SearchUserProfilesRequest.Builder.() -> Unit): SearchUserProfilesResponse = searchUserProfiles(SearchUserProfilesRequest.Builder().apply(block).build())

/**
 * Start the run of the specified data source in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.startDataSourceRun(crossinline block: StartDataSourceRunRequest.Builder.() -> Unit): StartDataSourceRunResponse = startDataSourceRun(StartDataSourceRunRequest.Builder().apply(block).build())

/**
 * Starts the metadata generation run.
 */
public suspend inline fun DataZoneClient.startMetadataGenerationRun(crossinline block: StartMetadataGenerationRunRequest.Builder.() -> Unit): StartMetadataGenerationRunResponse = startMetadataGenerationRun(StartMetadataGenerationRunRequest.Builder().apply(block).build())

/**
 * Tags a resource in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Untags a resource in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified data source in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.updateDataSource(crossinline block: UpdateDataSourceRequest.Builder.() -> Unit): UpdateDataSourceResponse = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

/**
 * Updates a Amazon DataZone domain.
 */
public suspend inline fun DataZoneClient.updateDomain(crossinline block: UpdateDomainRequest.Builder.() -> Unit): UpdateDomainResponse = updateDomain(UpdateDomainRequest.Builder().apply(block).build())

/**
 * Updates the specified environment in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.updateEnvironment(crossinline block: UpdateEnvironmentRequest.Builder.() -> Unit): UpdateEnvironmentResponse = updateEnvironment(UpdateEnvironmentRequest.Builder().apply(block).build())

/**
 * Updates the specified environment profile in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.updateEnvironmentProfile(crossinline block: UpdateEnvironmentProfileRequest.Builder.() -> Unit): UpdateEnvironmentProfileResponse = updateEnvironmentProfile(UpdateEnvironmentProfileRequest.Builder().apply(block).build())

/**
 * Updates the business glossary in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.updateGlossary(crossinline block: UpdateGlossaryRequest.Builder.() -> Unit): UpdateGlossaryResponse = updateGlossary(UpdateGlossaryRequest.Builder().apply(block).build())

/**
 * Updates a business glossary term in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.updateGlossaryTerm(crossinline block: UpdateGlossaryTermRequest.Builder.() -> Unit): UpdateGlossaryTermResponse = updateGlossaryTerm(UpdateGlossaryTermRequest.Builder().apply(block).build())

/**
 * Updates the specified group profile in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.updateGroupProfile(crossinline block: UpdateGroupProfileRequest.Builder.() -> Unit): UpdateGroupProfileResponse = updateGroupProfile(UpdateGroupProfileRequest.Builder().apply(block).build())

/**
 * Updates the specified project in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.updateProject(crossinline block: UpdateProjectRequest.Builder.() -> Unit): UpdateProjectResponse = updateProject(UpdateProjectRequest.Builder().apply(block).build())

/**
 * Updates the status of the specified subscription grant status in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.updateSubscriptionGrantStatus(crossinline block: UpdateSubscriptionGrantStatusRequest.Builder.() -> Unit): UpdateSubscriptionGrantStatusResponse = updateSubscriptionGrantStatus(UpdateSubscriptionGrantStatusRequest.Builder().apply(block).build())

/**
 * Updates a specified subscription request in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.updateSubscriptionRequest(crossinline block: UpdateSubscriptionRequestRequest.Builder.() -> Unit): UpdateSubscriptionRequestResponse = updateSubscriptionRequest(UpdateSubscriptionRequestRequest.Builder().apply(block).build())

/**
 * Updates the specified subscription target in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.updateSubscriptionTarget(crossinline block: UpdateSubscriptionTargetRequest.Builder.() -> Unit): UpdateSubscriptionTargetResponse = updateSubscriptionTarget(UpdateSubscriptionTargetRequest.Builder().apply(block).build())

/**
 * Updates the specified user profile in Amazon DataZone.
 */
public suspend inline fun DataZoneClient.updateUserProfile(crossinline block: UpdateUserProfileRequest.Builder.() -> Unit): UpdateUserProfileResponse = updateUserProfile(UpdateUserProfileRequest.Builder().apply(block).build())
