// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.ConfigurableEnvironmentAction
import aws.sdk.kotlin.services.datazone.model.CustomParameter
import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.Deployment
import aws.sdk.kotlin.services.datazone.model.DeploymentProperties
import aws.sdk.kotlin.services.datazone.model.EnvironmentStatus
import aws.sdk.kotlin.services.datazone.model.ProvisioningProperties
import aws.sdk.kotlin.services.datazone.model.Resource
import aws.sdk.kotlin.services.datazone.model.UpdateEnvironmentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class UpdateEnvironmentOperationDeserializer: HttpDeserialize<UpdateEnvironmentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateEnvironmentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateEnvironmentError(context, call)
        }
        val builder = UpdateEnvironmentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateEnvironmentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateEnvironmentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateEnvironmentOperationBody(builder: UpdateEnvironmentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AWSACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsAccountId"))
    val AWSACCOUNTREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsAccountRegion"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdBy"))
    val DEPLOYMENTPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deploymentProperties"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val ENVIRONMENTACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("environmentActions"))
    val ENVIRONMENTBLUEPRINTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentBlueprintId"))
    val ENVIRONMENTPROFILEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentProfileId"))
    val GLOSSARYTERMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("glossaryTerms"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LASTDEPLOYMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("lastDeployment"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectId"))
    val PROVIDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("provider"))
    val PROVISIONEDRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("provisionedResources"))
    val PROVISIONINGPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("provisioningProperties"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val USERPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("userParameters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AWSACCOUNTID_DESCRIPTOR)
        field(AWSACCOUNTREGION_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(DEPLOYMENTPROPERTIES_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(ENVIRONMENTACTIONS_DESCRIPTOR)
        field(ENVIRONMENTBLUEPRINTID_DESCRIPTOR)
        field(ENVIRONMENTPROFILEID_DESCRIPTOR)
        field(GLOSSARYTERMS_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LASTDEPLOYMENT_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROJECTID_DESCRIPTOR)
        field(PROVIDER_DESCRIPTOR)
        field(PROVISIONEDRESOURCES_DESCRIPTOR)
        field(PROVISIONINGPROPERTIES_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
        field(USERPARAMETERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AWSACCOUNTID_DESCRIPTOR.index -> builder.awsAccountId = deserializeString()
                AWSACCOUNTREGION_DESCRIPTOR.index -> builder.awsAccountRegion = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                DEPLOYMENTPROPERTIES_DESCRIPTOR.index -> builder.deploymentProperties = deserializeDeploymentPropertiesDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                ENVIRONMENTACTIONS_DESCRIPTOR.index -> builder.environmentActions =
                    deserializer.deserializeList(ENVIRONMENTACTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ConfigurableEnvironmentAction>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConfigurableEnvironmentActionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENVIRONMENTBLUEPRINTID_DESCRIPTOR.index -> builder.environmentBlueprintId = deserializeString()
                ENVIRONMENTPROFILEID_DESCRIPTOR.index -> builder.environmentProfileId = deserializeString()
                GLOSSARYTERMS_DESCRIPTOR.index -> builder.glossaryTerms =
                    deserializer.deserializeList(GLOSSARYTERMS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LASTDEPLOYMENT_DESCRIPTOR.index -> builder.lastDeployment = deserializeDeploymentDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PROJECTID_DESCRIPTOR.index -> builder.projectId = deserializeString()
                PROVIDER_DESCRIPTOR.index -> builder.provider = deserializeString()
                PROVISIONEDRESOURCES_DESCRIPTOR.index -> builder.provisionedResources =
                    deserializer.deserializeList(PROVISIONEDRESOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<Resource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROVISIONINGPROPERTIES_DESCRIPTOR.index -> builder.provisioningProperties = deserializeProvisioningPropertiesDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EnvironmentStatus.fromValue(it) }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromIso8601(it) }
                USERPARAMETERS_DESCRIPTOR.index -> builder.userParameters =
                    deserializer.deserializeList(USERPARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<CustomParameter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCustomParameterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
