// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.FormTypeStatus
import aws.sdk.kotlin.services.datazone.model.GetFormTypeResponse
import aws.sdk.kotlin.services.datazone.model.Import
import aws.sdk.kotlin.services.datazone.model.Model
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetFormTypeOperationDeserializer: HttpDeserialize<GetFormTypeResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetFormTypeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetFormTypeError(context, call)
        }
        val builder = GetFormTypeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFormTypeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetFormTypeError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFormTypeOperationBody(builder: GetFormTypeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdBy"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val IMPORTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("imports"))
    val MODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("model"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val ORIGINDOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("originDomainId"))
    val ORIGINPROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("originProjectId"))
    val OWNINGPROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("owningProjectId"))
    val REVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("revision"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(IMPORTS_DESCRIPTOR)
        field(MODEL_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ORIGINDOMAINID_DESCRIPTOR)
        field(ORIGINPROJECTID_DESCRIPTOR)
        field(OWNINGPROJECTID_DESCRIPTOR)
        field(REVISION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                IMPORTS_DESCRIPTOR.index -> builder.imports =
                    deserializer.deserializeList(IMPORTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Import>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeImportDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MODEL_DESCRIPTOR.index -> builder.model = deserializeModelDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ORIGINDOMAINID_DESCRIPTOR.index -> builder.originDomainId = deserializeString()
                ORIGINPROJECTID_DESCRIPTOR.index -> builder.originProjectId = deserializeString()
                OWNINGPROJECTID_DESCRIPTOR.index -> builder.owningProjectId = deserializeString()
                REVISION_DESCRIPTOR.index -> builder.revision = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { FormTypeStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
