// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

public class RevokeSubscriptionResponse private constructor(builder: Builder) {
    /**
     * The timestamp of when the subscription was revoked.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The identifier of the user who revoked the subscription.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The identifier of the Amazon DataZone domain where you want to revoke a subscription.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The identifier of the revoked subscription.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Specifies whether permissions are retained when the subscription is revoked.
     */
    public val retainPermissions: kotlin.Boolean? = builder.retainPermissions
    /**
     * The status of the revoked subscription.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.SubscriptionStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The subscribed listing of the revoked subscription.
     */
    public val subscribedListing: aws.sdk.kotlin.services.datazone.model.SubscribedListing? = builder.subscribedListing
    /**
     * The subscribed principal of the revoked subscription.
     */
    public val subscribedPrincipal: aws.sdk.kotlin.services.datazone.model.SubscribedPrincipal? = builder.subscribedPrincipal
    /**
     * The identifier of the subscription request for the revoked subscription.
     */
    public val subscriptionRequestId: kotlin.String? = builder.subscriptionRequestId
    /**
     * The timestamp of when the subscription was revoked.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * The Amazon DataZone user who revoked the subscription.
     */
    public val updatedBy: kotlin.String? = builder.updatedBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.RevokeSubscriptionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RevokeSubscriptionResponse(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("domainId=$domainId,")
        append("id=$id,")
        append("retainPermissions=$retainPermissions,")
        append("status=$status,")
        append("subscribedListing=$subscribedListing,")
        append("subscribedPrincipal=$subscribedPrincipal,")
        append("subscriptionRequestId=$subscriptionRequestId,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (retainPermissions?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (subscribedListing?.hashCode() ?: 0)
        result = 31 * result + (subscribedPrincipal?.hashCode() ?: 0)
        result = 31 * result + (subscriptionRequestId?.hashCode() ?: 0)
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (updatedBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RevokeSubscriptionResponse

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (domainId != other.domainId) return false
        if (id != other.id) return false
        if (retainPermissions != other.retainPermissions) return false
        if (status != other.status) return false
        if (subscribedListing != other.subscribedListing) return false
        if (subscribedPrincipal != other.subscribedPrincipal) return false
        if (subscriptionRequestId != other.subscriptionRequestId) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.RevokeSubscriptionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp of when the subscription was revoked.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the user who revoked the subscription.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain where you want to revoke a subscription.
         */
        public var domainId: kotlin.String? = null
        /**
         * The identifier of the revoked subscription.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies whether permissions are retained when the subscription is revoked.
         */
        public var retainPermissions: kotlin.Boolean? = null
        /**
         * The status of the revoked subscription.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.SubscriptionStatus? = null
        /**
         * The subscribed listing of the revoked subscription.
         */
        public var subscribedListing: aws.sdk.kotlin.services.datazone.model.SubscribedListing? = null
        /**
         * The subscribed principal of the revoked subscription.
         */
        public var subscribedPrincipal: aws.sdk.kotlin.services.datazone.model.SubscribedPrincipal? = null
        /**
         * The identifier of the subscription request for the revoked subscription.
         */
        public var subscriptionRequestId: kotlin.String? = null
        /**
         * The timestamp of when the subscription was revoked.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who revoked the subscription.
         */
        public var updatedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.RevokeSubscriptionResponse) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.domainId = x.domainId
            this.id = x.id
            this.retainPermissions = x.retainPermissions
            this.status = x.status
            this.subscribedListing = x.subscribedListing
            this.subscribedPrincipal = x.subscribedPrincipal
            this.subscriptionRequestId = x.subscriptionRequestId
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.RevokeSubscriptionResponse = RevokeSubscriptionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.SubscribedListing] inside the given [block]
         */
        public fun subscribedListing(block: aws.sdk.kotlin.services.datazone.model.SubscribedListing.Builder.() -> kotlin.Unit) {
            this.subscribedListing = aws.sdk.kotlin.services.datazone.model.SubscribedListing.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (createdBy == null) createdBy = ""
            if (domainId == null) domainId = ""
            if (id == null) id = ""
            if (status == null) status = SubscriptionStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
