// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model



public class ListSubscriptionTargetsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon DataZone domain where you want to list subscription targets.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The identifier of the environment where you want to list subscription targets.
     */
    public val environmentIdentifier: kotlin.String? = builder.environmentIdentifier
    /**
     * The maximum number of subscription targets to return in a single call to `ListSubscriptionTargets`. When the number of subscription targets to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListSubscriptionTargets` to list the next set of subscription targets.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When the number of subscription targets is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of subscription targets, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListSubscriptionTargets` to list the next set of subscription targets.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Specifies the way in which the results of this action are to be sorted.
     */
    public val sortBy: aws.sdk.kotlin.services.datazone.model.SortKey? = builder.sortBy
    /**
     * Specifies the sort order for the results of this action.
     */
    public val sortOrder: aws.sdk.kotlin.services.datazone.model.SortOrder? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.ListSubscriptionTargetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSubscriptionTargetsRequest(")
        append("domainIdentifier=$domainIdentifier,")
        append("environmentIdentifier=$environmentIdentifier,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainIdentifier?.hashCode() ?: 0
        result = 31 * result + (environmentIdentifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSubscriptionTargetsRequest

        if (domainIdentifier != other.domainIdentifier) return false
        if (environmentIdentifier != other.environmentIdentifier) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.ListSubscriptionTargetsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the Amazon DataZone domain where you want to list subscription targets.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The identifier of the environment where you want to list subscription targets.
         */
        public var environmentIdentifier: kotlin.String? = null
        /**
         * The maximum number of subscription targets to return in a single call to `ListSubscriptionTargets`. When the number of subscription targets to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListSubscriptionTargets` to list the next set of subscription targets.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When the number of subscription targets is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of subscription targets, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListSubscriptionTargets` to list the next set of subscription targets.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Specifies the way in which the results of this action are to be sorted.
         */
        public var sortBy: aws.sdk.kotlin.services.datazone.model.SortKey? = null
        /**
         * Specifies the sort order for the results of this action.
         */
        public var sortOrder: aws.sdk.kotlin.services.datazone.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.ListSubscriptionTargetsRequest) : this() {
            this.domainIdentifier = x.domainIdentifier
            this.environmentIdentifier = x.environmentIdentifier
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.ListSubscriptionTargetsRequest = ListSubscriptionTargetsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
