// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The activity details of the data source run.
 */
public class DataSourceRunActivity private constructor(builder: Builder) {
    /**
     * The timestamp of when data source run activity was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The identifier of the asset included in the data source run activity.
     */
    public val dataAssetId: kotlin.String? = builder.dataAssetId
    /**
     * The status of the asset included in the data source run activity.
     */
    public val dataAssetStatus: aws.sdk.kotlin.services.datazone.model.DataAssetActivityStatus = requireNotNull(builder.dataAssetStatus) { "A non-null value must be provided for dataAssetStatus" }
    /**
     * The identifier of the data source for the data source run activity.
     */
    public val dataSourceRunId: kotlin.String = requireNotNull(builder.dataSourceRunId) { "A non-null value must be provided for dataSourceRunId" }
    /**
     * The database included in the data source run activity.
     */
    public val database: kotlin.String = requireNotNull(builder.database) { "A non-null value must be provided for database" }
    /**
     * The details of the error message that is returned if the operation cannot be successfully completed.
     */
    public val errorMessage: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage? = builder.errorMessage
    /**
     * The project ID included in the data source run activity.
     */
    public val projectId: kotlin.String = requireNotNull(builder.projectId) { "A non-null value must be provided for projectId" }
    /**
     * The technical description included in the data source run activity.
     */
    public val technicalDescription: kotlin.String? = builder.technicalDescription
    /**
     * The technical name included in the data source run activity.
     */
    public val technicalName: kotlin.String = requireNotNull(builder.technicalName) { "A non-null value must be provided for technicalName" }
    /**
     * The timestamp of when data source run activity was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.DataSourceRunActivity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceRunActivity(")
        append("createdAt=$createdAt,")
        append("dataAssetId=$dataAssetId,")
        append("dataAssetStatus=$dataAssetStatus,")
        append("dataSourceRunId=$dataSourceRunId,")
        append("database=*** Sensitive Data Redacted ***,")
        append("errorMessage=$errorMessage,")
        append("projectId=$projectId,")
        append("technicalDescription=*** Sensitive Data Redacted ***,")
        append("technicalName=*** Sensitive Data Redacted ***,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (dataAssetId?.hashCode() ?: 0)
        result = 31 * result + (dataAssetStatus.hashCode())
        result = 31 * result + (dataSourceRunId.hashCode())
        result = 31 * result + (database.hashCode())
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (projectId.hashCode())
        result = 31 * result + (technicalDescription?.hashCode() ?: 0)
        result = 31 * result + (technicalName.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceRunActivity

        if (createdAt != other.createdAt) return false
        if (dataAssetId != other.dataAssetId) return false
        if (dataAssetStatus != other.dataAssetStatus) return false
        if (dataSourceRunId != other.dataSourceRunId) return false
        if (database != other.database) return false
        if (errorMessage != other.errorMessage) return false
        if (projectId != other.projectId) return false
        if (technicalDescription != other.technicalDescription) return false
        if (technicalName != other.technicalName) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.DataSourceRunActivity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp of when data source run activity was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the asset included in the data source run activity.
         */
        public var dataAssetId: kotlin.String? = null
        /**
         * The status of the asset included in the data source run activity.
         */
        public var dataAssetStatus: aws.sdk.kotlin.services.datazone.model.DataAssetActivityStatus? = null
        /**
         * The identifier of the data source for the data source run activity.
         */
        public var dataSourceRunId: kotlin.String? = null
        /**
         * The database included in the data source run activity.
         */
        public var database: kotlin.String? = null
        /**
         * The details of the error message that is returned if the operation cannot be successfully completed.
         */
        public var errorMessage: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage? = null
        /**
         * The project ID included in the data source run activity.
         */
        public var projectId: kotlin.String? = null
        /**
         * The technical description included in the data source run activity.
         */
        public var technicalDescription: kotlin.String? = null
        /**
         * The technical name included in the data source run activity.
         */
        public var technicalName: kotlin.String? = null
        /**
         * The timestamp of when data source run activity was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.DataSourceRunActivity) : this() {
            this.createdAt = x.createdAt
            this.dataAssetId = x.dataAssetId
            this.dataAssetStatus = x.dataAssetStatus
            this.dataSourceRunId = x.dataSourceRunId
            this.database = x.database
            this.errorMessage = x.errorMessage
            this.projectId = x.projectId
            this.technicalDescription = x.technicalDescription
            this.technicalName = x.technicalName
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.DataSourceRunActivity = DataSourceRunActivity(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage] inside the given [block]
         */
        public fun errorMessage(block: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage.Builder.() -> kotlin.Unit) {
            this.errorMessage = aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (dataAssetStatus == null) dataAssetStatus = DataAssetActivityStatus.SdkUnknown("no value provided")
            if (dataSourceRunId == null) dataSourceRunId = ""
            if (database == null) database = ""
            if (projectId == null) projectId = ""
            if (technicalName == null) technicalName = ""
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
