// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateSubscriptionGrantResponse private constructor(builder: Builder) {
    /**
     * The assets for which the subscription grant is created.
     */
    public val assets: List<SubscribedAsset>? = builder.assets
    /**
     * A timestamp of when the subscription grant is created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The Amazon DataZone user who created the subscription grant.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The ID of the Amazon DataZone domain in which the subscription grant is created.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The entity to which the subscription is granted.
     */
    public val grantedEntity: aws.sdk.kotlin.services.datazone.model.GrantedEntity? = builder.grantedEntity
    /**
     * The ID of the subscription grant.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The status of the subscription grant.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.SubscriptionGrantOverallStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The identifier of the subscription grant.
     */
    public val subscriptionId: kotlin.String? = builder.subscriptionId
    /**
     * The ID of the subscription target for which the subscription grant is created.
     */
    public val subscriptionTargetId: kotlin.String = requireNotNull(builder.subscriptionTargetId) { "A non-null value must be provided for subscriptionTargetId" }
    /**
     * A timestamp of when the subscription grant was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * The Amazon DataZone user who updated the subscription grant.
     */
    public val updatedBy: kotlin.String? = builder.updatedBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.CreateSubscriptionGrantResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSubscriptionGrantResponse(")
        append("assets=$assets,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("domainId=$domainId,")
        append("grantedEntity=$grantedEntity,")
        append("id=$id,")
        append("status=$status,")
        append("subscriptionId=$subscriptionId,")
        append("subscriptionTargetId=$subscriptionTargetId,")
        append("updatedAt=$updatedAt,")
        append("updatedBy=$updatedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assets?.hashCode() ?: 0
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (grantedEntity?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (subscriptionId?.hashCode() ?: 0)
        result = 31 * result + (subscriptionTargetId.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (updatedBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSubscriptionGrantResponse

        if (assets != other.assets) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (domainId != other.domainId) return false
        if (grantedEntity != other.grantedEntity) return false
        if (id != other.id) return false
        if (status != other.status) return false
        if (subscriptionId != other.subscriptionId) return false
        if (subscriptionTargetId != other.subscriptionTargetId) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedBy != other.updatedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.CreateSubscriptionGrantResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The assets for which the subscription grant is created.
         */
        public var assets: List<SubscribedAsset>? = null
        /**
         * A timestamp of when the subscription grant is created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who created the subscription grant.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone domain in which the subscription grant is created.
         */
        public var domainId: kotlin.String? = null
        /**
         * The entity to which the subscription is granted.
         */
        public var grantedEntity: aws.sdk.kotlin.services.datazone.model.GrantedEntity? = null
        /**
         * The ID of the subscription grant.
         */
        public var id: kotlin.String? = null
        /**
         * The status of the subscription grant.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.SubscriptionGrantOverallStatus? = null
        /**
         * The identifier of the subscription grant.
         */
        public var subscriptionId: kotlin.String? = null
        /**
         * The ID of the subscription target for which the subscription grant is created.
         */
        public var subscriptionTargetId: kotlin.String? = null
        /**
         * A timestamp of when the subscription grant was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who updated the subscription grant.
         */
        public var updatedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.CreateSubscriptionGrantResponse) : this() {
            this.assets = x.assets
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.domainId = x.domainId
            this.grantedEntity = x.grantedEntity
            this.id = x.id
            this.status = x.status
            this.subscriptionId = x.subscriptionId
            this.subscriptionTargetId = x.subscriptionTargetId
            this.updatedAt = x.updatedAt
            this.updatedBy = x.updatedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.CreateSubscriptionGrantResponse = CreateSubscriptionGrantResponse(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (createdBy == null) createdBy = ""
            if (domainId == null) domainId = ""
            if (id == null) id = ""
            if (status == null) status = SubscriptionGrantOverallStatus.SdkUnknown("no value provided")
            if (subscriptionTargetId == null) subscriptionTargetId = ""
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
