// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.RejectSubscriptionRequestResponse
import aws.sdk.kotlin.services.datazone.model.SubscribedListing
import aws.sdk.kotlin.services.datazone.model.SubscribedPrincipal
import aws.sdk.kotlin.services.datazone.model.SubscriptionRequestStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class RejectSubscriptionRequestOperationDeserializer: HttpDeserializer.NonStreaming<RejectSubscriptionRequestResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RejectSubscriptionRequestResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRejectSubscriptionRequestError(context, call, payload)
        }
        val builder = RejectSubscriptionRequestResponse.Builder()

        if (payload != null) {
            deserializeRejectSubscriptionRequestOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRejectSubscriptionRequestError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRejectSubscriptionRequestOperationBody(builder: RejectSubscriptionRequestResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdBy"))
    val DECISIONCOMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("decisionComment"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val REQUESTREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestReason"))
    val REVIEWERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("reviewerId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val SUBSCRIBEDLISTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subscribedListings"))
    val SUBSCRIBEDPRINCIPALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subscribedPrincipals"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val UPDATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("updatedBy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(DECISIONCOMMENT_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(REQUESTREASON_DESCRIPTOR)
        field(REVIEWERID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUBSCRIBEDLISTINGS_DESCRIPTOR)
        field(SUBSCRIBEDPRINCIPALS_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
        field(UPDATEDBY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                DECISIONCOMMENT_DESCRIPTOR.index -> builder.decisionComment = deserializeString()
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                REQUESTREASON_DESCRIPTOR.index -> builder.requestReason = deserializeString()
                REVIEWERID_DESCRIPTOR.index -> builder.reviewerId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SubscriptionRequestStatus.fromValue(it) }
                SUBSCRIBEDLISTINGS_DESCRIPTOR.index -> builder.subscribedListings =
                    deserializer.deserializeList(SUBSCRIBEDLISTINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<SubscribedListing>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSubscribedListingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUBSCRIBEDPRINCIPALS_DESCRIPTOR.index -> builder.subscribedPrincipals =
                    deserializer.deserializeList(SUBSCRIBEDPRINCIPALS_DESCRIPTOR) {
                        val col0 = mutableListOf<SubscribedPrincipal>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSubscribedPrincipalDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                UPDATEDBY_DESCRIPTOR.index -> builder.updatedBy = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
