// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.ListNotificationsRequest
import aws.sdk.kotlin.services.datazone.model.NotificationType
import aws.sdk.kotlin.services.datazone.model.TaskStatus
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListNotificationsOperationSerializer: HttpSerializer.NonStreaming<ListNotificationsRequest> {
    override fun serialize(context: ExecutionContext, input: ListNotificationsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.domainIdentifier) { "domainIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode("${input.domainIdentifier}"))
                add(PercentEncoding.Path.encode("notifications"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.afterTimestamp != null) add("afterTimestamp", input.afterTimestamp.format(TimestampFormat.ISO_8601))
                if (input.beforeTimestamp != null) add("beforeTimestamp", input.beforeTimestamp.format(TimestampFormat.ISO_8601))
                if (input.maxResults != null) add("maxResults", "${input.maxResults}")
                if (input.nextToken != null) add("nextToken", input.nextToken)
                if (input.subjects?.isNotEmpty() == true) addAll("subjects", input.subjects)
                if (input.taskStatus != null) add("taskStatus", input.taskStatus.value)
                if (input.type != null) add("type", input.type.value)
            }
        }

        return builder
    }
}
