// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.CustomParameter
import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.GetEnvironmentProfileResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetEnvironmentProfileOperationDeserializer: HttpDeserializer.NonStreaming<GetEnvironmentProfileResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetEnvironmentProfileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetEnvironmentProfileError(context, call, payload)
        }
        val builder = GetEnvironmentProfileResponse.Builder()

        if (payload != null) {
            deserializeGetEnvironmentProfileOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetEnvironmentProfileError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEnvironmentProfileOperationBody(builder: GetEnvironmentProfileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AWSACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsAccountId"))
    val AWSACCOUNTREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsAccountRegion"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdBy"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val ENVIRONMENTBLUEPRINTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentBlueprintId"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectId"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val USERPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("userParameters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AWSACCOUNTID_DESCRIPTOR)
        field(AWSACCOUNTREGION_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(ENVIRONMENTBLUEPRINTID_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROJECTID_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
        field(USERPARAMETERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AWSACCOUNTID_DESCRIPTOR.index -> builder.awsAccountId = deserializeString()
                AWSACCOUNTREGION_DESCRIPTOR.index -> builder.awsAccountRegion = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                ENVIRONMENTBLUEPRINTID_DESCRIPTOR.index -> builder.environmentBlueprintId = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PROJECTID_DESCRIPTOR.index -> builder.projectId = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromIso8601(it) }
                USERPARAMETERS_DESCRIPTOR.index -> builder.userParameters =
                    deserializer.deserializeList(USERPARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<CustomParameter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCustomParameterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
