// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.CreateSubscriptionRequestRequest
import aws.sdk.kotlin.services.datazone.model.SubscribedListingInput
import aws.sdk.kotlin.services.datazone.model.SubscribedPrincipalInput
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateSubscriptionRequestOperationSerializer: HttpSerializer.NonStreaming<CreateSubscriptionRequestRequest> {
    override fun serialize(context: ExecutionContext, input: CreateSubscriptionRequestRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainIdentifier) { "domainIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode("${input.domainIdentifier}"))
                add(PercentEncoding.Path.encode("subscription-requests"))
            }
        }

        val payload = serializeCreateSubscriptionRequestOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateSubscriptionRequestOperationBody(context: ExecutionContext, input: CreateSubscriptionRequestRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val REQUESTREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestReason"))
    val SUBSCRIBEDLISTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subscribedListings"))
    val SUBSCRIBEDPRINCIPALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subscribedPrincipals"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(REQUESTREASON_DESCRIPTOR)
        field(SUBSCRIBEDLISTINGS_DESCRIPTOR)
        field(SUBSCRIBEDPRINCIPALS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.requestReason?.let { field(REQUESTREASON_DESCRIPTOR, it) }
        if (input.subscribedListings != null) {
            listField(SUBSCRIBEDLISTINGS_DESCRIPTOR) {
                for (el0 in input.subscribedListings) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSubscribedListingInputDocument))
                }
            }
        }
        if (input.subscribedPrincipals != null) {
            listField(SUBSCRIBEDPRINCIPALS_DESCRIPTOR) {
                for (el0 in input.subscribedPrincipals) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSubscribedPrincipalInputDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
