// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.AssetTargetNameMap
import aws.sdk.kotlin.services.datazone.model.CreateSubscriptionGrantRequest
import aws.sdk.kotlin.services.datazone.model.GrantedEntityInput
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateSubscriptionGrantOperationSerializer: HttpSerializer.NonStreaming<CreateSubscriptionGrantRequest> {
    override fun serialize(context: ExecutionContext, input: CreateSubscriptionGrantRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainIdentifier) { "domainIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode("${input.domainIdentifier}"))
                add(PercentEncoding.Path.encode("subscription-grants"))
            }
        }

        val payload = serializeCreateSubscriptionGrantOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateSubscriptionGrantOperationBody(context: ExecutionContext, input: CreateSubscriptionGrantRequest): ByteArray {
    val serializer = JsonSerializer()
    val ASSETTARGETNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetTargetNames"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val ENVIRONMENTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentIdentifier"))
    val GRANTEDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("grantedEntity"))
    val SUBSCRIPTIONTARGETIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("subscriptionTargetIdentifier"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETTARGETNAMES_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(ENVIRONMENTIDENTIFIER_DESCRIPTOR)
        field(GRANTEDENTITY_DESCRIPTOR)
        field(SUBSCRIPTIONTARGETIDENTIFIER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.assetTargetNames != null) {
            listField(ASSETTARGETNAMES_DESCRIPTOR) {
                for (el0 in input.assetTargetNames) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAssetTargetNameMapDocument))
                }
            }
        }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.environmentIdentifier?.let { field(ENVIRONMENTIDENTIFIER_DESCRIPTOR, it) }
        input.grantedEntity?.let { field(GRANTEDENTITY_DESCRIPTOR, it, ::serializeGrantedEntityInputDocument) }
        input.subscriptionTargetIdentifier?.let { field(SUBSCRIPTIONTARGETIDENTIFIER_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
