// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.AssetListingDetails
import aws.sdk.kotlin.services.datazone.model.CreateAssetResponse
import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.FormOutput
import aws.sdk.kotlin.services.datazone.model.PredictionConfiguration
import aws.sdk.kotlin.services.datazone.model.TimeSeriesDataPointSummaryFormOutput
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class CreateAssetOperationDeserializer: HttpDeserializer.NonStreaming<CreateAssetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateAssetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAssetError(context, call, payload)
        }
        val builder = CreateAssetResponse.Builder()

        if (payload != null) {
            deserializeCreateAssetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateAssetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAssetOperationBody(builder: CreateAssetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdBy"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val EXTERNALIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("externalIdentifier"))
    val FIRSTREVISIONCREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("firstRevisionCreatedAt"))
    val FIRSTREVISIONCREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("firstRevisionCreatedBy"))
    val FORMSOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("formsOutput"))
    val GLOSSARYTERMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("glossaryTerms"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LATESTTIMESERIESDATAPOINTFORMSOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("latestTimeSeriesDataPointFormsOutput"))
    val LISTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("listing"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OWNINGPROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("owningProjectId"))
    val PREDICTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("predictionConfiguration"))
    val READONLYFORMSOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("readOnlyFormsOutput"))
    val REVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("revision"))
    val TYPEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("typeIdentifier"))
    val TYPEREVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("typeRevision"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(EXTERNALIDENTIFIER_DESCRIPTOR)
        field(FIRSTREVISIONCREATEDAT_DESCRIPTOR)
        field(FIRSTREVISIONCREATEDBY_DESCRIPTOR)
        field(FORMSOUTPUT_DESCRIPTOR)
        field(GLOSSARYTERMS_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LATESTTIMESERIESDATAPOINTFORMSOUTPUT_DESCRIPTOR)
        field(LISTING_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OWNINGPROJECTID_DESCRIPTOR)
        field(PREDICTIONCONFIGURATION_DESCRIPTOR)
        field(READONLYFORMSOUTPUT_DESCRIPTOR)
        field(REVISION_DESCRIPTOR)
        field(TYPEIDENTIFIER_DESCRIPTOR)
        field(TYPEREVISION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                EXTERNALIDENTIFIER_DESCRIPTOR.index -> builder.externalIdentifier = deserializeString()
                FIRSTREVISIONCREATEDAT_DESCRIPTOR.index -> builder.firstRevisionCreatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                FIRSTREVISIONCREATEDBY_DESCRIPTOR.index -> builder.firstRevisionCreatedBy = deserializeString()
                FORMSOUTPUT_DESCRIPTOR.index -> builder.formsOutput =
                    deserializer.deserializeList(FORMSOUTPUT_DESCRIPTOR) {
                        val col0 = mutableListOf<FormOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFormOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GLOSSARYTERMS_DESCRIPTOR.index -> builder.glossaryTerms =
                    deserializer.deserializeList(GLOSSARYTERMS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LATESTTIMESERIESDATAPOINTFORMSOUTPUT_DESCRIPTOR.index -> builder.latestTimeSeriesDataPointFormsOutput =
                    deserializer.deserializeList(LATESTTIMESERIESDATAPOINTFORMSOUTPUT_DESCRIPTOR) {
                        val col0 = mutableListOf<TimeSeriesDataPointSummaryFormOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTimeSeriesDataPointSummaryFormOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LISTING_DESCRIPTOR.index -> builder.listing = deserializeAssetListingDetailsDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OWNINGPROJECTID_DESCRIPTOR.index -> builder.owningProjectId = deserializeString()
                PREDICTIONCONFIGURATION_DESCRIPTOR.index -> builder.predictionConfiguration = deserializePredictionConfigurationDocument(deserializer)
                READONLYFORMSOUTPUT_DESCRIPTOR.index -> builder.readOnlyFormsOutput =
                    deserializer.deserializeList(READONLYFORMSOUTPUT_DESCRIPTOR) {
                        val col0 = mutableListOf<FormOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFormOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REVISION_DESCRIPTOR.index -> builder.revision = deserializeString()
                TYPEIDENTIFIER_DESCRIPTOR.index -> builder.typeIdentifier = deserializeString()
                TYPEREVISION_DESCRIPTOR.index -> builder.typeRevision = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
