// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model



public class SearchRequest private constructor(builder: Builder) {
    /**
     * Specifies additional attributes for the `Search` action.
     */
    public val additionalAttributes: List<SearchOutputAdditionalAttribute>? = builder.additionalAttributes
    /**
     * The identifier of the Amazon DataZone domain.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * Specifies the search filters.
     */
    public val filters: aws.sdk.kotlin.services.datazone.model.FilterClause? = builder.filters
    /**
     * The maximum number of results to return in a single call to `Search`. When the number of results to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `Search` to list the next set of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When the number of results is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of results, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `Search` to list the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The identifier of the owning project specified for the search.
     */
    public val owningProjectIdentifier: kotlin.String? = builder.owningProjectIdentifier
    /**
     * The details of the search.
     */
    public val searchIn: List<SearchInItem>? = builder.searchIn
    /**
     * The scope of the search.
     */
    public val searchScope: aws.sdk.kotlin.services.datazone.model.InventorySearchScope? = builder.searchScope
    /**
     * Specifies the text for which to search.
     */
    public val searchText: kotlin.String? = builder.searchText
    /**
     * Specifies the way in which the search results are to be sorted.
     */
    public val sort: aws.sdk.kotlin.services.datazone.model.SearchSort? = builder.sort

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.SearchRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchRequest(")
        append("additionalAttributes=$additionalAttributes,")
        append("domainIdentifier=$domainIdentifier,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("owningProjectIdentifier=$owningProjectIdentifier,")
        append("searchIn=$searchIn,")
        append("searchScope=$searchScope,")
        append("searchText=$searchText,")
        append("sort=$sort")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAttributes?.hashCode() ?: 0
        result = 31 * result + (domainIdentifier?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (owningProjectIdentifier?.hashCode() ?: 0)
        result = 31 * result + (searchIn?.hashCode() ?: 0)
        result = 31 * result + (searchScope?.hashCode() ?: 0)
        result = 31 * result + (searchText?.hashCode() ?: 0)
        result = 31 * result + (sort?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchRequest

        if (additionalAttributes != other.additionalAttributes) return false
        if (domainIdentifier != other.domainIdentifier) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (owningProjectIdentifier != other.owningProjectIdentifier) return false
        if (searchIn != other.searchIn) return false
        if (searchScope != other.searchScope) return false
        if (searchText != other.searchText) return false
        if (sort != other.sort) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.SearchRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies additional attributes for the `Search` action.
         */
        public var additionalAttributes: List<SearchOutputAdditionalAttribute>? = null
        /**
         * The identifier of the Amazon DataZone domain.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * Specifies the search filters.
         */
        public var filters: aws.sdk.kotlin.services.datazone.model.FilterClause? = null
        /**
         * The maximum number of results to return in a single call to `Search`. When the number of results to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `Search` to list the next set of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When the number of results is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of results, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `Search` to list the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The identifier of the owning project specified for the search.
         */
        public var owningProjectIdentifier: kotlin.String? = null
        /**
         * The details of the search.
         */
        public var searchIn: List<SearchInItem>? = null
        /**
         * The scope of the search.
         */
        public var searchScope: aws.sdk.kotlin.services.datazone.model.InventorySearchScope? = null
        /**
         * Specifies the text for which to search.
         */
        public var searchText: kotlin.String? = null
        /**
         * Specifies the way in which the search results are to be sorted.
         */
        public var sort: aws.sdk.kotlin.services.datazone.model.SearchSort? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.SearchRequest) : this() {
            this.additionalAttributes = x.additionalAttributes
            this.domainIdentifier = x.domainIdentifier
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.owningProjectIdentifier = x.owningProjectIdentifier
            this.searchIn = x.searchIn
            this.searchScope = x.searchScope
            this.searchText = x.searchText
            this.sort = x.sort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.SearchRequest = SearchRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.SearchSort] inside the given [block]
         */
        public fun sort(block: aws.sdk.kotlin.services.datazone.model.SearchSort.Builder.() -> kotlin.Unit) {
            this.sort = aws.sdk.kotlin.services.datazone.model.SearchSort.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
