// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model



public class SearchGroupProfilesRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon DataZone domain in which you want to search group profiles.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The group type for which to search.
     */
    public val groupType: aws.sdk.kotlin.services.datazone.model.GroupSearchType? = builder.groupType
    /**
     * The maximum number of results to return in a single call to `SearchGroupProfiles`. When the number of results to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `SearchGroupProfiles` to list the next set of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When the number of results is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of results, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `SearchGroupProfiles` to list the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Specifies the text for which to search.
     */
    public val searchText: kotlin.String? = builder.searchText

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.SearchGroupProfilesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchGroupProfilesRequest(")
        append("domainIdentifier=$domainIdentifier,")
        append("groupType=$groupType,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("searchText=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainIdentifier?.hashCode() ?: 0
        result = 31 * result + (groupType?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (searchText?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchGroupProfilesRequest

        if (domainIdentifier != other.domainIdentifier) return false
        if (groupType != other.groupType) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (searchText != other.searchText) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.SearchGroupProfilesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the Amazon DataZone domain in which you want to search group profiles.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The group type for which to search.
         */
        public var groupType: aws.sdk.kotlin.services.datazone.model.GroupSearchType? = null
        /**
         * The maximum number of results to return in a single call to `SearchGroupProfiles`. When the number of results to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `SearchGroupProfiles` to list the next set of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When the number of results is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of results, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `SearchGroupProfiles` to list the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Specifies the text for which to search.
         */
        public var searchText: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.SearchGroupProfilesRequest) : this() {
            this.domainIdentifier = x.domainIdentifier
            this.groupType = x.groupType
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.searchText = x.searchText
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.SearchGroupProfilesRequest = SearchGroupProfilesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
