// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model



public class ListProjectsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon DataZone domain.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The identifier of a group.
     */
    public val groupIdentifier: kotlin.String? = builder.groupIdentifier
    /**
     * The maximum number of projects to return in a single call to `ListProjects`. When the number of projects to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListProjects` to list the next set of projects.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The name of the project.
     */
    public val name: kotlin.String? = builder.name
    /**
     * When the number of projects is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of projects, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListProjects` to list the next set of projects.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The identifier of the Amazon DataZone user.
     */
    public val userIdentifier: kotlin.String? = builder.userIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.ListProjectsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListProjectsRequest(")
        append("domainIdentifier=$domainIdentifier,")
        append("groupIdentifier=$groupIdentifier,")
        append("maxResults=$maxResults,")
        append("name=*** Sensitive Data Redacted ***,")
        append("nextToken=$nextToken,")
        append("userIdentifier=$userIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainIdentifier?.hashCode() ?: 0
        result = 31 * result + (groupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (userIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListProjectsRequest

        if (domainIdentifier != other.domainIdentifier) return false
        if (groupIdentifier != other.groupIdentifier) return false
        if (maxResults != other.maxResults) return false
        if (name != other.name) return false
        if (nextToken != other.nextToken) return false
        if (userIdentifier != other.userIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.ListProjectsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the Amazon DataZone domain.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The identifier of a group.
         */
        public var groupIdentifier: kotlin.String? = null
        /**
         * The maximum number of projects to return in a single call to `ListProjects`. When the number of projects to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListProjects` to list the next set of projects.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The name of the project.
         */
        public var name: kotlin.String? = null
        /**
         * When the number of projects is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of projects, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListProjects` to list the next set of projects.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone user.
         */
        public var userIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.ListProjectsRequest) : this() {
            this.domainIdentifier = x.domainIdentifier
            this.groupIdentifier = x.groupIdentifier
            this.maxResults = x.maxResults
            this.name = x.name
            this.nextToken = x.nextToken
            this.userIdentifier = x.userIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.ListProjectsRequest = ListProjectsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
