// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model



public class ListMetadataGenerationRunsRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon DataZone domain where you want to list metadata generation runs.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The maximum number of metadata generation runs to return in a single call to ListMetadataGenerationRuns. When the number of metadata generation runs to be listed is greater than the value of MaxResults, the response contains a NextToken value that you can use in a subsequent call to ListMetadataGenerationRuns to list the next set of revisions.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When the number of metadata generation runs is greater than the default value for the MaxResults parameter, or if you explicitly specify a value for MaxResults that is less than the number of metadata generation runs, the response includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to ListMetadataGenerationRuns to list the next set of revisions.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The status of the metadata generation runs.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.MetadataGenerationRunStatus? = builder.status
    /**
     * The type of the metadata generation runs.
     */
    public val type: aws.sdk.kotlin.services.datazone.model.MetadataGenerationRunType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.ListMetadataGenerationRunsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListMetadataGenerationRunsRequest(")
        append("domainIdentifier=$domainIdentifier,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("status=$status,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainIdentifier?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListMetadataGenerationRunsRequest

        if (domainIdentifier != other.domainIdentifier) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.ListMetadataGenerationRunsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon DataZone domain where you want to list metadata generation runs.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The maximum number of metadata generation runs to return in a single call to ListMetadataGenerationRuns. When the number of metadata generation runs to be listed is greater than the value of MaxResults, the response contains a NextToken value that you can use in a subsequent call to ListMetadataGenerationRuns to list the next set of revisions.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When the number of metadata generation runs is greater than the default value for the MaxResults parameter, or if you explicitly specify a value for MaxResults that is less than the number of metadata generation runs, the response includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to ListMetadataGenerationRuns to list the next set of revisions.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The status of the metadata generation runs.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.MetadataGenerationRunStatus? = null
        /**
         * The type of the metadata generation runs.
         */
        public var type: aws.sdk.kotlin.services.datazone.model.MetadataGenerationRunType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.ListMetadataGenerationRunsRequest) : this() {
            this.domainIdentifier = x.domainIdentifier
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.ListMetadataGenerationRunsRequest = ListMetadataGenerationRunsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
