// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model



public class ListDataSourceRunsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the data source.
     */
    public val dataSourceIdentifier: kotlin.String? = builder.dataSourceIdentifier
    /**
     * The identifier of the Amazon DataZone domain in which to invoke the `ListDataSourceRuns` action.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The maximum number of runs to return in a single call to `ListDataSourceRuns`. When the number of runs to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListDataSourceRuns` to list the next set of runs.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When the number of runs is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of runs, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListDataSourceRuns` to list the next set of runs.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The status of the data source.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.DataSourceRunStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.ListDataSourceRunsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDataSourceRunsRequest(")
        append("dataSourceIdentifier=$dataSourceIdentifier,")
        append("domainIdentifier=$domainIdentifier,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceIdentifier?.hashCode() ?: 0
        result = 31 * result + (domainIdentifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDataSourceRunsRequest

        if (dataSourceIdentifier != other.dataSourceIdentifier) return false
        if (domainIdentifier != other.domainIdentifier) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.ListDataSourceRunsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the data source.
         */
        public var dataSourceIdentifier: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain in which to invoke the `ListDataSourceRuns` action.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The maximum number of runs to return in a single call to `ListDataSourceRuns`. When the number of runs to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListDataSourceRuns` to list the next set of runs.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When the number of runs is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of runs, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListDataSourceRuns` to list the next set of runs.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The status of the data source.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.DataSourceRunStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.ListDataSourceRunsRequest) : this() {
            this.dataSourceIdentifier = x.dataSourceIdentifier
            this.domainIdentifier = x.domainIdentifier
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.ListDataSourceRunsRequest = ListDataSourceRunsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
