// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateAssetResponse private constructor(builder: Builder) {
    /**
     * The timestamp of when the asset was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon DataZone user that created this asset in the catalog.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The description of the created asset.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the Amazon DataZone domain in which the asset was created.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The external identifier of the asset.
     */
    public val externalIdentifier: kotlin.String? = builder.externalIdentifier
    /**
     * The timestamp of when the first revision of the asset took place.
     */
    public val firstRevisionCreatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.firstRevisionCreatedAt
    /**
     * The Amazon DataZone user that made the first revision of the asset.
     */
    public val firstRevisionCreatedBy: kotlin.String? = builder.firstRevisionCreatedBy
    /**
     * The metadata forms that are attached to the created asset.
     */
    public val formsOutput: List<FormOutput> = requireNotNull(builder.formsOutput) { "A non-null value must be provided for formsOutput" }
    /**
     * The glossary terms that are attached to the created asset.
     */
    public val glossaryTerms: List<String>? = builder.glossaryTerms
    /**
     * The unique identifier of the created asset.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The latest data point that was imported into the time series form for the asset.
     */
    public val latestTimeSeriesDataPointFormsOutput: List<TimeSeriesDataPointSummaryFormOutput>? = builder.latestTimeSeriesDataPointFormsOutput
    /**
     * The details of an asset published in an Amazon DataZone catalog.
     */
    public val listing: aws.sdk.kotlin.services.datazone.model.AssetListingDetails? = builder.listing
    /**
     * The name of the created asset.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The ID of the Amazon DataZone project that owns the created asset.
     */
    public val owningProjectId: kotlin.String = requireNotNull(builder.owningProjectId) { "A non-null value must be provided for owningProjectId" }
    /**
     * The configuration of the automatically generated business-friendly metadata for the asset.
     */
    public val predictionConfiguration: aws.sdk.kotlin.services.datazone.model.PredictionConfiguration? = builder.predictionConfiguration
    /**
     * The read-only metadata forms that are attached to the created asset.
     */
    public val readOnlyFormsOutput: List<FormOutput>? = builder.readOnlyFormsOutput
    /**
     * The revision of the asset.
     */
    public val revision: kotlin.String = requireNotNull(builder.revision) { "A non-null value must be provided for revision" }
    /**
     * The identifier of the created asset type.
     */
    public val typeIdentifier: kotlin.String = requireNotNull(builder.typeIdentifier) { "A non-null value must be provided for typeIdentifier" }
    /**
     * The revision type of the asset.
     */
    public val typeRevision: kotlin.String = requireNotNull(builder.typeRevision) { "A non-null value must be provided for typeRevision" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.CreateAssetResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAssetResponse(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=*** Sensitive Data Redacted ***,")
        append("domainId=$domainId,")
        append("externalIdentifier=*** Sensitive Data Redacted ***,")
        append("firstRevisionCreatedAt=$firstRevisionCreatedAt,")
        append("firstRevisionCreatedBy=$firstRevisionCreatedBy,")
        append("formsOutput=$formsOutput,")
        append("glossaryTerms=$glossaryTerms,")
        append("id=$id,")
        append("latestTimeSeriesDataPointFormsOutput=$latestTimeSeriesDataPointFormsOutput,")
        append("listing=$listing,")
        append("name=*** Sensitive Data Redacted ***,")
        append("owningProjectId=$owningProjectId,")
        append("predictionConfiguration=$predictionConfiguration,")
        append("readOnlyFormsOutput=$readOnlyFormsOutput,")
        append("revision=$revision,")
        append("typeIdentifier=$typeIdentifier,")
        append("typeRevision=$typeRevision")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (externalIdentifier?.hashCode() ?: 0)
        result = 31 * result + (firstRevisionCreatedAt?.hashCode() ?: 0)
        result = 31 * result + (firstRevisionCreatedBy?.hashCode() ?: 0)
        result = 31 * result + (formsOutput.hashCode())
        result = 31 * result + (glossaryTerms?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (latestTimeSeriesDataPointFormsOutput?.hashCode() ?: 0)
        result = 31 * result + (listing?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (owningProjectId.hashCode())
        result = 31 * result + (predictionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (readOnlyFormsOutput?.hashCode() ?: 0)
        result = 31 * result + (revision.hashCode())
        result = 31 * result + (typeIdentifier.hashCode())
        result = 31 * result + (typeRevision.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAssetResponse

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (domainId != other.domainId) return false
        if (externalIdentifier != other.externalIdentifier) return false
        if (firstRevisionCreatedAt != other.firstRevisionCreatedAt) return false
        if (firstRevisionCreatedBy != other.firstRevisionCreatedBy) return false
        if (formsOutput != other.formsOutput) return false
        if (glossaryTerms != other.glossaryTerms) return false
        if (id != other.id) return false
        if (latestTimeSeriesDataPointFormsOutput != other.latestTimeSeriesDataPointFormsOutput) return false
        if (listing != other.listing) return false
        if (name != other.name) return false
        if (owningProjectId != other.owningProjectId) return false
        if (predictionConfiguration != other.predictionConfiguration) return false
        if (readOnlyFormsOutput != other.readOnlyFormsOutput) return false
        if (revision != other.revision) return false
        if (typeIdentifier != other.typeIdentifier) return false
        if (typeRevision != other.typeRevision) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.CreateAssetResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp of when the asset was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user that created this asset in the catalog.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The description of the created asset.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone domain in which the asset was created.
         */
        public var domainId: kotlin.String? = null
        /**
         * The external identifier of the asset.
         */
        public var externalIdentifier: kotlin.String? = null
        /**
         * The timestamp of when the first revision of the asset took place.
         */
        public var firstRevisionCreatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user that made the first revision of the asset.
         */
        public var firstRevisionCreatedBy: kotlin.String? = null
        /**
         * The metadata forms that are attached to the created asset.
         */
        public var formsOutput: List<FormOutput>? = null
        /**
         * The glossary terms that are attached to the created asset.
         */
        public var glossaryTerms: List<String>? = null
        /**
         * The unique identifier of the created asset.
         */
        public var id: kotlin.String? = null
        /**
         * The latest data point that was imported into the time series form for the asset.
         */
        public var latestTimeSeriesDataPointFormsOutput: List<TimeSeriesDataPointSummaryFormOutput>? = null
        /**
         * The details of an asset published in an Amazon DataZone catalog.
         */
        public var listing: aws.sdk.kotlin.services.datazone.model.AssetListingDetails? = null
        /**
         * The name of the created asset.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone project that owns the created asset.
         */
        public var owningProjectId: kotlin.String? = null
        /**
         * The configuration of the automatically generated business-friendly metadata for the asset.
         */
        public var predictionConfiguration: aws.sdk.kotlin.services.datazone.model.PredictionConfiguration? = null
        /**
         * The read-only metadata forms that are attached to the created asset.
         */
        public var readOnlyFormsOutput: List<FormOutput>? = null
        /**
         * The revision of the asset.
         */
        public var revision: kotlin.String? = null
        /**
         * The identifier of the created asset type.
         */
        public var typeIdentifier: kotlin.String? = null
        /**
         * The revision type of the asset.
         */
        public var typeRevision: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.CreateAssetResponse) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.domainId = x.domainId
            this.externalIdentifier = x.externalIdentifier
            this.firstRevisionCreatedAt = x.firstRevisionCreatedAt
            this.firstRevisionCreatedBy = x.firstRevisionCreatedBy
            this.formsOutput = x.formsOutput
            this.glossaryTerms = x.glossaryTerms
            this.id = x.id
            this.latestTimeSeriesDataPointFormsOutput = x.latestTimeSeriesDataPointFormsOutput
            this.listing = x.listing
            this.name = x.name
            this.owningProjectId = x.owningProjectId
            this.predictionConfiguration = x.predictionConfiguration
            this.readOnlyFormsOutput = x.readOnlyFormsOutput
            this.revision = x.revision
            this.typeIdentifier = x.typeIdentifier
            this.typeRevision = x.typeRevision
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.CreateAssetResponse = CreateAssetResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.AssetListingDetails] inside the given [block]
         */
        public fun listing(block: aws.sdk.kotlin.services.datazone.model.AssetListingDetails.Builder.() -> kotlin.Unit) {
            this.listing = aws.sdk.kotlin.services.datazone.model.AssetListingDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.PredictionConfiguration] inside the given [block]
         */
        public fun predictionConfiguration(block: aws.sdk.kotlin.services.datazone.model.PredictionConfiguration.Builder.() -> kotlin.Unit) {
            this.predictionConfiguration = aws.sdk.kotlin.services.datazone.model.PredictionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (domainId == null) domainId = ""
            if (formsOutput == null) formsOutput = emptyList()
            if (id == null) id = ""
            if (name == null) name = ""
            if (owningProjectId == null) owningProjectId = ""
            if (revision == null) revision = ""
            if (typeIdentifier == null) typeIdentifier = ""
            if (typeRevision == null) typeRevision = ""
            return this
        }
    }
}
