// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of an asset published in an Amazon DataZone catalog.
 */
public class AssetListingItem private constructor(builder: Builder) {
    /**
     * The additional attributes of an asset published in an Amazon DataZone catalog.
     */
    public val additionalAttributes: aws.sdk.kotlin.services.datazone.model.AssetListingItemAdditionalAttributes? = builder.additionalAttributes
    /**
     * The timestamp of when an asset published in an Amazon DataZone catalog was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The description of an asset published in an Amazon DataZone catalog.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the inventory asset.
     */
    public val entityId: kotlin.String? = builder.entityId
    /**
     * The revision of the inventory asset.
     */
    public val entityRevision: kotlin.String? = builder.entityRevision
    /**
     * The type of the inventory asset.
     */
    public val entityType: kotlin.String? = builder.entityType
    /**
     * Glossary terms attached to the inventory asset.
     */
    public val glossaryTerms: List<DetailedGlossaryTerm>? = builder.glossaryTerms
    /**
     * The Amazon DataZone user who created the listing.
     */
    public val listingCreatedBy: kotlin.String? = builder.listingCreatedBy
    /**
     * The identifier of the listing (asset published in Amazon DataZone catalog).
     */
    public val listingId: kotlin.String? = builder.listingId
    /**
     * The revision of the listing (asset published in Amazon DataZone catalog).
     */
    public val listingRevision: kotlin.String? = builder.listingRevision
    /**
     * The Amazon DataZone user who updated the listing.
     */
    public val listingUpdatedBy: kotlin.String? = builder.listingUpdatedBy
    /**
     * The name of the inventory asset.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The identifier of the project that owns the inventory asset.
     */
    public val owningProjectId: kotlin.String? = builder.owningProjectId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.AssetListingItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetListingItem(")
        append("additionalAttributes=$additionalAttributes,")
        append("createdAt=$createdAt,")
        append("description=*** Sensitive Data Redacted ***,")
        append("entityId=$entityId,")
        append("entityRevision=$entityRevision,")
        append("entityType=$entityType,")
        append("glossaryTerms=$glossaryTerms,")
        append("listingCreatedBy=$listingCreatedBy,")
        append("listingId=$listingId,")
        append("listingRevision=$listingRevision,")
        append("listingUpdatedBy=$listingUpdatedBy,")
        append("name=*** Sensitive Data Redacted ***,")
        append("owningProjectId=$owningProjectId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAttributes?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (entityId?.hashCode() ?: 0)
        result = 31 * result + (entityRevision?.hashCode() ?: 0)
        result = 31 * result + (entityType?.hashCode() ?: 0)
        result = 31 * result + (glossaryTerms?.hashCode() ?: 0)
        result = 31 * result + (listingCreatedBy?.hashCode() ?: 0)
        result = 31 * result + (listingId?.hashCode() ?: 0)
        result = 31 * result + (listingRevision?.hashCode() ?: 0)
        result = 31 * result + (listingUpdatedBy?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owningProjectId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetListingItem

        if (additionalAttributes != other.additionalAttributes) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (entityId != other.entityId) return false
        if (entityRevision != other.entityRevision) return false
        if (entityType != other.entityType) return false
        if (glossaryTerms != other.glossaryTerms) return false
        if (listingCreatedBy != other.listingCreatedBy) return false
        if (listingId != other.listingId) return false
        if (listingRevision != other.listingRevision) return false
        if (listingUpdatedBy != other.listingUpdatedBy) return false
        if (name != other.name) return false
        if (owningProjectId != other.owningProjectId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.AssetListingItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The additional attributes of an asset published in an Amazon DataZone catalog.
         */
        public var additionalAttributes: aws.sdk.kotlin.services.datazone.model.AssetListingItemAdditionalAttributes? = null
        /**
         * The timestamp of when an asset published in an Amazon DataZone catalog was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of an asset published in an Amazon DataZone catalog.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the inventory asset.
         */
        public var entityId: kotlin.String? = null
        /**
         * The revision of the inventory asset.
         */
        public var entityRevision: kotlin.String? = null
        /**
         * The type of the inventory asset.
         */
        public var entityType: kotlin.String? = null
        /**
         * Glossary terms attached to the inventory asset.
         */
        public var glossaryTerms: List<DetailedGlossaryTerm>? = null
        /**
         * The Amazon DataZone user who created the listing.
         */
        public var listingCreatedBy: kotlin.String? = null
        /**
         * The identifier of the listing (asset published in Amazon DataZone catalog).
         */
        public var listingId: kotlin.String? = null
        /**
         * The revision of the listing (asset published in Amazon DataZone catalog).
         */
        public var listingRevision: kotlin.String? = null
        /**
         * The Amazon DataZone user who updated the listing.
         */
        public var listingUpdatedBy: kotlin.String? = null
        /**
         * The name of the inventory asset.
         */
        public var name: kotlin.String? = null
        /**
         * The identifier of the project that owns the inventory asset.
         */
        public var owningProjectId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.AssetListingItem) : this() {
            this.additionalAttributes = x.additionalAttributes
            this.createdAt = x.createdAt
            this.description = x.description
            this.entityId = x.entityId
            this.entityRevision = x.entityRevision
            this.entityType = x.entityType
            this.glossaryTerms = x.glossaryTerms
            this.listingCreatedBy = x.listingCreatedBy
            this.listingId = x.listingId
            this.listingRevision = x.listingRevision
            this.listingUpdatedBy = x.listingUpdatedBy
            this.name = x.name
            this.owningProjectId = x.owningProjectId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.AssetListingItem = AssetListingItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.AssetListingItemAdditionalAttributes] inside the given [block]
         */
        public fun additionalAttributes(block: aws.sdk.kotlin.services.datazone.model.AssetListingItemAdditionalAttributes.Builder.() -> kotlin.Unit) {
            this.additionalAttributes = aws.sdk.kotlin.services.datazone.model.AssetListingItemAdditionalAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
