// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.FilterClause
import aws.sdk.kotlin.services.datazone.model.InventorySearchScope
import aws.sdk.kotlin.services.datazone.model.SearchInItem
import aws.sdk.kotlin.services.datazone.model.SearchOutputAdditionalAttribute
import aws.sdk.kotlin.services.datazone.model.SearchRequest
import aws.sdk.kotlin.services.datazone.model.SearchSort
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SearchOperationSerializer: HttpSerialize<SearchRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SearchRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainIdentifier) { "domainIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode("${input.domainIdentifier}"))
                add(PercentEncoding.Path.encode("search"))
            }
        }

        val payload = serializeSearchOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSearchOperationBody(context: ExecutionContext, input: SearchRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDITIONALATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("additionalAttributes"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("filters"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OWNINGPROJECTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("owningProjectIdentifier"))
    val SEARCHIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("searchIn"))
    val SEARCHSCOPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("searchScope"))
    val SEARCHTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("searchText"))
    val SORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sort"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALATTRIBUTES_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(OWNINGPROJECTIDENTIFIER_DESCRIPTOR)
        field(SEARCHIN_DESCRIPTOR)
        field(SEARCHSCOPE_DESCRIPTOR)
        field(SEARCHTEXT_DESCRIPTOR)
        field(SORT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.additionalAttributes != null) {
            listField(ADDITIONALATTRIBUTES_DESCRIPTOR) {
                for (el0 in input.additionalAttributes) {
                    serializeString(el0.value)
                }
            }
        }
        input.filters?.let { field(FILTERS_DESCRIPTOR, it, ::serializeFilterClauseDocument) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.owningProjectIdentifier?.let { field(OWNINGPROJECTIDENTIFIER_DESCRIPTOR, it) }
        if (input.searchIn != null) {
            listField(SEARCHIN_DESCRIPTOR) {
                for (el0 in input.searchIn) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSearchInItemDocument))
                }
            }
        }
        input.searchScope?.let { field(SEARCHSCOPE_DESCRIPTOR, it.value) }
        input.searchText?.let { field(SEARCHTEXT_DESCRIPTOR, it) }
        input.sort?.let { field(SORT_DESCRIPTOR, it, ::serializeSearchSortDocument) }
    }
    return serializer.toByteArray()
}
