// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.GetSubscriptionResponse
import aws.sdk.kotlin.services.datazone.model.SubscribedListing
import aws.sdk.kotlin.services.datazone.model.SubscribedPrincipal
import aws.sdk.kotlin.services.datazone.model.SubscriptionStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetSubscriptionOperationDeserializer: HttpDeserialize<GetSubscriptionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetSubscriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSubscriptionError(context, call)
        }
        val builder = GetSubscriptionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSubscriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetSubscriptionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSubscriptionOperationBody(builder: GetSubscriptionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdBy"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val RETAINPERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("retainPermissions"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val SUBSCRIBEDLISTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("subscribedListing"))
    val SUBSCRIBEDPRINCIPAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("subscribedPrincipal"))
    val SUBSCRIPTIONREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("subscriptionRequestId"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val UPDATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("updatedBy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(RETAINPERMISSIONS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUBSCRIBEDLISTING_DESCRIPTOR)
        field(SUBSCRIBEDPRINCIPAL_DESCRIPTOR)
        field(SUBSCRIPTIONREQUESTID_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
        field(UPDATEDBY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                RETAINPERMISSIONS_DESCRIPTOR.index -> builder.retainPermissions = deserializeBoolean()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SubscriptionStatus.fromValue(it) }
                SUBSCRIBEDLISTING_DESCRIPTOR.index -> builder.subscribedListing = deserializeSubscribedListingDocument(deserializer)
                SUBSCRIBEDPRINCIPAL_DESCRIPTOR.index -> builder.subscribedPrincipal = deserializeSubscribedPrincipalDocument(deserializer)
                SUBSCRIPTIONREQUESTID_DESCRIPTOR.index -> builder.subscriptionRequestId = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                UPDATEDBY_DESCRIPTOR.index -> builder.updatedBy = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
