// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.ChangeAction
import aws.sdk.kotlin.services.datazone.model.CreateListingChangeSetRequest
import aws.sdk.kotlin.services.datazone.model.EntityType
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateListingChangeSetOperationSerializer: HttpSerialize<CreateListingChangeSetRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateListingChangeSetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainIdentifier) { "domainIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode("${input.domainIdentifier}"))
                add(PercentEncoding.Path.encode("listings"))
                add(PercentEncoding.Path.encode("change-set"))
            }
        }

        val payload = serializeCreateListingChangeSetOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateListingChangeSetOperationBody(context: ExecutionContext, input: CreateListingChangeSetRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("action"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val ENTITYIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entityIdentifier"))
    val ENTITYREVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entityRevision"))
    val ENTITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("entityType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTION_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(ENTITYIDENTIFIER_DESCRIPTOR)
        field(ENTITYREVISION_DESCRIPTOR)
        field(ENTITYTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.action?.let { field(ACTION_DESCRIPTOR, it.value) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.entityIdentifier?.let { field(ENTITYIDENTIFIER_DESCRIPTOR, it) }
        input.entityRevision?.let { field(ENTITYREVISION_DESCRIPTOR, it) }
        input.entityType?.let { field(ENTITYTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
