// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.datazone.model.DataSourceConfigurationInput
import aws.sdk.kotlin.services.datazone.model.EnableSetting
import aws.sdk.kotlin.services.datazone.model.FormInput
import aws.sdk.kotlin.services.datazone.model.RecommendationConfiguration
import aws.sdk.kotlin.services.datazone.model.ScheduleConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateDataSourceOperationSerializer: HttpSerialize<CreateDataSourceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateDataSourceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainIdentifier) { "domainIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode("${input.domainIdentifier}"))
                add(PercentEncoding.Path.encode("data-sources"))
            }
        }

        val payload = serializeCreateDataSourceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDataSourceOperationBody(context: ExecutionContext, input: CreateDataSourceRequest): ByteArray {
    val serializer = JsonSerializer()
    val ASSETFORMSINPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetFormsInput"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configuration"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENABLESETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("enableSetting"))
    val ENVIRONMENTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentIdentifier"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PROJECTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectIdentifier"))
    val PUBLISHONIMPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("publishOnImport"))
    val RECOMMENDATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("recommendation"))
    val SCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("schedule"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETFORMSINPUT_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONFIGURATION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENABLESETTING_DESCRIPTOR)
        field(ENVIRONMENTIDENTIFIER_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROJECTIDENTIFIER_DESCRIPTOR)
        field(PUBLISHONIMPORT_DESCRIPTOR)
        field(RECOMMENDATION_DESCRIPTOR)
        field(SCHEDULE_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.assetFormsInput != null) {
            listField(ASSETFORMSINPUT_DESCRIPTOR) {
                for (el0 in input.assetFormsInput) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeFormInputDocument))
                }
            }
        }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.configuration?.let { field(CONFIGURATION_DESCRIPTOR, it, ::serializeDataSourceConfigurationInputDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.enableSetting?.let { field(ENABLESETTING_DESCRIPTOR, it.value) }
        input.environmentIdentifier?.let { field(ENVIRONMENTIDENTIFIER_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.projectIdentifier?.let { field(PROJECTIDENTIFIER_DESCRIPTOR, it) }
        input.publishOnImport?.let { field(PUBLISHONIMPORT_DESCRIPTOR, it) }
        input.recommendation?.let { field(RECOMMENDATION_DESCRIPTOR, it, ::serializeRecommendationConfigurationDocument) }
        input.schedule?.let { field(SCHEDULE_DESCRIPTOR, it, ::serializeScheduleConfigurationDocument) }
        input.type?.let { field(TYPE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
