// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model



public class SearchTypesRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon DataZone domain in which to invoke the `SearchTypes` action.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The filters for the `SearchTypes` action.
     */
    public val filters: aws.sdk.kotlin.services.datazone.model.FilterClause? = builder.filters
    /**
     *
     */
    public val managed: kotlin.Boolean? = builder.managed
    /**
     * The maximum number of results to return in a single call to `SearchTypes`. When the number of results to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `SearchTypes` to list the next set of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When the number of results is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of results, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `SearchTypes` to list the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     *
     */
    public val searchIn: List<SearchInItem>? = builder.searchIn
    /**
     * Specifies the scope of the search for types.
     */
    public val searchScope: aws.sdk.kotlin.services.datazone.model.TypesSearchScope? = builder.searchScope
    /**
     * Specifies the text for which to search.
     */
    public val searchText: kotlin.String? = builder.searchText
    /**
     * The specifies the way to sort the `SearchTypes` results.
     */
    public val sort: aws.sdk.kotlin.services.datazone.model.SearchSort? = builder.sort

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.SearchTypesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchTypesRequest(")
        append("domainIdentifier=$domainIdentifier,")
        append("filters=$filters,")
        append("managed=$managed,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("searchIn=$searchIn,")
        append("searchScope=$searchScope,")
        append("searchText=$searchText,")
        append("sort=$sort")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainIdentifier?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (managed?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (searchIn?.hashCode() ?: 0)
        result = 31 * result + (searchScope?.hashCode() ?: 0)
        result = 31 * result + (searchText?.hashCode() ?: 0)
        result = 31 * result + (sort?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchTypesRequest

        if (domainIdentifier != other.domainIdentifier) return false
        if (filters != other.filters) return false
        if (managed != other.managed) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (searchIn != other.searchIn) return false
        if (searchScope != other.searchScope) return false
        if (searchText != other.searchText) return false
        if (sort != other.sort) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.SearchTypesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the Amazon DataZone domain in which to invoke the `SearchTypes` action.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The filters for the `SearchTypes` action.
         */
        public var filters: aws.sdk.kotlin.services.datazone.model.FilterClause? = null
        /**
         *
         */
        public var managed: kotlin.Boolean? = null
        /**
         * The maximum number of results to return in a single call to `SearchTypes`. When the number of results to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `SearchTypes` to list the next set of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When the number of results is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of results, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `SearchTypes` to list the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         *
         */
        public var searchIn: List<SearchInItem>? = null
        /**
         * Specifies the scope of the search for types.
         */
        public var searchScope: aws.sdk.kotlin.services.datazone.model.TypesSearchScope? = null
        /**
         * Specifies the text for which to search.
         */
        public var searchText: kotlin.String? = null
        /**
         * The specifies the way to sort the `SearchTypes` results.
         */
        public var sort: aws.sdk.kotlin.services.datazone.model.SearchSort? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.SearchTypesRequest) : this() {
            this.domainIdentifier = x.domainIdentifier
            this.filters = x.filters
            this.managed = x.managed
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.searchIn = x.searchIn
            this.searchScope = x.searchScope
            this.searchText = x.searchText
            this.sort = x.sort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.SearchTypesRequest = SearchTypesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.SearchSort] inside the given [block]
         */
        public fun sort(block: aws.sdk.kotlin.services.datazone.model.SearchSort.Builder.() -> kotlin.Unit) {
            this.sort = aws.sdk.kotlin.services.datazone.model.SearchSort.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
