// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of an environment profile.
 */
public class EnvironmentProfileSummary private constructor(builder: Builder) {
    /**
     * The identifier of an Amazon Web Services account in which an environment profile exists.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The Amazon Web Services Region in which an environment profile exists.
     */
    public val awsAccountRegion: kotlin.String? = builder.awsAccountRegion
    /**
     * The timestamp of when an environment profile was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon DataZone user who created the environment profile.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The description of the environment profile.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon DataZone domain in which the environment profile exists.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The identifier of a blueprint with which an environment profile is created.
     */
    public val environmentBlueprintId: kotlin.String = requireNotNull(builder.environmentBlueprintId) { "A non-null value must be provided for environmentBlueprintId" }
    /**
     * The identifier of the environment profile.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The name of the environment profile.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The identifier of a project in which an environment profile exists.
     */
    public val projectId: kotlin.String? = builder.projectId
    /**
     * The timestamp of when the environment profile was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.EnvironmentProfileSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentProfileSummary(")
        append("awsAccountId=$awsAccountId,")
        append("awsAccountRegion=$awsAccountRegion,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=*** Sensitive Data Redacted ***,")
        append("domainId=$domainId,")
        append("environmentBlueprintId=$environmentBlueprintId,")
        append("id=$id,")
        append("name=*** Sensitive Data Redacted ***,")
        append("projectId=$projectId,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (awsAccountRegion?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (environmentBlueprintId.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (projectId?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentProfileSummary

        if (awsAccountId != other.awsAccountId) return false
        if (awsAccountRegion != other.awsAccountRegion) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (domainId != other.domainId) return false
        if (environmentBlueprintId != other.environmentBlueprintId) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (projectId != other.projectId) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.EnvironmentProfileSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of an Amazon Web Services account in which an environment profile exists.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The Amazon Web Services Region in which an environment profile exists.
         */
        public var awsAccountRegion: kotlin.String? = null
        /**
         * The timestamp of when an environment profile was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who created the environment profile.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The description of the environment profile.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain in which the environment profile exists.
         */
        public var domainId: kotlin.String? = null
        /**
         * The identifier of a blueprint with which an environment profile is created.
         */
        public var environmentBlueprintId: kotlin.String? = null
        /**
         * The identifier of the environment profile.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the environment profile.
         */
        public var name: kotlin.String? = null
        /**
         * The identifier of a project in which an environment profile exists.
         */
        public var projectId: kotlin.String? = null
        /**
         * The timestamp of when the environment profile was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.EnvironmentProfileSummary) : this() {
            this.awsAccountId = x.awsAccountId
            this.awsAccountRegion = x.awsAccountRegion
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.domainId = x.domainId
            this.environmentBlueprintId = x.environmentBlueprintId
            this.id = x.id
            this.name = x.name
            this.projectId = x.projectId
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.EnvironmentProfileSummary = EnvironmentProfileSummary(this)

        internal fun correctErrors(): Builder {
            if (createdBy == null) createdBy = ""
            if (domainId == null) domainId = ""
            if (environmentBlueprintId == null) environmentBlueprintId = ""
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
