// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An asset published in an Amazon DataZone catalog.
 */
public class AssetListing private constructor(builder: Builder) {
    /**
     * The identifier of an asset published in an Amazon DataZone catalog.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * The revision of an asset published in an Amazon DataZone catalog.
     */
    public val assetRevision: kotlin.String? = builder.assetRevision
    /**
     * The type of an asset published in an Amazon DataZone catalog.
     */
    public val assetType: kotlin.String? = builder.assetType
    /**
     * The timestamp of when an asset published in an Amazon DataZone catalog was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The metadata forms attached to an asset published in an Amazon DataZone catalog.
     */
    public val forms: kotlin.String? = builder.forms
    /**
     * The glossary terms attached to an asset published in an Amazon DataZone catalog.
     */
    public val glossaryTerms: List<DetailedGlossaryTerm>? = builder.glossaryTerms
    /**
     * The identifier of the project where an asset published in an Amazon DataZone catalog exists.
     */
    public val owningProjectId: kotlin.String? = builder.owningProjectId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.AssetListing = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetListing(")
        append("assetId=$assetId,")
        append("assetRevision=$assetRevision,")
        append("assetType=$assetType,")
        append("createdAt=$createdAt,")
        append("forms=$forms,")
        append("glossaryTerms=$glossaryTerms,")
        append("owningProjectId=$owningProjectId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (assetRevision?.hashCode() ?: 0)
        result = 31 * result + (assetType?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (forms?.hashCode() ?: 0)
        result = 31 * result + (glossaryTerms?.hashCode() ?: 0)
        result = 31 * result + (owningProjectId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetListing

        if (assetId != other.assetId) return false
        if (assetRevision != other.assetRevision) return false
        if (assetType != other.assetType) return false
        if (createdAt != other.createdAt) return false
        if (forms != other.forms) return false
        if (glossaryTerms != other.glossaryTerms) return false
        if (owningProjectId != other.owningProjectId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.AssetListing = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of an asset published in an Amazon DataZone catalog.
         */
        public var assetId: kotlin.String? = null
        /**
         * The revision of an asset published in an Amazon DataZone catalog.
         */
        public var assetRevision: kotlin.String? = null
        /**
         * The type of an asset published in an Amazon DataZone catalog.
         */
        public var assetType: kotlin.String? = null
        /**
         * The timestamp of when an asset published in an Amazon DataZone catalog was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The metadata forms attached to an asset published in an Amazon DataZone catalog.
         */
        public var forms: kotlin.String? = null
        /**
         * The glossary terms attached to an asset published in an Amazon DataZone catalog.
         */
        public var glossaryTerms: List<DetailedGlossaryTerm>? = null
        /**
         * The identifier of the project where an asset published in an Amazon DataZone catalog exists.
         */
        public var owningProjectId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.AssetListing) : this() {
            this.assetId = x.assetId
            this.assetRevision = x.assetRevision
            this.assetType = x.assetType
            this.createdAt = x.createdAt
            this.forms = x.forms
            this.glossaryTerms = x.glossaryTerms
            this.owningProjectId = x.owningProjectId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.AssetListing = AssetListing(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
