// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.datazone.auth.DataZoneAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.datazone.auth.DataZoneIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.datazone.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.datazone.model.*
import aws.sdk.kotlin.services.datazone.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext


public const val ServiceApiVersion: String = "2018-05-10"

internal class DefaultDataZoneClient(override val config: DataZoneClient.Config) : DataZoneClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = DataZoneIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "datazone")
        }
        toMap()
    }
    private val authSchemeAdapter = DataZoneAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.datazone"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Accepts automatically generated business-friendly metadata for your Amazon DataZone assets.
     */
    override suspend fun acceptPredictions(input: AcceptPredictionsRequest): AcceptPredictionsResponse {
        val op = SdkHttpOperation.build<AcceptPredictionsRequest, AcceptPredictionsResponse> {
            serializer = AcceptPredictionsOperationSerializer()
            deserializer = AcceptPredictionsOperationDeserializer()
            operationName = "AcceptPredictions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Accepts a subscription request to a specific asset.
     */
    override suspend fun acceptSubscriptionRequest(input: AcceptSubscriptionRequestRequest): AcceptSubscriptionRequestResponse {
        val op = SdkHttpOperation.build<AcceptSubscriptionRequestRequest, AcceptSubscriptionRequestResponse> {
            serializer = AcceptSubscriptionRequestOperationSerializer()
            deserializer = AcceptSubscriptionRequestOperationDeserializer()
            operationName = "AcceptSubscriptionRequest"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the subscription to the specified asset.
     */
    override suspend fun cancelSubscription(input: CancelSubscriptionRequest): CancelSubscriptionResponse {
        val op = SdkHttpOperation.build<CancelSubscriptionRequest, CancelSubscriptionResponse> {
            serializer = CancelSubscriptionOperationSerializer()
            deserializer = CancelSubscriptionOperationDeserializer()
            operationName = "CancelSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an asset in Amazon DataZone catalog.
     */
    override suspend fun createAsset(input: CreateAssetRequest): CreateAssetResponse {
        val op = SdkHttpOperation.build<CreateAssetRequest, CreateAssetResponse> {
            serializer = CreateAssetOperationSerializer()
            deserializer = CreateAssetOperationDeserializer()
            operationName = "CreateAsset"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a revision of the asset.
     */
    override suspend fun createAssetRevision(input: CreateAssetRevisionRequest): CreateAssetRevisionResponse {
        val op = SdkHttpOperation.build<CreateAssetRevisionRequest, CreateAssetRevisionResponse> {
            serializer = CreateAssetRevisionOperationSerializer()
            deserializer = CreateAssetRevisionOperationDeserializer()
            operationName = "CreateAssetRevision"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom asset type.
     */
    override suspend fun createAssetType(input: CreateAssetTypeRequest): CreateAssetTypeResponse {
        val op = SdkHttpOperation.build<CreateAssetTypeRequest, CreateAssetTypeResponse> {
            serializer = CreateAssetTypeOperationSerializer()
            deserializer = CreateAssetTypeOperationDeserializer()
            operationName = "CreateAssetType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon DataZone data source.
     */
    override suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse {
        val op = SdkHttpOperation.build<CreateDataSourceRequest, CreateDataSourceResponse> {
            serializer = CreateDataSourceOperationSerializer()
            deserializer = CreateDataSourceOperationDeserializer()
            operationName = "CreateDataSource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon DataZone domain.
     */
    override suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse {
        val op = SdkHttpOperation.build<CreateDomainRequest, CreateDomainResponse> {
            serializer = CreateDomainOperationSerializer()
            deserializer = CreateDomainOperationDeserializer()
            operationName = "CreateDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Create an Amazon DataZone environment.
     */
    override suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse {
        val op = SdkHttpOperation.build<CreateEnvironmentRequest, CreateEnvironmentResponse> {
            serializer = CreateEnvironmentOperationSerializer()
            deserializer = CreateEnvironmentOperationDeserializer()
            operationName = "CreateEnvironment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon DataZone environment profile.
     */
    override suspend fun createEnvironmentProfile(input: CreateEnvironmentProfileRequest): CreateEnvironmentProfileResponse {
        val op = SdkHttpOperation.build<CreateEnvironmentProfileRequest, CreateEnvironmentProfileResponse> {
            serializer = CreateEnvironmentProfileOperationSerializer()
            deserializer = CreateEnvironmentProfileOperationDeserializer()
            operationName = "CreateEnvironmentProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a metadata form type.
     */
    override suspend fun createFormType(input: CreateFormTypeRequest): CreateFormTypeResponse {
        val op = SdkHttpOperation.build<CreateFormTypeRequest, CreateFormTypeResponse> {
            serializer = CreateFormTypeOperationSerializer()
            deserializer = CreateFormTypeOperationDeserializer()
            operationName = "CreateFormType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon DataZone business glossary.
     */
    override suspend fun createGlossary(input: CreateGlossaryRequest): CreateGlossaryResponse {
        val op = SdkHttpOperation.build<CreateGlossaryRequest, CreateGlossaryResponse> {
            serializer = CreateGlossaryOperationSerializer()
            deserializer = CreateGlossaryOperationDeserializer()
            operationName = "CreateGlossary"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a business glossary term.
     */
    override suspend fun createGlossaryTerm(input: CreateGlossaryTermRequest): CreateGlossaryTermResponse {
        val op = SdkHttpOperation.build<CreateGlossaryTermRequest, CreateGlossaryTermResponse> {
            serializer = CreateGlossaryTermOperationSerializer()
            deserializer = CreateGlossaryTermOperationDeserializer()
            operationName = "CreateGlossaryTerm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a group profile in Amazon DataZone.
     */
    override suspend fun createGroupProfile(input: CreateGroupProfileRequest): CreateGroupProfileResponse {
        val op = SdkHttpOperation.build<CreateGroupProfileRequest, CreateGroupProfileResponse> {
            serializer = CreateGroupProfileOperationSerializer()
            deserializer = CreateGroupProfileOperationDeserializer()
            operationName = "CreateGroupProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     *
     */
    override suspend fun createListingChangeSet(input: CreateListingChangeSetRequest): CreateListingChangeSetResponse {
        val op = SdkHttpOperation.build<CreateListingChangeSetRequest, CreateListingChangeSetResponse> {
            serializer = CreateListingChangeSetOperationSerializer()
            deserializer = CreateListingChangeSetOperationDeserializer()
            operationName = "CreateListingChangeSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon DataZone project.
     */
    override suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse {
        val op = SdkHttpOperation.build<CreateProjectRequest, CreateProjectResponse> {
            serializer = CreateProjectOperationSerializer()
            deserializer = CreateProjectOperationDeserializer()
            operationName = "CreateProject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a project membership in Amazon DataZone.
     */
    override suspend fun createProjectMembership(input: CreateProjectMembershipRequest): CreateProjectMembershipResponse {
        val op = SdkHttpOperation.build<CreateProjectMembershipRequest, CreateProjectMembershipResponse> {
            serializer = CreateProjectMembershipOperationSerializer()
            deserializer = CreateProjectMembershipOperationDeserializer()
            operationName = "CreateProjectMembership"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a subsscription grant in Amazon DataZone.
     */
    override suspend fun createSubscriptionGrant(input: CreateSubscriptionGrantRequest): CreateSubscriptionGrantResponse {
        val op = SdkHttpOperation.build<CreateSubscriptionGrantRequest, CreateSubscriptionGrantResponse> {
            serializer = CreateSubscriptionGrantOperationSerializer()
            deserializer = CreateSubscriptionGrantOperationDeserializer()
            operationName = "CreateSubscriptionGrant"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a subscription request in Amazon DataZone.
     */
    override suspend fun createSubscriptionRequest(input: CreateSubscriptionRequestRequest): CreateSubscriptionRequestResponse {
        val op = SdkHttpOperation.build<CreateSubscriptionRequestRequest, CreateSubscriptionRequestResponse> {
            serializer = CreateSubscriptionRequestOperationSerializer()
            deserializer = CreateSubscriptionRequestOperationDeserializer()
            operationName = "CreateSubscriptionRequest"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a subscription target in Amazon DataZone.
     */
    override suspend fun createSubscriptionTarget(input: CreateSubscriptionTargetRequest): CreateSubscriptionTargetResponse {
        val op = SdkHttpOperation.build<CreateSubscriptionTargetRequest, CreateSubscriptionTargetResponse> {
            serializer = CreateSubscriptionTargetOperationSerializer()
            deserializer = CreateSubscriptionTargetOperationDeserializer()
            operationName = "CreateSubscriptionTarget"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user profile in Amazon DataZone.
     */
    override suspend fun createUserProfile(input: CreateUserProfileRequest): CreateUserProfileResponse {
        val op = SdkHttpOperation.build<CreateUserProfileRequest, CreateUserProfileResponse> {
            serializer = CreateUserProfileOperationSerializer()
            deserializer = CreateUserProfileOperationDeserializer()
            operationName = "CreateUserProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Delets an asset in Amazon DataZone.
     */
    override suspend fun deleteAsset(input: DeleteAssetRequest): DeleteAssetResponse {
        val op = SdkHttpOperation.build<DeleteAssetRequest, DeleteAssetResponse> {
            serializer = DeleteAssetOperationSerializer()
            deserializer = DeleteAssetOperationDeserializer()
            operationName = "DeleteAsset"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an asset type in Amazon DataZone.
     */
    override suspend fun deleteAssetType(input: DeleteAssetTypeRequest): DeleteAssetTypeResponse {
        val op = SdkHttpOperation.build<DeleteAssetTypeRequest, DeleteAssetTypeResponse> {
            serializer = DeleteAssetTypeOperationSerializer()
            deserializer = DeleteAssetTypeOperationDeserializer()
            operationName = "DeleteAssetType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a data source in Amazon DataZone.
     */
    override suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse {
        val op = SdkHttpOperation.build<DeleteDataSourceRequest, DeleteDataSourceResponse> {
            serializer = DeleteDataSourceOperationSerializer()
            deserializer = DeleteDataSourceOperationDeserializer()
            operationName = "DeleteDataSource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Amazon DataZone domain.
     */
    override suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse {
        val op = SdkHttpOperation.build<DeleteDomainRequest, DeleteDomainResponse> {
            serializer = DeleteDomainOperationSerializer()
            deserializer = DeleteDomainOperationDeserializer()
            operationName = "DeleteDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an environment in Amazon DataZone.
     */
    override suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse {
        val op = SdkHttpOperation.build<DeleteEnvironmentRequest, DeleteEnvironmentResponse> {
            serializer = DeleteEnvironmentOperationSerializer()
            deserializer = DeleteEnvironmentOperationDeserializer()
            operationName = "DeleteEnvironment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the blueprint configuration in Amazon DataZone.
     */
    override suspend fun deleteEnvironmentBlueprintConfiguration(input: DeleteEnvironmentBlueprintConfigurationRequest): DeleteEnvironmentBlueprintConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteEnvironmentBlueprintConfigurationRequest, DeleteEnvironmentBlueprintConfigurationResponse> {
            serializer = DeleteEnvironmentBlueprintConfigurationOperationSerializer()
            deserializer = DeleteEnvironmentBlueprintConfigurationOperationDeserializer()
            operationName = "DeleteEnvironmentBlueprintConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an environment profile in Amazon DataZone.
     */
    override suspend fun deleteEnvironmentProfile(input: DeleteEnvironmentProfileRequest): DeleteEnvironmentProfileResponse {
        val op = SdkHttpOperation.build<DeleteEnvironmentProfileRequest, DeleteEnvironmentProfileResponse> {
            serializer = DeleteEnvironmentProfileOperationSerializer()
            deserializer = DeleteEnvironmentProfileOperationDeserializer()
            operationName = "DeleteEnvironmentProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Delets and metadata form type in Amazon DataZone.
     */
    override suspend fun deleteFormType(input: DeleteFormTypeRequest): DeleteFormTypeResponse {
        val op = SdkHttpOperation.build<DeleteFormTypeRequest, DeleteFormTypeResponse> {
            serializer = DeleteFormTypeOperationSerializer()
            deserializer = DeleteFormTypeOperationDeserializer()
            operationName = "DeleteFormType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a business glossary in Amazon DataZone.
     */
    override suspend fun deleteGlossary(input: DeleteGlossaryRequest): DeleteGlossaryResponse {
        val op = SdkHttpOperation.build<DeleteGlossaryRequest, DeleteGlossaryResponse> {
            serializer = DeleteGlossaryOperationSerializer()
            deserializer = DeleteGlossaryOperationDeserializer()
            operationName = "DeleteGlossary"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a business glossary term in Amazon DataZone.
     */
    override suspend fun deleteGlossaryTerm(input: DeleteGlossaryTermRequest): DeleteGlossaryTermResponse {
        val op = SdkHttpOperation.build<DeleteGlossaryTermRequest, DeleteGlossaryTermResponse> {
            serializer = DeleteGlossaryTermOperationSerializer()
            deserializer = DeleteGlossaryTermOperationDeserializer()
            operationName = "DeleteGlossaryTerm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     *
     */
    override suspend fun deleteListing(input: DeleteListingRequest): DeleteListingResponse {
        val op = SdkHttpOperation.build<DeleteListingRequest, DeleteListingResponse> {
            serializer = DeleteListingOperationSerializer()
            deserializer = DeleteListingOperationDeserializer()
            operationName = "DeleteListing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a project in Amazon DataZone.
     */
    override suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse {
        val op = SdkHttpOperation.build<DeleteProjectRequest, DeleteProjectResponse> {
            serializer = DeleteProjectOperationSerializer()
            deserializer = DeleteProjectOperationDeserializer()
            operationName = "DeleteProject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes project membership in Amazon DataZone.
     */
    override suspend fun deleteProjectMembership(input: DeleteProjectMembershipRequest): DeleteProjectMembershipResponse {
        val op = SdkHttpOperation.build<DeleteProjectMembershipRequest, DeleteProjectMembershipResponse> {
            serializer = DeleteProjectMembershipOperationSerializer()
            deserializer = DeleteProjectMembershipOperationDeserializer()
            operationName = "DeleteProjectMembership"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes and subscription grant in Amazon DataZone.
     */
    override suspend fun deleteSubscriptionGrant(input: DeleteSubscriptionGrantRequest): DeleteSubscriptionGrantResponse {
        val op = SdkHttpOperation.build<DeleteSubscriptionGrantRequest, DeleteSubscriptionGrantResponse> {
            serializer = DeleteSubscriptionGrantOperationSerializer()
            deserializer = DeleteSubscriptionGrantOperationDeserializer()
            operationName = "DeleteSubscriptionGrant"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a subscription request in Amazon DataZone.
     */
    override suspend fun deleteSubscriptionRequest(input: DeleteSubscriptionRequestRequest): DeleteSubscriptionRequestResponse {
        val op = SdkHttpOperation.build<DeleteSubscriptionRequestRequest, DeleteSubscriptionRequestResponse> {
            serializer = DeleteSubscriptionRequestOperationSerializer()
            deserializer = DeleteSubscriptionRequestOperationDeserializer()
            operationName = "DeleteSubscriptionRequest"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a subscription target in Amazon DataZone.
     */
    override suspend fun deleteSubscriptionTarget(input: DeleteSubscriptionTargetRequest): DeleteSubscriptionTargetResponse {
        val op = SdkHttpOperation.build<DeleteSubscriptionTargetRequest, DeleteSubscriptionTargetResponse> {
            serializer = DeleteSubscriptionTargetOperationSerializer()
            deserializer = DeleteSubscriptionTargetOperationDeserializer()
            operationName = "DeleteSubscriptionTarget"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an Amazon DataZone asset.
     */
    override suspend fun getAsset(input: GetAssetRequest): GetAssetResponse {
        val op = SdkHttpOperation.build<GetAssetRequest, GetAssetResponse> {
            serializer = GetAssetOperationSerializer()
            deserializer = GetAssetOperationDeserializer()
            operationName = "GetAsset"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an Amazon DataZone asset type.
     */
    override suspend fun getAssetType(input: GetAssetTypeRequest): GetAssetTypeResponse {
        val op = SdkHttpOperation.build<GetAssetTypeRequest, GetAssetTypeResponse> {
            serializer = GetAssetTypeOperationSerializer()
            deserializer = GetAssetTypeOperationDeserializer()
            operationName = "GetAssetType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an Amazon DataZone data source.
     */
    override suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse {
        val op = SdkHttpOperation.build<GetDataSourceRequest, GetDataSourceResponse> {
            serializer = GetDataSourceOperationSerializer()
            deserializer = GetDataSourceOperationDeserializer()
            operationName = "GetDataSource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an Amazon DataZone data source run.
     */
    override suspend fun getDataSourceRun(input: GetDataSourceRunRequest): GetDataSourceRunResponse {
        val op = SdkHttpOperation.build<GetDataSourceRunRequest, GetDataSourceRunResponse> {
            serializer = GetDataSourceRunOperationSerializer()
            deserializer = GetDataSourceRunOperationDeserializer()
            operationName = "GetDataSourceRun"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an Amazon DataZone domain.
     */
    override suspend fun getDomain(input: GetDomainRequest): GetDomainResponse {
        val op = SdkHttpOperation.build<GetDomainRequest, GetDomainResponse> {
            serializer = GetDomainOperationSerializer()
            deserializer = GetDomainOperationDeserializer()
            operationName = "GetDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an Amazon DataZone environment.
     */
    override suspend fun getEnvironment(input: GetEnvironmentRequest): GetEnvironmentResponse {
        val op = SdkHttpOperation.build<GetEnvironmentRequest, GetEnvironmentResponse> {
            serializer = GetEnvironmentOperationSerializer()
            deserializer = GetEnvironmentOperationDeserializer()
            operationName = "GetEnvironment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an Amazon DataZone blueprint.
     */
    override suspend fun getEnvironmentBlueprint(input: GetEnvironmentBlueprintRequest): GetEnvironmentBlueprintResponse {
        val op = SdkHttpOperation.build<GetEnvironmentBlueprintRequest, GetEnvironmentBlueprintResponse> {
            serializer = GetEnvironmentBlueprintOperationSerializer()
            deserializer = GetEnvironmentBlueprintOperationDeserializer()
            operationName = "GetEnvironmentBlueprint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the blueprint configuration in Amazon DataZone.
     */
    override suspend fun getEnvironmentBlueprintConfiguration(input: GetEnvironmentBlueprintConfigurationRequest): GetEnvironmentBlueprintConfigurationResponse {
        val op = SdkHttpOperation.build<GetEnvironmentBlueprintConfigurationRequest, GetEnvironmentBlueprintConfigurationResponse> {
            serializer = GetEnvironmentBlueprintConfigurationOperationSerializer()
            deserializer = GetEnvironmentBlueprintConfigurationOperationDeserializer()
            operationName = "GetEnvironmentBlueprintConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets an evinronment profile in Amazon DataZone.
     */
    override suspend fun getEnvironmentProfile(input: GetEnvironmentProfileRequest): GetEnvironmentProfileResponse {
        val op = SdkHttpOperation.build<GetEnvironmentProfileRequest, GetEnvironmentProfileResponse> {
            serializer = GetEnvironmentProfileOperationSerializer()
            deserializer = GetEnvironmentProfileOperationDeserializer()
            operationName = "GetEnvironmentProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a metadata form type in Amazon DataZone.
     */
    override suspend fun getFormType(input: GetFormTypeRequest): GetFormTypeResponse {
        val op = SdkHttpOperation.build<GetFormTypeRequest, GetFormTypeResponse> {
            serializer = GetFormTypeOperationSerializer()
            deserializer = GetFormTypeOperationDeserializer()
            operationName = "GetFormType"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a business glossary in Amazon DataZone.
     */
    override suspend fun getGlossary(input: GetGlossaryRequest): GetGlossaryResponse {
        val op = SdkHttpOperation.build<GetGlossaryRequest, GetGlossaryResponse> {
            serializer = GetGlossaryOperationSerializer()
            deserializer = GetGlossaryOperationDeserializer()
            operationName = "GetGlossary"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a business glossary term in Amazon DataZone.
     */
    override suspend fun getGlossaryTerm(input: GetGlossaryTermRequest): GetGlossaryTermResponse {
        val op = SdkHttpOperation.build<GetGlossaryTermRequest, GetGlossaryTermResponse> {
            serializer = GetGlossaryTermOperationSerializer()
            deserializer = GetGlossaryTermOperationDeserializer()
            operationName = "GetGlossaryTerm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a group profile in Amazon DataZone.
     */
    override suspend fun getGroupProfile(input: GetGroupProfileRequest): GetGroupProfileResponse {
        val op = SdkHttpOperation.build<GetGroupProfileRequest, GetGroupProfileResponse> {
            serializer = GetGroupProfileOperationSerializer()
            deserializer = GetGroupProfileOperationDeserializer()
            operationName = "GetGroupProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the data portal URL for the specified Amazon DataZone domain.
     */
    override suspend fun getIamPortalLoginUrl(input: GetIamPortalLoginUrlRequest): GetIamPortalLoginUrlResponse {
        val op = SdkHttpOperation.build<GetIamPortalLoginUrlRequest, GetIamPortalLoginUrlResponse> {
            serializer = GetIamPortalLoginUrlOperationSerializer()
            deserializer = GetIamPortalLoginUrlOperationDeserializer()
            operationName = "GetIamPortalLoginUrl"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     *
     */
    override suspend fun getListing(input: GetListingRequest): GetListingResponse {
        val op = SdkHttpOperation.build<GetListingRequest, GetListingResponse> {
            serializer = GetListingOperationSerializer()
            deserializer = GetListingOperationDeserializer()
            operationName = "GetListing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a project in Amazon DataZone.
     */
    override suspend fun getProject(input: GetProjectRequest): GetProjectResponse {
        val op = SdkHttpOperation.build<GetProjectRequest, GetProjectResponse> {
            serializer = GetProjectOperationSerializer()
            deserializer = GetProjectOperationDeserializer()
            operationName = "GetProject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a subscription in Amazon DataZone.
     */
    override suspend fun getSubscription(input: GetSubscriptionRequest): GetSubscriptionResponse {
        val op = SdkHttpOperation.build<GetSubscriptionRequest, GetSubscriptionResponse> {
            serializer = GetSubscriptionOperationSerializer()
            deserializer = GetSubscriptionOperationDeserializer()
            operationName = "GetSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the subscription grant in Amazon DataZone.
     */
    override suspend fun getSubscriptionGrant(input: GetSubscriptionGrantRequest): GetSubscriptionGrantResponse {
        val op = SdkHttpOperation.build<GetSubscriptionGrantRequest, GetSubscriptionGrantResponse> {
            serializer = GetSubscriptionGrantOperationSerializer()
            deserializer = GetSubscriptionGrantOperationDeserializer()
            operationName = "GetSubscriptionGrant"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of the specified subscription request.
     */
    override suspend fun getSubscriptionRequestDetails(input: GetSubscriptionRequestDetailsRequest): GetSubscriptionRequestDetailsResponse {
        val op = SdkHttpOperation.build<GetSubscriptionRequestDetailsRequest, GetSubscriptionRequestDetailsResponse> {
            serializer = GetSubscriptionRequestDetailsOperationSerializer()
            deserializer = GetSubscriptionRequestDetailsOperationDeserializer()
            operationName = "GetSubscriptionRequestDetails"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the subscription target in Amazon DataZone.
     */
    override suspend fun getSubscriptionTarget(input: GetSubscriptionTargetRequest): GetSubscriptionTargetResponse {
        val op = SdkHttpOperation.build<GetSubscriptionTargetRequest, GetSubscriptionTargetResponse> {
            serializer = GetSubscriptionTargetOperationSerializer()
            deserializer = GetSubscriptionTargetOperationDeserializer()
            operationName = "GetSubscriptionTarget"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a user profile in Amazon DataZone.
     */
    override suspend fun getUserProfile(input: GetUserProfileRequest): GetUserProfileResponse {
        val op = SdkHttpOperation.build<GetUserProfileRequest, GetUserProfileResponse> {
            serializer = GetUserProfileOperationSerializer()
            deserializer = GetUserProfileOperationDeserializer()
            operationName = "GetUserProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the revisions for the asset.
     */
    override suspend fun listAssetRevisions(input: ListAssetRevisionsRequest): ListAssetRevisionsResponse {
        val op = SdkHttpOperation.build<ListAssetRevisionsRequest, ListAssetRevisionsResponse> {
            serializer = ListAssetRevisionsOperationSerializer()
            deserializer = ListAssetRevisionsOperationDeserializer()
            operationName = "ListAssetRevisions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists data source run activities.
     */
    override suspend fun listDataSourceRunActivities(input: ListDataSourceRunActivitiesRequest): ListDataSourceRunActivitiesResponse {
        val op = SdkHttpOperation.build<ListDataSourceRunActivitiesRequest, ListDataSourceRunActivitiesResponse> {
            serializer = ListDataSourceRunActivitiesOperationSerializer()
            deserializer = ListDataSourceRunActivitiesOperationDeserializer()
            operationName = "ListDataSourceRunActivities"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists data source runs in Amazon DataZone.
     */
    override suspend fun listDataSourceRuns(input: ListDataSourceRunsRequest): ListDataSourceRunsResponse {
        val op = SdkHttpOperation.build<ListDataSourceRunsRequest, ListDataSourceRunsResponse> {
            serializer = ListDataSourceRunsOperationSerializer()
            deserializer = ListDataSourceRunsOperationDeserializer()
            operationName = "ListDataSourceRuns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists data sources in Amazon DataZone.
     */
    override suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse {
        val op = SdkHttpOperation.build<ListDataSourcesRequest, ListDataSourcesResponse> {
            serializer = ListDataSourcesOperationSerializer()
            deserializer = ListDataSourcesOperationDeserializer()
            operationName = "ListDataSources"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists Amazon DataZone domains.
     */
    override suspend fun listDomains(input: ListDomainsRequest): ListDomainsResponse {
        val op = SdkHttpOperation.build<ListDomainsRequest, ListDomainsResponse> {
            serializer = ListDomainsOperationSerializer()
            deserializer = ListDomainsOperationDeserializer()
            operationName = "ListDomains"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists blueprint configurations for a Amazon DataZone environment.
     */
    override suspend fun listEnvironmentBlueprintConfigurations(input: ListEnvironmentBlueprintConfigurationsRequest): ListEnvironmentBlueprintConfigurationsResponse {
        val op = SdkHttpOperation.build<ListEnvironmentBlueprintConfigurationsRequest, ListEnvironmentBlueprintConfigurationsResponse> {
            serializer = ListEnvironmentBlueprintConfigurationsOperationSerializer()
            deserializer = ListEnvironmentBlueprintConfigurationsOperationDeserializer()
            operationName = "ListEnvironmentBlueprintConfigurations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists blueprints in an Amazon DataZone environment.
     */
    override suspend fun listEnvironmentBlueprints(input: ListEnvironmentBlueprintsRequest): ListEnvironmentBlueprintsResponse {
        val op = SdkHttpOperation.build<ListEnvironmentBlueprintsRequest, ListEnvironmentBlueprintsResponse> {
            serializer = ListEnvironmentBlueprintsOperationSerializer()
            deserializer = ListEnvironmentBlueprintsOperationDeserializer()
            operationName = "ListEnvironmentBlueprints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists Amazon DataZone environment profiles.
     */
    override suspend fun listEnvironmentProfiles(input: ListEnvironmentProfilesRequest): ListEnvironmentProfilesResponse {
        val op = SdkHttpOperation.build<ListEnvironmentProfilesRequest, ListEnvironmentProfilesResponse> {
            serializer = ListEnvironmentProfilesOperationSerializer()
            deserializer = ListEnvironmentProfilesOperationDeserializer()
            operationName = "ListEnvironmentProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists Amazon DataZone environments.
     */
    override suspend fun listEnvironments(input: ListEnvironmentsRequest): ListEnvironmentsResponse {
        val op = SdkHttpOperation.build<ListEnvironmentsRequest, ListEnvironmentsResponse> {
            serializer = ListEnvironmentsOperationSerializer()
            deserializer = ListEnvironmentsOperationDeserializer()
            operationName = "ListEnvironments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all Amazon DataZone notifications.
     */
    override suspend fun listNotifications(input: ListNotificationsRequest): ListNotificationsResponse {
        val op = SdkHttpOperation.build<ListNotificationsRequest, ListNotificationsResponse> {
            serializer = ListNotificationsOperationSerializer()
            deserializer = ListNotificationsOperationDeserializer()
            operationName = "ListNotifications"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all members of the specified project.
     */
    override suspend fun listProjectMemberships(input: ListProjectMembershipsRequest): ListProjectMembershipsResponse {
        val op = SdkHttpOperation.build<ListProjectMembershipsRequest, ListProjectMembershipsResponse> {
            serializer = ListProjectMembershipsOperationSerializer()
            deserializer = ListProjectMembershipsOperationDeserializer()
            operationName = "ListProjectMemberships"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists Amazon DataZone projects.
     */
    override suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse {
        val op = SdkHttpOperation.build<ListProjectsRequest, ListProjectsResponse> {
            serializer = ListProjectsOperationSerializer()
            deserializer = ListProjectsOperationDeserializer()
            operationName = "ListProjects"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists subscription grants.
     */
    override suspend fun listSubscriptionGrants(input: ListSubscriptionGrantsRequest): ListSubscriptionGrantsResponse {
        val op = SdkHttpOperation.build<ListSubscriptionGrantsRequest, ListSubscriptionGrantsResponse> {
            serializer = ListSubscriptionGrantsOperationSerializer()
            deserializer = ListSubscriptionGrantsOperationDeserializer()
            operationName = "ListSubscriptionGrants"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists Amazon DataZone subscription requests.
     */
    override suspend fun listSubscriptionRequests(input: ListSubscriptionRequestsRequest): ListSubscriptionRequestsResponse {
        val op = SdkHttpOperation.build<ListSubscriptionRequestsRequest, ListSubscriptionRequestsResponse> {
            serializer = ListSubscriptionRequestsOperationSerializer()
            deserializer = ListSubscriptionRequestsOperationDeserializer()
            operationName = "ListSubscriptionRequests"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists subscription targets in Amazon DataZone.
     */
    override suspend fun listSubscriptionTargets(input: ListSubscriptionTargetsRequest): ListSubscriptionTargetsResponse {
        val op = SdkHttpOperation.build<ListSubscriptionTargetsRequest, ListSubscriptionTargetsResponse> {
            serializer = ListSubscriptionTargetsOperationSerializer()
            deserializer = ListSubscriptionTargetsOperationDeserializer()
            operationName = "ListSubscriptionTargets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists subscriptions in Amazon DataZone.
     */
    override suspend fun listSubscriptions(input: ListSubscriptionsRequest): ListSubscriptionsResponse {
        val op = SdkHttpOperation.build<ListSubscriptionsRequest, ListSubscriptionsResponse> {
            serializer = ListSubscriptionsOperationSerializer()
            deserializer = ListSubscriptionsOperationDeserializer()
            operationName = "ListSubscriptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists tags for the specified resource in Amazon DataZone.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Writes the configuration for the specified environment blueprint in Amazon DataZone.
     */
    override suspend fun putEnvironmentBlueprintConfiguration(input: PutEnvironmentBlueprintConfigurationRequest): PutEnvironmentBlueprintConfigurationResponse {
        val op = SdkHttpOperation.build<PutEnvironmentBlueprintConfigurationRequest, PutEnvironmentBlueprintConfigurationResponse> {
            serializer = PutEnvironmentBlueprintConfigurationOperationSerializer()
            deserializer = PutEnvironmentBlueprintConfigurationOperationDeserializer()
            operationName = "PutEnvironmentBlueprintConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Rejects automatically generated business-friendly metadata for your Amazon DataZone assets.
     */
    override suspend fun rejectPredictions(input: RejectPredictionsRequest): RejectPredictionsResponse {
        val op = SdkHttpOperation.build<RejectPredictionsRequest, RejectPredictionsResponse> {
            serializer = RejectPredictionsOperationSerializer()
            deserializer = RejectPredictionsOperationDeserializer()
            operationName = "RejectPredictions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Rejects the specified subscription request.
     */
    override suspend fun rejectSubscriptionRequest(input: RejectSubscriptionRequestRequest): RejectSubscriptionRequestResponse {
        val op = SdkHttpOperation.build<RejectSubscriptionRequestRequest, RejectSubscriptionRequestResponse> {
            serializer = RejectSubscriptionRequestOperationSerializer()
            deserializer = RejectSubscriptionRequestOperationDeserializer()
            operationName = "RejectSubscriptionRequest"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Revokes a specified subscription in Amazon DataZone.
     */
    override suspend fun revokeSubscription(input: RevokeSubscriptionRequest): RevokeSubscriptionResponse {
        val op = SdkHttpOperation.build<RevokeSubscriptionRequest, RevokeSubscriptionResponse> {
            serializer = RevokeSubscriptionOperationSerializer()
            deserializer = RevokeSubscriptionOperationDeserializer()
            operationName = "RevokeSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches for assets in Amazon DataZone.
     */
    override suspend fun search(input: SearchRequest): SearchResponse {
        val op = SdkHttpOperation.build<SearchRequest, SearchResponse> {
            serializer = SearchOperationSerializer()
            deserializer = SearchOperationDeserializer()
            operationName = "Search"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches group profiles in Amazon DataZone.
     */
    override suspend fun searchGroupProfiles(input: SearchGroupProfilesRequest): SearchGroupProfilesResponse {
        val op = SdkHttpOperation.build<SearchGroupProfilesRequest, SearchGroupProfilesResponse> {
            serializer = SearchGroupProfilesOperationSerializer()
            deserializer = SearchGroupProfilesOperationDeserializer()
            operationName = "SearchGroupProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches listings in Amazon DataZone.
     */
    override suspend fun searchListings(input: SearchListingsRequest): SearchListingsResponse {
        val op = SdkHttpOperation.build<SearchListingsRequest, SearchListingsResponse> {
            serializer = SearchListingsOperationSerializer()
            deserializer = SearchListingsOperationDeserializer()
            operationName = "SearchListings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches for types in Amazon DataZone.
     */
    override suspend fun searchTypes(input: SearchTypesRequest): SearchTypesResponse {
        val op = SdkHttpOperation.build<SearchTypesRequest, SearchTypesResponse> {
            serializer = SearchTypesOperationSerializer()
            deserializer = SearchTypesOperationDeserializer()
            operationName = "SearchTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches user profiles in Amazon DataZone.
     */
    override suspend fun searchUserProfiles(input: SearchUserProfilesRequest): SearchUserProfilesResponse {
        val op = SdkHttpOperation.build<SearchUserProfilesRequest, SearchUserProfilesResponse> {
            serializer = SearchUserProfilesOperationSerializer()
            deserializer = SearchUserProfilesOperationDeserializer()
            operationName = "SearchUserProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Start the run of the specified data source in Amazon DataZone.
     */
    override suspend fun startDataSourceRun(input: StartDataSourceRunRequest): StartDataSourceRunResponse {
        val op = SdkHttpOperation.build<StartDataSourceRunRequest, StartDataSourceRunResponse> {
            serializer = StartDataSourceRunOperationSerializer()
            deserializer = StartDataSourceRunOperationDeserializer()
            operationName = "StartDataSourceRun"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Tags a resource in Amazon DataZone.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Untags a resource in Amazon DataZone.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified data source in Amazon DataZone.
     */
    override suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse {
        val op = SdkHttpOperation.build<UpdateDataSourceRequest, UpdateDataSourceResponse> {
            serializer = UpdateDataSourceOperationSerializer()
            deserializer = UpdateDataSourceOperationDeserializer()
            operationName = "UpdateDataSource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a Amazon DataZone domain.
     */
    override suspend fun updateDomain(input: UpdateDomainRequest): UpdateDomainResponse {
        val op = SdkHttpOperation.build<UpdateDomainRequest, UpdateDomainResponse> {
            serializer = UpdateDomainOperationSerializer()
            deserializer = UpdateDomainOperationDeserializer()
            operationName = "UpdateDomain"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified environment in Amazon DataZone.
     */
    override suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse {
        val op = SdkHttpOperation.build<UpdateEnvironmentRequest, UpdateEnvironmentResponse> {
            serializer = UpdateEnvironmentOperationSerializer()
            deserializer = UpdateEnvironmentOperationDeserializer()
            operationName = "UpdateEnvironment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified environment profile in Amazon DataZone.
     */
    override suspend fun updateEnvironmentProfile(input: UpdateEnvironmentProfileRequest): UpdateEnvironmentProfileResponse {
        val op = SdkHttpOperation.build<UpdateEnvironmentProfileRequest, UpdateEnvironmentProfileResponse> {
            serializer = UpdateEnvironmentProfileOperationSerializer()
            deserializer = UpdateEnvironmentProfileOperationDeserializer()
            operationName = "UpdateEnvironmentProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the business glossary in Amazon DataZone.
     */
    override suspend fun updateGlossary(input: UpdateGlossaryRequest): UpdateGlossaryResponse {
        val op = SdkHttpOperation.build<UpdateGlossaryRequest, UpdateGlossaryResponse> {
            serializer = UpdateGlossaryOperationSerializer()
            deserializer = UpdateGlossaryOperationDeserializer()
            operationName = "UpdateGlossary"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a business glossary term in Amazon DataZone.
     */
    override suspend fun updateGlossaryTerm(input: UpdateGlossaryTermRequest): UpdateGlossaryTermResponse {
        val op = SdkHttpOperation.build<UpdateGlossaryTermRequest, UpdateGlossaryTermResponse> {
            serializer = UpdateGlossaryTermOperationSerializer()
            deserializer = UpdateGlossaryTermOperationDeserializer()
            operationName = "UpdateGlossaryTerm"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified group profile in Amazon DataZone.
     */
    override suspend fun updateGroupProfile(input: UpdateGroupProfileRequest): UpdateGroupProfileResponse {
        val op = SdkHttpOperation.build<UpdateGroupProfileRequest, UpdateGroupProfileResponse> {
            serializer = UpdateGroupProfileOperationSerializer()
            deserializer = UpdateGroupProfileOperationDeserializer()
            operationName = "UpdateGroupProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified project in Amazon DataZone.
     */
    override suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse {
        val op = SdkHttpOperation.build<UpdateProjectRequest, UpdateProjectResponse> {
            serializer = UpdateProjectOperationSerializer()
            deserializer = UpdateProjectOperationDeserializer()
            operationName = "UpdateProject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the status of the specified subscription grant status in Amazon DataZone.
     */
    override suspend fun updateSubscriptionGrantStatus(input: UpdateSubscriptionGrantStatusRequest): UpdateSubscriptionGrantStatusResponse {
        val op = SdkHttpOperation.build<UpdateSubscriptionGrantStatusRequest, UpdateSubscriptionGrantStatusResponse> {
            serializer = UpdateSubscriptionGrantStatusOperationSerializer()
            deserializer = UpdateSubscriptionGrantStatusOperationDeserializer()
            operationName = "UpdateSubscriptionGrantStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a specified subscription request in Amazon DataZone.
     */
    override suspend fun updateSubscriptionRequest(input: UpdateSubscriptionRequestRequest): UpdateSubscriptionRequestResponse {
        val op = SdkHttpOperation.build<UpdateSubscriptionRequestRequest, UpdateSubscriptionRequestResponse> {
            serializer = UpdateSubscriptionRequestOperationSerializer()
            deserializer = UpdateSubscriptionRequestOperationDeserializer()
            operationName = "UpdateSubscriptionRequest"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified subscription target in Amazon DataZone.
     */
    override suspend fun updateSubscriptionTarget(input: UpdateSubscriptionTargetRequest): UpdateSubscriptionTargetResponse {
        val op = SdkHttpOperation.build<UpdateSubscriptionTargetRequest, UpdateSubscriptionTargetResponse> {
            serializer = UpdateSubscriptionTargetOperationSerializer()
            deserializer = UpdateSubscriptionTargetOperationDeserializer()
            operationName = "UpdateSubscriptionTarget"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified user profile in Amazon DataZone.
     */
    override suspend fun updateUserProfile(input: UpdateUserProfileRequest): UpdateUserProfileResponse {
        val op = SdkHttpOperation.build<UpdateUserProfileRequest, UpdateUserProfileResponse> {
            serializer = UpdateUserProfileOperationSerializer()
            deserializer = UpdateUserProfileOperationDeserializer()
            operationName = "UpdateUserProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsentNotNull(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "datazone")
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
    }
}
