// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.paginators

import aws.sdk.kotlin.services.datazone.DataZoneClient
import aws.sdk.kotlin.services.datazone.model.AssetRevision
import aws.sdk.kotlin.services.datazone.model.DataSourceRunActivity
import aws.sdk.kotlin.services.datazone.model.EnvironmentBlueprintSummary
import aws.sdk.kotlin.services.datazone.model.EnvironmentProfileSummary
import aws.sdk.kotlin.services.datazone.model.EnvironmentSummary
import aws.sdk.kotlin.services.datazone.model.GroupProfileSummary
import aws.sdk.kotlin.services.datazone.model.ListAssetRevisionsRequest
import aws.sdk.kotlin.services.datazone.model.ListAssetRevisionsResponse
import aws.sdk.kotlin.services.datazone.model.ListDataSourceRunActivitiesRequest
import aws.sdk.kotlin.services.datazone.model.ListDataSourceRunActivitiesResponse
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentBlueprintsRequest
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentBlueprintsResponse
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentProfilesRequest
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentProfilesResponse
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.datazone.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.datazone.model.ListNotificationsRequest
import aws.sdk.kotlin.services.datazone.model.ListNotificationsResponse
import aws.sdk.kotlin.services.datazone.model.ListProjectMembershipsRequest
import aws.sdk.kotlin.services.datazone.model.ListProjectMembershipsResponse
import aws.sdk.kotlin.services.datazone.model.ListProjectsRequest
import aws.sdk.kotlin.services.datazone.model.ListProjectsResponse
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionGrantsRequest
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionGrantsResponse
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionRequestsRequest
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionRequestsResponse
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionTargetsRequest
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionTargetsResponse
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionsRequest
import aws.sdk.kotlin.services.datazone.model.ListSubscriptionsResponse
import aws.sdk.kotlin.services.datazone.model.NotificationOutput
import aws.sdk.kotlin.services.datazone.model.ProjectMember
import aws.sdk.kotlin.services.datazone.model.ProjectSummary
import aws.sdk.kotlin.services.datazone.model.SearchGroupProfilesRequest
import aws.sdk.kotlin.services.datazone.model.SearchGroupProfilesResponse
import aws.sdk.kotlin.services.datazone.model.SearchInventoryResultItem
import aws.sdk.kotlin.services.datazone.model.SearchListingsRequest
import aws.sdk.kotlin.services.datazone.model.SearchListingsResponse
import aws.sdk.kotlin.services.datazone.model.SearchRequest
import aws.sdk.kotlin.services.datazone.model.SearchResponse
import aws.sdk.kotlin.services.datazone.model.SearchResultItem
import aws.sdk.kotlin.services.datazone.model.SearchTypesRequest
import aws.sdk.kotlin.services.datazone.model.SearchTypesResponse
import aws.sdk.kotlin.services.datazone.model.SearchTypesResultItem
import aws.sdk.kotlin.services.datazone.model.SearchUserProfilesRequest
import aws.sdk.kotlin.services.datazone.model.SearchUserProfilesResponse
import aws.sdk.kotlin.services.datazone.model.SubscriptionGrantSummary
import aws.sdk.kotlin.services.datazone.model.SubscriptionRequestSummary
import aws.sdk.kotlin.services.datazone.model.SubscriptionSummary
import aws.sdk.kotlin.services.datazone.model.SubscriptionTargetSummary
import aws.sdk.kotlin.services.datazone.model.UserProfileSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAssetRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssetRevisionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssetRevisionsResponse]
 */
public fun DataZoneClient.listAssetRevisionsPaginated(initialRequest: ListAssetRevisionsRequest): Flow<ListAssetRevisionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssetRevisionsPaginated.listAssetRevisions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAssetRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssetRevisionsResponse]
 */
public fun DataZoneClient.listAssetRevisionsPaginated(block: ListAssetRevisionsRequest.Builder.() -> Unit): Flow<ListAssetRevisionsResponse> =
    listAssetRevisionsPaginated(ListAssetRevisionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAssetRevisionsPaginated]
 * to access the nested member [AssetRevision]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AssetRevision]
 */
@JvmName("listAssetRevisionsResponseAssetRevision")
public fun Flow<ListAssetRevisionsResponse>.items(): Flow<AssetRevision> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataSourceRunActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSourceRunActivitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourceRunActivitiesResponse]
 */
public fun DataZoneClient.listDataSourceRunActivitiesPaginated(initialRequest: ListDataSourceRunActivitiesRequest): Flow<ListDataSourceRunActivitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSourceRunActivitiesPaginated.listDataSourceRunActivities(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSourceRunActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourceRunActivitiesResponse]
 */
public fun DataZoneClient.listDataSourceRunActivitiesPaginated(block: ListDataSourceRunActivitiesRequest.Builder.() -> Unit): Flow<ListDataSourceRunActivitiesResponse> =
    listDataSourceRunActivitiesPaginated(ListDataSourceRunActivitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataSourceRunActivitiesPaginated]
 * to access the nested member [DataSourceRunActivity]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataSourceRunActivity]
 */
@JvmName("listDataSourceRunActivitiesResponseDataSourceRunActivity")
public fun Flow<ListDataSourceRunActivitiesResponse>.items(): Flow<DataSourceRunActivity> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEnvironmentBlueprintsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEnvironmentBlueprintsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentBlueprintsResponse]
 */
public fun DataZoneClient.listEnvironmentBlueprintsPaginated(initialRequest: ListEnvironmentBlueprintsRequest): Flow<ListEnvironmentBlueprintsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEnvironmentBlueprintsPaginated.listEnvironmentBlueprints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEnvironmentBlueprintsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentBlueprintsResponse]
 */
public fun DataZoneClient.listEnvironmentBlueprintsPaginated(block: ListEnvironmentBlueprintsRequest.Builder.() -> Unit): Flow<ListEnvironmentBlueprintsResponse> =
    listEnvironmentBlueprintsPaginated(ListEnvironmentBlueprintsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEnvironmentBlueprintsPaginated]
 * to access the nested member [EnvironmentBlueprintSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EnvironmentBlueprintSummary]
 */
@JvmName("listEnvironmentBlueprintsResponseEnvironmentBlueprintSummary")
public fun Flow<ListEnvironmentBlueprintsResponse>.items(): Flow<EnvironmentBlueprintSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEnvironmentProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEnvironmentProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentProfilesResponse]
 */
public fun DataZoneClient.listEnvironmentProfilesPaginated(initialRequest: ListEnvironmentProfilesRequest): Flow<ListEnvironmentProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEnvironmentProfilesPaginated.listEnvironmentProfiles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEnvironmentProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentProfilesResponse]
 */
public fun DataZoneClient.listEnvironmentProfilesPaginated(block: ListEnvironmentProfilesRequest.Builder.() -> Unit): Flow<ListEnvironmentProfilesResponse> =
    listEnvironmentProfilesPaginated(ListEnvironmentProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEnvironmentProfilesPaginated]
 * to access the nested member [EnvironmentProfileSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EnvironmentProfileSummary]
 */
@JvmName("listEnvironmentProfilesResponseEnvironmentProfileSummary")
public fun Flow<ListEnvironmentProfilesResponse>.items(): Flow<EnvironmentProfileSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEnvironmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
public fun DataZoneClient.listEnvironmentsPaginated(initialRequest: ListEnvironmentsRequest): Flow<ListEnvironmentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEnvironmentsPaginated.listEnvironments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
public fun DataZoneClient.listEnvironmentsPaginated(block: ListEnvironmentsRequest.Builder.() -> Unit): Flow<ListEnvironmentsResponse> =
    listEnvironmentsPaginated(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEnvironmentsPaginated]
 * to access the nested member [EnvironmentSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EnvironmentSummary]
 */
@JvmName("listEnvironmentsResponseEnvironmentSummary")
public fun Flow<ListEnvironmentsResponse>.items(): Flow<EnvironmentSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListNotificationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNotificationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotificationsResponse]
 */
public fun DataZoneClient.listNotificationsPaginated(initialRequest: ListNotificationsRequest): Flow<ListNotificationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNotificationsPaginated.listNotifications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListNotificationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotificationsResponse]
 */
public fun DataZoneClient.listNotificationsPaginated(block: ListNotificationsRequest.Builder.() -> Unit): Flow<ListNotificationsResponse> =
    listNotificationsPaginated(ListNotificationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listNotificationsPaginated]
 * to access the nested member [NotificationOutput]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NotificationOutput]
 */
@JvmName("listNotificationsResponseNotificationOutput")
public fun Flow<ListNotificationsResponse>.notifications(): Flow<NotificationOutput> =
    transform() { response ->
        response.notifications?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProjectMembershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProjectMembershipsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectMembershipsResponse]
 */
public fun DataZoneClient.listProjectMembershipsPaginated(initialRequest: ListProjectMembershipsRequest): Flow<ListProjectMembershipsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProjectMembershipsPaginated.listProjectMemberships(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProjectMembershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectMembershipsResponse]
 */
public fun DataZoneClient.listProjectMembershipsPaginated(block: ListProjectMembershipsRequest.Builder.() -> Unit): Flow<ListProjectMembershipsResponse> =
    listProjectMembershipsPaginated(ListProjectMembershipsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProjectMembershipsPaginated]
 * to access the nested member [ProjectMember]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProjectMember]
 */
@JvmName("listProjectMembershipsResponseProjectMember")
public fun Flow<ListProjectMembershipsResponse>.members(): Flow<ProjectMember> =
    transform() { response ->
        response.members?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun DataZoneClient.listProjectsPaginated(initialRequest: ListProjectsRequest): Flow<ListProjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProjectsPaginated.listProjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun DataZoneClient.listProjectsPaginated(block: ListProjectsRequest.Builder.() -> Unit): Flow<ListProjectsResponse> =
    listProjectsPaginated(ListProjectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProjectsPaginated]
 * to access the nested member [ProjectSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProjectSummary]
 */
@JvmName("listProjectsResponseProjectSummary")
public fun Flow<ListProjectsResponse>.items(): Flow<ProjectSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSubscriptionGrantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSubscriptionGrantsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionGrantsResponse]
 */
public fun DataZoneClient.listSubscriptionGrantsPaginated(initialRequest: ListSubscriptionGrantsRequest): Flow<ListSubscriptionGrantsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSubscriptionGrantsPaginated.listSubscriptionGrants(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSubscriptionGrantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionGrantsResponse]
 */
public fun DataZoneClient.listSubscriptionGrantsPaginated(block: ListSubscriptionGrantsRequest.Builder.() -> Unit): Flow<ListSubscriptionGrantsResponse> =
    listSubscriptionGrantsPaginated(ListSubscriptionGrantsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSubscriptionGrantsPaginated]
 * to access the nested member [SubscriptionGrantSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SubscriptionGrantSummary]
 */
@JvmName("listSubscriptionGrantsResponseSubscriptionGrantSummary")
public fun Flow<ListSubscriptionGrantsResponse>.items(): Flow<SubscriptionGrantSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSubscriptionRequestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSubscriptionRequestsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionRequestsResponse]
 */
public fun DataZoneClient.listSubscriptionRequestsPaginated(initialRequest: ListSubscriptionRequestsRequest): Flow<ListSubscriptionRequestsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSubscriptionRequestsPaginated.listSubscriptionRequests(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSubscriptionRequestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionRequestsResponse]
 */
public fun DataZoneClient.listSubscriptionRequestsPaginated(block: ListSubscriptionRequestsRequest.Builder.() -> Unit): Flow<ListSubscriptionRequestsResponse> =
    listSubscriptionRequestsPaginated(ListSubscriptionRequestsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSubscriptionRequestsPaginated]
 * to access the nested member [SubscriptionRequestSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SubscriptionRequestSummary]
 */
@JvmName("listSubscriptionRequestsResponseSubscriptionRequestSummary")
public fun Flow<ListSubscriptionRequestsResponse>.items(): Flow<SubscriptionRequestSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionsResponse]
 */
public fun DataZoneClient.listSubscriptionsPaginated(initialRequest: ListSubscriptionsRequest): Flow<ListSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSubscriptionsPaginated.listSubscriptions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionsResponse]
 */
public fun DataZoneClient.listSubscriptionsPaginated(block: ListSubscriptionsRequest.Builder.() -> Unit): Flow<ListSubscriptionsResponse> =
    listSubscriptionsPaginated(ListSubscriptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSubscriptionsPaginated]
 * to access the nested member [SubscriptionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SubscriptionSummary]
 */
@JvmName("listSubscriptionsResponseSubscriptionSummary")
public fun Flow<ListSubscriptionsResponse>.items(): Flow<SubscriptionSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSubscriptionTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSubscriptionTargetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionTargetsResponse]
 */
public fun DataZoneClient.listSubscriptionTargetsPaginated(initialRequest: ListSubscriptionTargetsRequest): Flow<ListSubscriptionTargetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSubscriptionTargetsPaginated.listSubscriptionTargets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSubscriptionTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscriptionTargetsResponse]
 */
public fun DataZoneClient.listSubscriptionTargetsPaginated(block: ListSubscriptionTargetsRequest.Builder.() -> Unit): Flow<ListSubscriptionTargetsResponse> =
    listSubscriptionTargetsPaginated(ListSubscriptionTargetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSubscriptionTargetsPaginated]
 * to access the nested member [SubscriptionTargetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SubscriptionTargetSummary]
 */
@JvmName("listSubscriptionTargetsResponseSubscriptionTargetSummary")
public fun Flow<ListSubscriptionTargetsResponse>.items(): Flow<SubscriptionTargetSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchResponse]
 */
public fun DataZoneClient.searchPaginated(initialRequest: SearchRequest): Flow<SearchResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchPaginated.search(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchResponse]
 */
public fun DataZoneClient.searchPaginated(block: SearchRequest.Builder.() -> Unit): Flow<SearchResponse> =
    searchPaginated(SearchRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchPaginated]
 * to access the nested member [SearchInventoryResultItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchInventoryResultItem]
 */
@JvmName("searchResponseSearchInventoryResultItem")
public fun Flow<SearchResponse>.items(): Flow<SearchInventoryResultItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchGroupProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchGroupProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchGroupProfilesResponse]
 */
public fun DataZoneClient.searchGroupProfilesPaginated(initialRequest: SearchGroupProfilesRequest): Flow<SearchGroupProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchGroupProfilesPaginated.searchGroupProfiles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchGroupProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchGroupProfilesResponse]
 */
public fun DataZoneClient.searchGroupProfilesPaginated(block: SearchGroupProfilesRequest.Builder.() -> Unit): Flow<SearchGroupProfilesResponse> =
    searchGroupProfilesPaginated(SearchGroupProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchGroupProfilesPaginated]
 * to access the nested member [GroupProfileSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GroupProfileSummary]
 */
@JvmName("searchGroupProfilesResponseGroupProfileSummary")
public fun Flow<SearchGroupProfilesResponse>.items(): Flow<GroupProfileSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchListingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchListingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchListingsResponse]
 */
public fun DataZoneClient.searchListingsPaginated(initialRequest: SearchListingsRequest): Flow<SearchListingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchListingsPaginated.searchListings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchListingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchListingsResponse]
 */
public fun DataZoneClient.searchListingsPaginated(block: SearchListingsRequest.Builder.() -> Unit): Flow<SearchListingsResponse> =
    searchListingsPaginated(SearchListingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchListingsPaginated]
 * to access the nested member [SearchResultItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchResultItem]
 */
@JvmName("searchListingsResponseSearchResultItem")
public fun Flow<SearchListingsResponse>.items(): Flow<SearchResultItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchTypesResponse]
 */
public fun DataZoneClient.searchTypesPaginated(initialRequest: SearchTypesRequest): Flow<SearchTypesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchTypesPaginated.searchTypes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchTypesResponse]
 */
public fun DataZoneClient.searchTypesPaginated(block: SearchTypesRequest.Builder.() -> Unit): Flow<SearchTypesResponse> =
    searchTypesPaginated(SearchTypesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchTypesPaginated]
 * to access the nested member [SearchTypesResultItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchTypesResultItem]
 */
@JvmName("searchTypesResponseSearchTypesResultItem")
public fun Flow<SearchTypesResponse>.items(): Flow<SearchTypesResultItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchUserProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchUserProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchUserProfilesResponse]
 */
public fun DataZoneClient.searchUserProfilesPaginated(initialRequest: SearchUserProfilesRequest): Flow<SearchUserProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchUserProfilesPaginated.searchUserProfiles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchUserProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchUserProfilesResponse]
 */
public fun DataZoneClient.searchUserProfilesPaginated(block: SearchUserProfilesRequest.Builder.() -> Unit): Flow<SearchUserProfilesResponse> =
    searchUserProfilesPaginated(SearchUserProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchUserProfilesPaginated]
 * to access the nested member [UserProfileSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UserProfileSummary]
 */
@JvmName("searchUserProfilesResponseUserProfileSummary")
public fun Flow<SearchUserProfilesResponse>.items(): Flow<UserProfileSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
