// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

public class UpdateEnvironmentResponse private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Web Services account in which the environment is to be updated.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The Amazon Web Services Region in which the environment is updated.
     */
    public val awsAccountRegion: kotlin.String? = builder.awsAccountRegion
    /**
     * The timestamp of when the environment was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon DataZone user who created the environment.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The deployment properties to be updated as part of the `UpdateEnvironment` action.
     */
    public val deploymentProperties: aws.sdk.kotlin.services.datazone.model.DeploymentProperties? = builder.deploymentProperties
    /**
     * The description to be updated as part of the `UpdateEnvironment` action.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the domain in which the environment is to be updated.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The environment actions to be updated as part of the `UpdateEnvironment` action.
     */
    public val environmentActions: List<ConfigurableEnvironmentAction>? = builder.environmentActions
    /**
     * The blueprint identifier of the environment.
     */
    public val environmentBlueprintId: kotlin.String? = builder.environmentBlueprintId
    /**
     * The profile identifier of the environment.
     */
    public val environmentProfileId: kotlin.String = requireNotNull(builder.environmentProfileId) { "A non-null value must be provided for environmentProfileId" }
    /**
     * The glossary terms to be updated as part of the `UpdateEnvironment` action.
     */
    public val glossaryTerms: List<String>? = builder.glossaryTerms
    /**
     * The identifier of the environment that is to be updated.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The last deployment of the environment.
     */
    public val lastDeployment: aws.sdk.kotlin.services.datazone.model.Deployment? = builder.lastDeployment
    /**
     * The name to be updated as part of the `UpdateEnvironment` action.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The project identifier of the environment.
     */
    public val projectId: kotlin.String = requireNotNull(builder.projectId) { "A non-null value must be provided for projectId" }
    /**
     * The provider identifier of the environment.
     */
    public val provider: kotlin.String = requireNotNull(builder.provider) { "A non-null value must be provided for provider" }
    /**
     * The provisioned resources to be updated as part of the `UpdateEnvironment` action.
     */
    public val provisionedResources: List<Resource>? = builder.provisionedResources
    /**
     * The provisioning properties to be updated as part of the `UpdateEnvironment` action.
     */
    public val provisioningProperties: aws.sdk.kotlin.services.datazone.model.ProvisioningProperties? = builder.provisioningProperties
    /**
     * The status to be updated as part of the `UpdateEnvironment` action.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.EnvironmentStatus? = builder.status
    /**
     * The timestamp of when the environment was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The user parameters to be updated as part of the `UpdateEnvironment` action.
     */
    public val userParameters: List<CustomParameter>? = builder.userParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.UpdateEnvironmentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEnvironmentResponse(")
        append("awsAccountId=$awsAccountId,")
        append("awsAccountRegion=$awsAccountRegion,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("deploymentProperties=$deploymentProperties,")
        append("description=*** Sensitive Data Redacted ***,")
        append("domainId=$domainId,")
        append("environmentActions=$environmentActions,")
        append("environmentBlueprintId=$environmentBlueprintId,")
        append("environmentProfileId=$environmentProfileId,")
        append("glossaryTerms=$glossaryTerms,")
        append("id=$id,")
        append("lastDeployment=$lastDeployment,")
        append("name=*** Sensitive Data Redacted ***,")
        append("projectId=$projectId,")
        append("provider=$provider,")
        append("provisionedResources=$provisionedResources,")
        append("provisioningProperties=$provisioningProperties,")
        append("status=$status,")
        append("updatedAt=$updatedAt,")
        append("userParameters=$userParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (awsAccountRegion?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (deploymentProperties?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (environmentActions?.hashCode() ?: 0)
        result = 31 * result + (environmentBlueprintId?.hashCode() ?: 0)
        result = 31 * result + (environmentProfileId.hashCode())
        result = 31 * result + (glossaryTerms?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastDeployment?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (projectId.hashCode())
        result = 31 * result + (provider.hashCode())
        result = 31 * result + (provisionedResources?.hashCode() ?: 0)
        result = 31 * result + (provisioningProperties?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (userParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEnvironmentResponse

        if (awsAccountId != other.awsAccountId) return false
        if (awsAccountRegion != other.awsAccountRegion) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (deploymentProperties != other.deploymentProperties) return false
        if (description != other.description) return false
        if (domainId != other.domainId) return false
        if (environmentActions != other.environmentActions) return false
        if (environmentBlueprintId != other.environmentBlueprintId) return false
        if (environmentProfileId != other.environmentProfileId) return false
        if (glossaryTerms != other.glossaryTerms) return false
        if (id != other.id) return false
        if (lastDeployment != other.lastDeployment) return false
        if (name != other.name) return false
        if (projectId != other.projectId) return false
        if (provider != other.provider) return false
        if (provisionedResources != other.provisionedResources) return false
        if (provisioningProperties != other.provisioningProperties) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false
        if (userParameters != other.userParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.UpdateEnvironmentResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the Amazon Web Services account in which the environment is to be updated.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The Amazon Web Services Region in which the environment is updated.
         */
        public var awsAccountRegion: kotlin.String? = null
        /**
         * The timestamp of when the environment was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who created the environment.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The deployment properties to be updated as part of the `UpdateEnvironment` action.
         */
        public var deploymentProperties: aws.sdk.kotlin.services.datazone.model.DeploymentProperties? = null
        /**
         * The description to be updated as part of the `UpdateEnvironment` action.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the domain in which the environment is to be updated.
         */
        public var domainId: kotlin.String? = null
        /**
         * The environment actions to be updated as part of the `UpdateEnvironment` action.
         */
        public var environmentActions: List<ConfigurableEnvironmentAction>? = null
        /**
         * The blueprint identifier of the environment.
         */
        public var environmentBlueprintId: kotlin.String? = null
        /**
         * The profile identifier of the environment.
         */
        public var environmentProfileId: kotlin.String? = null
        /**
         * The glossary terms to be updated as part of the `UpdateEnvironment` action.
         */
        public var glossaryTerms: List<String>? = null
        /**
         * The identifier of the environment that is to be updated.
         */
        public var id: kotlin.String? = null
        /**
         * The last deployment of the environment.
         */
        public var lastDeployment: aws.sdk.kotlin.services.datazone.model.Deployment? = null
        /**
         * The name to be updated as part of the `UpdateEnvironment` action.
         */
        public var name: kotlin.String? = null
        /**
         * The project identifier of the environment.
         */
        public var projectId: kotlin.String? = null
        /**
         * The provider identifier of the environment.
         */
        public var provider: kotlin.String? = null
        /**
         * The provisioned resources to be updated as part of the `UpdateEnvironment` action.
         */
        public var provisionedResources: List<Resource>? = null
        /**
         * The provisioning properties to be updated as part of the `UpdateEnvironment` action.
         */
        public var provisioningProperties: aws.sdk.kotlin.services.datazone.model.ProvisioningProperties? = null
        /**
         * The status to be updated as part of the `UpdateEnvironment` action.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.EnvironmentStatus? = null
        /**
         * The timestamp of when the environment was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user parameters to be updated as part of the `UpdateEnvironment` action.
         */
        public var userParameters: List<CustomParameter>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.UpdateEnvironmentResponse) : this() {
            this.awsAccountId = x.awsAccountId
            this.awsAccountRegion = x.awsAccountRegion
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.deploymentProperties = x.deploymentProperties
            this.description = x.description
            this.domainId = x.domainId
            this.environmentActions = x.environmentActions
            this.environmentBlueprintId = x.environmentBlueprintId
            this.environmentProfileId = x.environmentProfileId
            this.glossaryTerms = x.glossaryTerms
            this.id = x.id
            this.lastDeployment = x.lastDeployment
            this.name = x.name
            this.projectId = x.projectId
            this.provider = x.provider
            this.provisionedResources = x.provisionedResources
            this.provisioningProperties = x.provisioningProperties
            this.status = x.status
            this.updatedAt = x.updatedAt
            this.userParameters = x.userParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.UpdateEnvironmentResponse = UpdateEnvironmentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.DeploymentProperties] inside the given [block]
         */
        public fun deploymentProperties(block: aws.sdk.kotlin.services.datazone.model.DeploymentProperties.Builder.() -> kotlin.Unit) {
            this.deploymentProperties = aws.sdk.kotlin.services.datazone.model.DeploymentProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.Deployment] inside the given [block]
         */
        public fun lastDeployment(block: aws.sdk.kotlin.services.datazone.model.Deployment.Builder.() -> kotlin.Unit) {
            this.lastDeployment = aws.sdk.kotlin.services.datazone.model.Deployment.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdBy == null) createdBy = ""
            if (domainId == null) domainId = ""
            if (environmentProfileId == null) environmentProfileId = ""
            if (name == null) name = ""
            if (projectId == null) projectId = ""
            if (provider == null) provider = ""
            return this
        }
    }
}
